/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.mycomponent;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.cdk.ESBHelper;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.component.AbstractComponentBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeployResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;

public class MyComponentBehaviourImpl extends AbstractComponentBehaviourImpl implements
ComponentBehaviour {

	private final Logger log = Logger.getLogger(MyComponentBehaviourImpl.class
			.getName());


	public MyComponentBehaviourImpl(Component<? extends ComponentType> ep) throws ESBException {
		super(ep);
	}


	@Override
	public EJaxbDeployResponse deploy(EJaxbDeploy request)
			throws ManagementException {
		EJaxbDeployResponse response = new EJaxbDeployResponse();
		response.setDeployementReport(new EJaxbDeployementReport());

		// TODO: Implement the behaviour of component when a resource is deployed
		
		// Note: the method below is just an example and can be deleted
		example(this.endpoint.getNode());
		
		return response;
	}


	public static void example(Node<? extends NodeType> node) throws ManagementException {
		try {
			// Note: The code below is just an example and show how to some primitives to use EasyESB (all codes contained in try/catch can be commented)
			// If you want more information, please contact EasyESB members at: http://research.petalslink.org/display/easyesb/Contact
			// 1- you can create a provider endpoint
			URI providerEndpointReference = ESBHelper.createProviderEndpoint(node, new QName("http://org.easyesb", "myFirstService"), "myFirstFirstProviderEndpoint", EchoBehaviour.class);
			// 2- you can create a client endpoint
			ClientEndpoint<?> clientEndpoint = ESBHelper.createClientEndpoint(node, new QName("http://org.easyesb", "myFirstClientEndpoint"));
			// 3- you can create an exchange like that:
			Exchange exchange = clientEndpoint.createExchange();
			exchange.setDestinationReference(providerEndpointReference);
			exchange.setOperation("echo");
			exchange.setPattern(PatternType.IN_OUT);
			exchange.getMessageIn().getBody().setPayload(DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream("<text>Hello World!!!!</text>".getBytes())));
			// 4- you can send an exchange like that: 
			clientEndpoint.sendSync(exchange, 0);
			System.out.println("Response: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageOut().getBody().getPayload()));
		} catch(Exception e) {
			throw new ManagementException(e.getMessage(), e);
		}
	}


	@Override
	public List<String> getSupportedResourcesExtensions() {
		return Arrays.asList("myExt");
	}


	@Override
	public void start() throws ESBException {
		// TODO Auto-generated method stub

	}


	@Override
	public void stop() throws ESBException {
		// TODO Auto-generated method stub

	}


	@Override
	public EJaxbUndeployResponse undeploy(EJaxbUndeploy parameters)
			throws ManagementException {
		// TODO Auto-generated method stub
		return null;
	}



}
