/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * EasyESB: EasyESB Services Platform
 * Copyright (C) 2005 EBM WebSourcing
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA.
 *
 * Initial developer(s): EBM WebSourcing
 * --------------------------------------------------------------------------
 * $Id: Transporter.java,v 0.3 2005/07/22 10:24:27 alouis Exp $
 * --------------------------------------------------------------------------  
 */

package com.ebmwebsourcing.easyesb.transporter.api.transport;

import java.net.URI;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.transporter.api.transport.lifecycle.LifeCycle;



public interface Transporter extends SCAComponent, LifeCycle {
	
	TransportContext getTransporterContext();
	
	void setTransporterContext(TransportContext context);
	
	void push(Exchange exchange, QName nodeNameToPush) throws TransportException;
		
	Exchange pull(URI providerNodeName, QName nodeNameToPull) throws TransportException;

	boolean isStopped();

}
