/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.transporter.impl.soap;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Body;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageIn;
import com.ebmwebsourcing.easyesb.exchange10.api.type.RoleType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.transporter.impl.soap.SOAPTransporterImpl;
import java.net.URI;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TransporterTest {
    public Exchange createExchange() throws ExchangeException, ParserConfigurationException {
        Exchange ex = (Exchange)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Exchange.class);
        ex.setUuid(UUID.randomUUID().toString());
        ex.setSourceReference(URI.create("esb://http://com.ebmwebsourcing.easyesb@mySource"));
        ex.setDestinationReference(URI.create("esb://http://com.ebmwebsourcing.easyesb@myDestination"));
        ex.setInterfaceName(new QName("http://com.ebmwebsourcing.easyesb", "myItf"));
        ex.setOperation("myOperation");
        ex.setRole(RoleType.CONSUMER);
        ex.setStatus(StatusType.ACTIVE);
        Document request = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
        Element text = request.createElementNS("http://com.ebmwebsourcing.easyesb/", "text");
        text.setNodeValue("helloWorld !!!");
        request.appendChild(text);
        MessageIn msgIn = (MessageIn)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageIn.class);
        Body body = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
        msgIn.setBody(body);
        ex.setMessageIn(msgIn);
        ex.getMessageIn().getBody().setPayload(request);
        return ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPushPullWithoutId() throws TransportException, ExchangeException, ParserConfigurationException, InterruptedException {
        SOAPTransporterImpl transporter1 = new SOAPTransporterImpl(new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node1"), "http://localhost:9004/transport");
        transporter1.getListOfTransporters().put(new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node2"), "http://localhost:9005/transport");
        SOAPTransporterImpl transporter2 = new SOAPTransporterImpl(new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node2"), "http://localhost:9005/transport");
        transporter2.getListOfTransporters().put(new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node1"), "http://localhost:9004/transport");
        try {
            Exchange exchange1 = this.createExchange();
            transporter1.push(exchange1, new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node2"));
            Exchange exchange2 = transporter1.pull(URI.create("esb://http://com.ebmwebsourcing.easyesb@myDestination"), new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node2"));
            Assert.assertNotNull((Object)exchange2);
            System.out.println("!!!!!!!!!!!!!!!!!!! exchange2:\n" + exchange2);
        }
        finally {
            transporter1.stop();
            transporter2.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPushPullWithId() throws TransportException, ExchangeException, ParserConfigurationException, InterruptedException {
        SOAPTransporterImpl transporter1 = new SOAPTransporterImpl(new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node1"), "http://localhost:9004/transport");
        transporter1.getListOfTransporters().put(new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node2"), "http://localhost:9005/transport");
        SOAPTransporterImpl transporter2 = new SOAPTransporterImpl(new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node2"), "http://localhost:9005/transport");
        transporter2.getListOfTransporters().put(new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node1"), "http://localhost:9004/transport");
        try {
            Exchange exchange1 = this.createExchange();
            System.out.println("exchange1.getUuid() = " + exchange1.getUuid());
            transporter1.push(exchange1, new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node2"));
            Exchange exchange2 = transporter1.pull(UUID.fromString(exchange1.getUuid()), URI.create("esb://http://com.ebmwebsourcing.easyesb@myDestination"), new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node2"));
            Assert.assertNotNull((Object)exchange2);
            System.out.println("!!!!!!!!!!!!!!!!!!! exchange2:\n" + exchange2);
        }
        finally {
            transporter1.stop();
            transporter2.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPushOnError() throws ExchangeException, ParserConfigurationException, InterruptedException, TransportException {
        SOAPTransporterImpl transporter1 = new SOAPTransporterImpl(new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node1"), "http://localhost:9004/transport");
        transporter1.getListOfTransporters().put(new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node2"), "http://localhost:9005/transport");
        SOAPTransporterImpl transporter2 = new SOAPTransporterImpl(new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node2"), "http://localhost:9005/transport");
        transporter2.getListOfTransporters().put(new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node1"), "http://localhost:9004/transport");
        Exchange exchange1 = this.createExchange();
        transporter1.push(exchange1, new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node2"));
        Exchange exchange2 = null;
        try {
            exchange2 = transporter1.pull(UUID.fromString(exchange1.getUuid()), URI.create("esb://http://com.ebmwebsourcing.easyesb@myErrorDestination"), new QName("http://com.ebmwebsourcing.easyesb/transporter/", "node2"));
            Assert.fail();
        }
        catch (TransportException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
        finally {
            transporter1.stop();
            transporter2.stop();
        }
    }
}

