/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.admin.client.impl;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImpl;
import com.ebmwebsourcing.easyesb.admin.server.impl.Admin_Server;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import easyesb.petalslink.com.data.admin._1.AddNeighBourNode;
import easyesb.petalslink.com.data.admin._1.AddNeighBourNodeResponse;
import easyesb.petalslink.com.data.admin._1.GetBusinessEndpoints;
import easyesb.petalslink.com.data.admin._1.GetBusinessEndpointsResponse;
import easyesb.petalslink.com.data.admin._1.GetNodeInformations;
import easyesb.petalslink.com.data.admin._1.GetNodeInformationsResponse;
import easyesb.petalslink.com.data.admin._1.MoveEnpointToNode;
import easyesb.petalslink.com.data.admin._1.MoveEnpointToNodeResponse;
import easyesb.petalslink.com.data.admin._1.ObjectFactory;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import junit.framework.Assert;
import org.junit.Test;

public class AdminClientImplTest {
    public static String DEFAULT_ADMIN_ADDRESS = "http://localhost:9000/adminEndpoint";

    public AdminClientImplTest() throws ESBException {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            throw new ESBException((Throwable)e);
        }
    }

    @Test
    public void exposeServiceEndpointInSoap() throws ManagementException {
        Admin_Server adminServer = null;
        try {
            adminServer = new Admin_Server(DEFAULT_ADMIN_ADDRESS);
            AdminClientImpl client = new AdminClientImpl(DEFAULT_ADMIN_ADDRESS);
            String actualResponse = client.exposeServiceEndpointInSoap(new QName("myService"), "myProviderEndpoint");
            Assert.assertEquals((String)"http://localhost:8084/myService/myProviderEndpoint", (String)actualResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage(), e.getCause());
        }
        finally {
            if (adminServer != null) {
                adminServer.stop();
            }
        }
    }

    @Test
    public void createServiceEndpoint() throws ManagementException {
        Admin_Server adminServer = null;
        try {
            adminServer = new Admin_Server(DEFAULT_ADMIN_ADDRESS);
            AdminClientImpl client = new AdminClientImpl(DEFAULT_ADMIN_ADDRESS);
            String actualResponse = client.createServiceEndpoint(new QName("myComponent"), new QName("myService"), "myClassServiceName", "myProviderEndpoint", "myClassProviderEndpointName", "myClassProviderEndpointBehaviour", "myWsdl.wsdl", null);
            Assert.assertEquals((String)"myService", (String)actualResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage(), e.getCause());
        }
        finally {
            if (adminServer != null) {
                adminServer.stop();
            }
        }
    }

    @Test
    public void createProviderEndpoint() throws ManagementException {
        Admin_Server adminServer = null;
        try {
            adminServer = new Admin_Server(DEFAULT_ADMIN_ADDRESS);
            AdminClientImpl client = new AdminClientImpl(DEFAULT_ADMIN_ADDRESS);
            Holder providerEndpoint = new Holder((Object)"myProviderEndpoint");
            client.createProviderEndpoint(new QName("MyService"), providerEndpoint, "myClassProviderEndpointName", "myClassProviderEndpointBehaviour", "myWsdl.wsdl", null);
            Assert.assertEquals((String)"myProviderEndpointAfter", (String)((String)providerEndpoint.value));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage(), e.getCause());
        }
        finally {
            if (adminServer != null) {
                adminServer.stop();
            }
        }
    }

    @Test
    public void createService() throws ManagementException {
        Admin_Server adminServer = null;
        try {
            adminServer = new Admin_Server(DEFAULT_ADMIN_ADDRESS);
            AdminClientImpl client = new AdminClientImpl(DEFAULT_ADMIN_ADDRESS);
            Holder serviceName = new Holder((Object)new QName("myService"));
            client.createService(new QName("myComponent"), serviceName, "myClassServiceName");
            Assert.assertEquals((String)"myServiceAfter", (String)((QName)serviceName.value).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage(), e.getCause());
        }
        finally {
            if (adminServer != null) {
                adminServer.stop();
            }
        }
    }

    @Test
    public void getNodeInformations() throws ManagementException {
        Admin_Server adminServer = null;
        try {
            adminServer = new Admin_Server(DEFAULT_ADMIN_ADDRESS);
            AdminClientImpl client = new AdminClientImpl(DEFAULT_ADMIN_ADDRESS);
            Holder serviceName = new Holder((Object)new QName("myServiceName"));
            GetNodeInformationsResponse res = client.getNodeInformations(new GetNodeInformations());
            Assert.assertNotNull((Object)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage(), e.getCause());
        }
        finally {
            if (adminServer != null) {
                adminServer.stop();
            }
        }
    }

    @Test
    public void importSoapEndpoint() throws ManagementException {
        Admin_Server adminServer = null;
        try {
            adminServer = new Admin_Server(DEFAULT_ADMIN_ADDRESS);
            AdminClientImpl client = new AdminClientImpl(DEFAULT_ADMIN_ADDRESS);
            String res = client.importSoapEndpoint("http://localhost:8084/importClientEndpoint", "myWsdl.wsdl");
            Assert.assertEquals((String)"http://localhost:8084/importClientEndpoint", (String)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage(), e.getCause());
        }
        finally {
            if (adminServer != null) {
                adminServer.stop();
            }
        }
    }

    @Test
    public void getBusinessEndpoints() throws ManagementException {
        Admin_Server adminServer = null;
        try {
            adminServer = new Admin_Server(DEFAULT_ADMIN_ADDRESS);
            AdminClientImpl client = new AdminClientImpl(DEFAULT_ADMIN_ADDRESS);
            GetBusinessEndpointsResponse res = client.getBusinessEndpoints(new GetBusinessEndpoints());
            Assert.assertNotNull((Object)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage(), e.getCause());
        }
        finally {
            if (adminServer != null) {
                adminServer.stop();
            }
        }
    }

    @Test
    public void createClientEndpoint() throws ManagementException {
        Admin_Server adminServer = null;
        try {
            adminServer = new Admin_Server(DEFAULT_ADMIN_ADDRESS);
            AdminClientImpl client = new AdminClientImpl(DEFAULT_ADMIN_ADDRESS);
            Holder clientEndpointName = new Holder((Object)new QName("myClientEndpointName"));
            client.createClientEndpoint(clientEndpointName, "myClassClientEndpointName", "myClassClientEndpointBehaviourName", null);
            Assert.assertEquals((String)"myClientEndpointNameAfter", (String)((QName)clientEndpointName.value).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage(), e.getCause());
        }
        finally {
            if (adminServer != null) {
                adminServer.stop();
            }
        }
    }

    @Test
    public void wrapSoapEndpoint() throws ManagementException {
        Admin_Server adminServer = null;
        try {
            adminServer = new Admin_Server(DEFAULT_ADMIN_ADDRESS);
            AdminClientImpl client = new AdminClientImpl(DEFAULT_ADMIN_ADDRESS);
            String soapAddress = "http://localhost:8084/wrapSoapEndpoint";
            String consumerSoapAddress = client.wrapSoapEndpoint(soapAddress, "myWsdl.wsdl", null);
            Assert.assertEquals((String)"http://localhost:8084/wrapSoapEndpointAfter", (String)consumerSoapAddress);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage(), e.getCause());
        }
        finally {
            if (adminServer != null) {
                adminServer.stop();
            }
        }
    }

    @Test
    public void createComponent() throws ManagementException {
        Admin_Server adminServer = null;
        try {
            adminServer = new Admin_Server(DEFAULT_ADMIN_ADDRESS);
            AdminClientImpl client = new AdminClientImpl(DEFAULT_ADMIN_ADDRESS);
            Holder componentName = new Holder((Object)new String("myComponentName"));
            client.createComponent(componentName, "myClassComponentName");
            Assert.assertEquals((String)"myComponentNameAfter", (String)((String)componentName.value).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage(), e.getCause());
        }
        finally {
            if (adminServer != null) {
                adminServer.stop();
            }
        }
    }

    @Test
    public void moveEnpointToNode() throws ManagementException {
        Admin_Server adminServer = null;
        try {
            adminServer = new Admin_Server(DEFAULT_ADMIN_ADDRESS);
            AdminClientImpl client = new AdminClientImpl(DEFAULT_ADMIN_ADDRESS);
            MoveEnpointToNodeResponse res = client.moveEnpointToNode(new MoveEnpointToNode());
            Assert.assertNotNull((Object)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage(), e.getCause());
        }
        finally {
            if (adminServer != null) {
                adminServer.stop();
            }
        }
    }

    @Test
    public void addNeighBourNode() throws ManagementException {
        Admin_Server adminServer = null;
        try {
            adminServer = new Admin_Server(DEFAULT_ADMIN_ADDRESS);
            AdminClientImpl client = new AdminClientImpl(DEFAULT_ADMIN_ADDRESS);
            AddNeighBourNodeResponse res = client.addNeighBourNode(new AddNeighBourNode());
            Assert.assertNotNull((Object)res);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage(), e.getCause());
        }
        finally {
            if (adminServer != null) {
                adminServer.stop();
            }
        }
    }

    @Test
    public void stop() throws ManagementException {
        Admin_Server adminServer = null;
        try {
            adminServer = new Admin_Server(DEFAULT_ADMIN_ADDRESS);
            AdminClientImpl client = new AdminClientImpl(DEFAULT_ADMIN_ADDRESS);
            client.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ManagementException(e.getMessage(), e.getCause());
        }
        finally {
            if (adminServer != null) {
                adminServer.stop();
            }
        }
    }
}

