/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyevent;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyevent.AbstractEventSender;
import com.ebmwebsourcing.easyevent.AbstractProducersLocalisationManager;
import com.ebmwebsourcing.wsaddressing10.api.element.EndpointReference;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.implementor.WsrfbfModelFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.WsrfbfModelFactoryImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.implementor.WsnbModelFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.SubscribeResponseImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.UnsubscribeResponseImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Notify;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Unsubscribe;
import com.ebmwebsourcing.wsstar.jaxb.notification.topics.ObjectFactory;
import com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.GetResourcePropertyResponse;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.implementor.WsrfrModelFactory;
import com.ebmwebsourcing.wsstar.resource.datatypes.impl.impl.WsrfrModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.implementor.WsrfrlModelFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.impl.impl.WsrfrlModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourceProperties;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateResourcePropertiesResponse;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.abstraction.UpdateType;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.implementor.WsrfrpModelFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.refinedabstraction.RefinedWsrfrpFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.utils.WsrfrpException;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl.WsrfrpModelFactoryImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.implementor.WstopModelFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.utils.WstopException;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.TopicSetTypeImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.NotificationProducerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.SubscriptionManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.TopicsManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import easyevent.petalslink.com.service.proxyeventmanager.admin._1_0.AddEventRegistryFault;
import easyevent.petalslink.com.service.proxyeventmanager.admin._1_0.AdminProxyEventManager;
import easyevent.petalslink.com.service.proxyeventmanager.admin._1_0.GetEventRegistriesFault;
import easyevent.petalslink.com.service.proxyeventmanager.admin._1_0.RemoveEventRegistryFault;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@WebService(serviceName="AdminProxyEventManagerService", portName="AdminProxyEventManagerSOAPEndpoint", targetNamespace="http://com.petalslink.easyevent/service/proxyeventmanager/admin/1.0", wsdlLocation="wsdl/proxyEventManager10.wsdl", endpointInterface="easyevent.petalslink.com.service.proxyeventmanager.admin._1_0.AdminProxyEventManager")
public class AdminProxyEventManagerImpl
implements AdminProxyEventManager {
    private static final Logger LOG = Logger.getLogger(AdminProxyEventManagerImpl.class.getName());
    private static ObjectFactory topicFactory;
    private SubscriptionManagerEngine subsMgrEngine = null;
    private TopicsManagerEngine topicsMgrEngine = null;
    private NotificationProducerEngine notifProdEngine = null;
    private AbstractProducersLocalisationManager producersLocator = null;
    private AbstractEventSender eventSender = null;
    private TopicSetType topicSet = null;
    private Mode mode = null;
    private int notificationReceived = 0;

    public AdminProxyEventManagerImpl(Mode mode, AbstractProducersLocalisationManager producersLocator, AbstractEventSender eventSender) throws WsnbException {
        if (mode == null) {
            throw new WsnbException("mode cannot be null!!!");
        }
        if (producersLocator == null) {
            throw new WsnbException("producersLocator cannot be null!!!");
        }
        if (eventSender == null) {
            throw new WsnbException("eventSender cannot be null!!!");
        }
        this.topicsMgrEngine = new TopicsManagerEngine();
        this.subsMgrEngine = new SubscriptionManagerEngine(LOG);
        this.subsMgrEngine.setSubscriptionsManagerEdp(this.getClass().getAnnotation(WebService.class).portName());
        this.subsMgrEngine.setSubscriptionsManagerInterface(new QName(this.getClass().getAnnotation(WebService.class).targetNamespace(), AdminProxyEventManager.class.getSimpleName()));
        this.subsMgrEngine.setSubscriptionsManagerService(new QName(this.getClass().getAnnotation(WebService.class).targetNamespace(), this.getClass().getAnnotation(WebService.class).serviceName()));
        this.topicSet = RefinedWstopFactory.getInstance((WstopModelFactory)new WstopModelFactoryImpl()).createTopicSetType();
        this.mode = mode;
        this.producersLocator = producersLocator;
        this.eventSender = eventSender;
        this.notifProdEngine = new NotificationProducerEngine(LOG, this.topicsMgrEngine, this.subsMgrEngine, false, this.topicSet, null, "wsn", null);
    }

    @Override
    public GetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest) throws ResourceUnknownFault, InvalidResourcePropertyQNameFault, ResourceUnavailableFault {
        LOG.info("Executing operation getResourceProperty");
        System.out.println(getResourcePropertyRequest);
        GetResourcePropertyResponse _return = new GetResourcePropertyResponse();
        if ("TopicSet".equals(getResourcePropertyRequest.getLocalPart()) && "http://docs.oasis-open.org/wsn/t-1".equals(getResourcePropertyRequest.getNamespaceURI())) {
            JAXBElement top = topicFactory.createTopicSet(TopicSetTypeImpl.toJaxbModel((TopicSetType)this.topicSet));
            _return.getAny().add(top);
        }
        return _return;
    }

    @Override
    public synchronized com.ebmwebsourcing.wsstar.jaxb.notification.base.UnsubscribeResponse unsubscribe(Unsubscribe unsubscribeRequest) throws ResourceUnknownFault, UnableToDestroySubscriptionFault {
        LOG.info("Executing operation unsubscribe");
        System.out.println(unsubscribeRequest);
        com.ebmwebsourcing.wsstar.jaxb.notification.base.UnsubscribeResponse _return = new com.ebmwebsourcing.wsstar.jaxb.notification.base.UnsubscribeResponse();
        try {
            Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)unsubscribeRequest);
            UnsubscribeResponse response = this.subsMgrEngine.unsubscribe(Wsnb4ServUtils.getWsnbReader().readUnsubscribe(doc));
            _return = UnsubscribeResponseImpl.toJaxbModel((UnsubscribeResponse)response);
        }
        catch (SOAException e) {
            throw new UnableToDestroySubscriptionFault(e.getMessage(), e);
        }
        catch (WsnbException e) {
            throw new UnableToDestroySubscriptionFault(e.getMessage(), e);
        }
        catch (AbsWSStarFault e) {
            throw new UnableToDestroySubscriptionFault(e.getMessage(), e);
        }
        return _return;
    }

    @Override
    public synchronized SubscribeResponse subscribe(com.ebmwebsourcing.wsstar.jaxb.notification.base.Subscribe subscribeRequest) throws UnsupportedPolicyRequestFault, SubscribeCreationFailedFault, InvalidMessageContentExpressionFault, UnacceptableInitialTerminationTimeFault, InvalidProducerPropertiesExpressionFault, NotifyMessageNotSupportedFault, ResourceUnknownFault, InvalidTopicExpressionFault, TopicNotSupportedFault, InvalidFilterFault, TopicExpressionDialectUnknownFault, UnrecognizedPolicyRequestFault {
        LOG.info("Executing operation subscribe");
        System.out.println(subscribeRequest);
        SubscribeResponse _return = null;
        try {
            Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)subscribeRequest);
            System.out.println("SUBSCRIBE IN PEM: \n" + XMLPrettyPrinter.prettyPrint((Document)doc));
            Subscribe subscribe = Wsnb4ServUtils.getWsnbReader().readSubscribe(doc);
            List<QName> topics = this.findTopics(subscribe);
            if (Mode.BROKER.equals((Object)this.mode)) {
                EndpointReferenceType consume = subscribe.getConsumerReference();
                subscribe.setConsumerReference((EndpointReferenceType)this.eventSender.getExternalAddressToReceiveNotification());
                for (QName topic : topics) {
                    List<EndpointReference> eprs;
                    if (this.isKnownTopic(topic) || (eprs = this.producersLocator.getProducers(topic)) == null) continue;
                    for (EndpointReference epr : eprs) {
                        this.eventSender.subscribe((EndpointReferenceType)epr, subscribe);
                    }
                }
                subscribe.setConsumerReference(consume);
            } else if (Mode.SUBSCRIBER.equals((Object)this.mode)) {
                this.notificationReceived = 0;
                for (QName topic : topics) {
                    if (!this.isKnownTopic(topic)) {
                        List<EndpointReference> eprs = this.producersLocator.getProducers(topic);
                        if (eprs == null) continue;
                        for (EndpointReference epr : eprs) {
                            this.eventSender.subscribe((EndpointReferenceType)epr, subscribe);
                        }
                        continue;
                    }
                    LOG.warning("topic \"" + topic + "\" not found in proxy event manager");
                    System.out.println("fffffffffffffffffffffffffff topic \"" + topic + "\" not found in proxy event manager");
                }
            }
            for (QName topic : topics) {
                if (this.isKnownTopic(topic)) continue;
                Element elmt = null;
                Document d = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                elmt = topic.getNamespaceURI() != null && topic.getNamespaceURI().trim().length() > 0 ? d.createElementNS(topic.getNamespaceURI(), topic.getLocalPart()) : d.createElement(topic.getLocalPart());
                Attr topicAttr = d.createAttributeNS("http://docs.oasis-open.org/wsn/t-1", "topic");
                topicAttr.setPrefix("wstop");
                topicAttr.setValue("true");
                elmt.setAttributeNodeNS(topicAttr);
                this.topicSet.addTopicsTree(elmt);
                System.out.println("apres: topciset: \n" + XMLPrettyPrinter.prettyPrint((Document)RefinedWstopFactory.getInstance((WstopModelFactory)new WstopModelFactoryImpl()).getWstopWriter().writeTopicSetTypeAsDOM(this.topicSet)));
                Document topicSetAsDOM = RefinedWstopFactory.getInstance().getWstopWriter().writeTopicSetTypeAsDOM(this.topicSet);
                ArrayList<Element> properties = new ArrayList<Element>();
                properties.add(topicSetAsDOM.getDocumentElement());
                UpdateType content = RefinedWsrfrpFactory.getInstance().createUpdateType(properties);
                UpdateResourceProperties updateRequest = RefinedWsrfrpFactory.getInstance().createUpdateResourceProperties(content);
                UpdateResourcePropertiesResponse updateResponse = this.notifProdEngine.updateResourceProperties(updateRequest);
            }
            System.out.println("Subscribe doc: \n" + XMLPrettyPrinter.prettyPrint((Document)doc));
            com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse response = this.notifProdEngine.subscribe(subscribe);
            _return = SubscribeResponseImpl.toJaxbModel((com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse)response);
        }
        catch (SOAException e) {
            throw new SubscribeCreationFailedFault(e.getMessage(), e);
        }
        catch (WsnbException e) {
            throw new SubscribeCreationFailedFault(e.getMessage(), e);
        }
        catch (AbsWSStarFault e) {
            throw new SubscribeCreationFailedFault(e.getMessage(), e);
        }
        catch (DOMException e) {
            throw new SubscribeCreationFailedFault(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new SubscribeCreationFailedFault(e.getMessage(), e);
        }
        catch (WstopException e) {
            throw new SubscribeCreationFailedFault(e.getMessage(), e);
        }
        catch (WsrfrpException e) {
            throw new SubscribeCreationFailedFault(e.getMessage(), e);
        }
        return _return;
    }

    private List<QName> findTopics(Subscribe subscribe) {
        ArrayList<QName> topics = new ArrayList<QName>();
        for (TopicExpressionType topicExp : subscribe.getFilter().getTopicExpressions()) {
            String prefix = null;
            String lp = null;
            String ns = null;
            if (topicExp.getContent().contains(":")) {
                prefix = topicExp.getContent().split(":")[0];
                lp = topicExp.getContent().split(":")[1];
            } else {
                lp = QName.valueOf(topicExp.getContent()).getLocalPart();
                ns = QName.valueOf(topicExp.getContent()).getNamespaceURI();
            }
            if (prefix != null) {
                for (QName name : topicExp.getTopicNamespaces()) {
                    if (!name.getLocalPart().equals(prefix)) continue;
                    ns = name.getNamespaceURI();
                    break;
                }
            }
            QName topic = new QName(ns, lp, prefix);
            topics.add(topic);
        }
        return topics;
    }

    private boolean isKnownTopic(QName topic) {
        for (Element t : this.topicSet.getTopicsTrees()) {
            String lp = t.getLocalName();
            if (lp == null) {
                lp = t.getNodeName();
            }
            if (!lp.equals(topic.getLocalPart())) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void notify(Notify notify) {
        LOG.info("Executing operation notify");
        ++this.notificationReceived;
        try {
            Document doc = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)notify);
            System.out.println("Notify: \n" + XMLPrettyPrinter.prettyPrint((Document)doc));
            com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify notif = Wsnb4ServUtils.getWsnbReader().readNotify(doc);
            for (NotificationMessageHolderType nmh : notif.getNotificationMessage()) {
                TopicExpressionType topicExpInNotif = nmh.getTopic();
                QName topicInNotif = this.getTopicQName(topicExpInNotif);
                List uuids = this.subsMgrEngine.getStoredSubscriptionUuids();
                for (String subscriptionId : uuids) {
                    List topicExps = this.subsMgrEngine.getTopicExpressionOfSubscription(subscriptionId);
                    if (topicExps == null) continue;
                    for (TopicExpressionType topicExpInSubscriber : topicExps) {
                        QName topicInSubscriber;
                        if (topicExpInSubscriber == null || !topicInNotif.equals(topicInSubscriber = this.getTopicQName(topicExpInSubscriber))) continue;
                        EndpointReferenceType currentConsumerEdp = this.subsMgrEngine.getConsumerEdpRefOfSubscription(subscriptionId);
                        this.eventSender.notify(currentConsumerEdp, notif);
                    }
                }
            }
        }
        catch (WsnbException e) {
            e.printStackTrace();
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }

    private QName getTopicQName(TopicExpressionType topicExp) {
        QName res = null;
        String[] qns = topicExp.getContent().split(":");
        if (qns.length == 2) {
            String prefix = qns[0];
            String localpart = qns[1];
            String ns = null;
            for (QName qn : topicExp.getTopicNamespaces()) {
                if (!qn.getPrefix().equals(prefix)) continue;
                ns = qn.getNamespaceURI();
                break;
            }
            res = new QName(ns, localpart, prefix);
        }
        return res;
    }

    public int getNotificationReceived() {
        return this.notificationReceived;
    }

    @Override
    public void removeEventRegistry(String address) throws RemoveEventRegistryFault {
        this.producersLocator.removeEventRegitry(address);
    }

    @Override
    public void addEventRegistry(String address) throws AddEventRegistryFault {
        this.producersLocator.addEventRegitry(address);
    }

    @Override
    public List<String> getEventRegistries() throws GetEventRegistriesFault {
        ArrayList<String> addresses = new ArrayList<String>();
        for (EndpointReference epr : this.producersLocator.getEventRegistries()) {
            addresses.add(epr.getAddress().getValue().toString());
        }
        return addresses;
    }

    static {
        Wsnb4ServUtils.initModelFactories((WsrfbfModelFactory)new WsrfbfModelFactoryImpl(), (WsrfrModelFactory)new WsrfrModelFactoryImpl(), (WsrfrlModelFactory)new WsrfrlModelFactoryImpl(), (WsrfrpModelFactory)new WsrfrpModelFactoryImpl(), (WstopModelFactory)new WstopModelFactoryImpl(), (WsnbModelFactory)new WsnbModelFactoryImpl());
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{com.ebmwebsourcing.wsstar.jaxb.notification.base.ObjectFactory.class, ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
        topicFactory = new ObjectFactory();
    }

    public static enum Mode {
        SUBSCRIBER,
        BROKER;

    }
}

