/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyschema10.api.with;

import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easyschema10.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easyschema10.api.element.ComplexType;
import com.ebmwebsourcing.easyschema10.api.with.WithComplexTypes;
import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class WithComplexTypesTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_COMPLEXTYPES = "expectedComplexTypes";

    public WithComplexTypesTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetComplexTypes() {
        WithComplexTypes complexTypes = (WithComplexTypes)this.newXmlObjectUnderTest();
        Object[] expectedComplexTypes = (ComplexType[])this.getTestData(EXPECTED_COMPLEXTYPES);
        Assert.assertArrayEquals((Object[])expectedComplexTypes, (Object[])complexTypes.getComplexTypes());
    }

    @Test
    public void testGetComplexTypeByName() {
        ComplexType[] expectedComplexTypes;
        WithComplexTypes complexTypes = (WithComplexTypes)this.newXmlObjectUnderTest();
        for (ComplexType expectedComplexType : expectedComplexTypes = (ComplexType[])this.getTestData(EXPECTED_COMPLEXTYPES)) {
            if (expectedComplexType.getName() == null) continue;
            Assert.assertEquals((Object)expectedComplexType, (Object)complexTypes.getComplexTypeByName(expectedComplexType.getName()));
        }
    }

    @Test
    public void testAddComplexType() {
        WithComplexTypes complexTypes = (WithComplexTypes)this.newXmlObjectUnderTest();
        LinkedList<ComplexType> expectedComplexTypes = new LinkedList<ComplexType>(Arrays.asList((ComplexType[])this.getTestData(EXPECTED_COMPLEXTYPES)));
        ComplexType newComplexType = (ComplexType)this.getXmlContext().getXmlObjectFactory().create(ComplexType.class);
        newComplexType.setName("newComplexTypeName");
        newComplexType.setId("newComplexTypeId");
        expectedComplexTypes.add(newComplexType);
        complexTypes.addComplexType(newComplexType);
        Assert.assertEquals(expectedComplexTypes, Arrays.asList(complexTypes.getComplexTypes()));
    }

    @Test
    public void testRemoveComplexType() {
        WithComplexTypes complexTypes = (WithComplexTypes)this.newXmlObjectUnderTest();
        for (ComplexType e : complexTypes.getComplexTypes()) {
            complexTypes.removeComplexType(e);
            Assert.assertFalse((boolean)Arrays.asList(complexTypes.getComplexTypes()).contains(e));
        }
    }

    @Test
    public void testClearComplexTypes() {
        WithComplexTypes complexTypes = (WithComplexTypes)this.newXmlObjectUnderTest();
        complexTypes.clearComplexTypes();
        Assert.assertEquals((long)0L, (long)complexTypes.getComplexTypes().length);
    }

    @Test
    public void testGetParentAfterAdding() {
        WithComplexTypes complexTypes = (WithComplexTypes)this.newXmlObjectUnderTest();
        ComplexType newComplexType = (ComplexType)this.getXmlContext().getXmlObjectFactory().create(ComplexType.class);
        complexTypes.addComplexType(newComplexType);
        Assert.assertEquals((Object)complexTypes, (Object)newComplexType.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterRemoval() {
        WithComplexTypes complexTypes = (WithComplexTypes)this.newXmlObjectUnderTest();
        ComplexType newComplexType = (ComplexType)this.getXmlContext().getXmlObjectFactory().create(ComplexType.class);
        complexTypes.addComplexType(newComplexType);
        complexTypes.removeComplexType(newComplexType);
        Assert.assertNull((Object)newComplexType.getXmlObjectParent());
    }
}

