/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyschema10.api.with;

import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easyschema10.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easyschema10.api.element.Include;
import com.ebmwebsourcing.easyschema10.api.with.WithIncludes;
import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class WithIncludesTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_INCLUDES = "expectedIncludes";

    public WithIncludesTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetIncludes() {
        WithIncludes includes = (WithIncludes)this.newXmlObjectUnderTest();
        Object[] expectedIncludes = (Include[])this.getTestData(EXPECTED_INCLUDES);
        Assert.assertArrayEquals((Object[])expectedIncludes, (Object[])includes.getIncludes());
    }

    @Test
    public void testAddInclude() {
        WithIncludes includes = (WithIncludes)this.newXmlObjectUnderTest();
        LinkedList<Include> expectedIncludes = new LinkedList<Include>(Arrays.asList((Include[])this.getTestData(EXPECTED_INCLUDES)));
        Include newInclude = (Include)this.getXmlContext().getXmlObjectFactory().create(Include.class);
        newInclude.setId("newIncludeId");
        expectedIncludes.add(newInclude);
        includes.addInclude(newInclude);
        Assert.assertEquals(expectedIncludes, Arrays.asList(includes.getIncludes()));
    }

    @Test
    public void testRemoveInclude() {
        WithIncludes includes = (WithIncludes)this.newXmlObjectUnderTest();
        for (Include e : includes.getIncludes()) {
            includes.removeInclude(e);
            Assert.assertFalse((boolean)Arrays.asList(includes.getIncludes()).contains(e));
        }
    }

    @Test
    public void testClearIncludes() {
        WithIncludes includes = (WithIncludes)this.newXmlObjectUnderTest();
        includes.clearIncludes();
        Assert.assertEquals((long)0L, (long)includes.getIncludes().length);
    }

    @Test
    public void testGetParentAfterAdding() {
        WithIncludes includes = (WithIncludes)this.newXmlObjectUnderTest();
        Include newInclude = (Include)this.getXmlContext().getXmlObjectFactory().create(Include.class);
        includes.addInclude(newInclude);
        Assert.assertEquals((Object)includes, (Object)newInclude.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterRemoval() {
        WithIncludes includes = (WithIncludes)this.newXmlObjectUnderTest();
        Include newInclude = (Include)this.getXmlContext().getXmlObjectFactory().create(Include.class);
        includes.addInclude(newInclude);
        includes.removeInclude(newInclude);
        Assert.assertNull((Object)newInclude.getXmlObjectParent());
    }
}

