/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easyschema10.api;

import java.net.URL;

import javax.xml.parsers.DocumentBuilderFactory;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyschema10.api.element.ComplexType;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.element.SimpleType;

public final class SchemaOfSchemas {

    private static final XmlContext PRIVATE_CONTEXT;
    
    private static Schema SCHEMA_OF_SCHEMAS = null;

    
    static {

        XmlContextFactory xmlContextFactory = new XmlContextFactory();
        // create a private context.
        PRIVATE_CONTEXT = xmlContextFactory.newContext();

        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);

        URL schemaInputStream = null;
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);

            schemaInputStream = SchemaOfSchemas.class.getClassLoader().getResource(
                    Constants.XMLSCHEMA_ORIGINATING_SCHEMA_DIR + "/" + Constants.XMLSCHEMA_ORIGINATING_SCHEMA_NAME);
            assert schemaInputStream != null;
            XmlObjectReader reader = PRIVATE_CONTEXT.createReader();

            SCHEMA_OF_SCHEMAS = reader.readDocument(schemaInputStream, Schema.class);
            
            XmlObjectFactory xmlObjectFactory = SCHEMA_OF_SCHEMAS.getXmlContext().getXmlObjectFactory();

            ComplexType anyType = xmlObjectFactory.create(ComplexType.class);
            anyType.setName("anyType");
            SCHEMA_OF_SCHEMAS.addComplexType(anyType);
        
            SimpleType anySimpleType = xmlObjectFactory.create(SimpleType.class);
            anySimpleType.setName("anySimpleType");
            SCHEMA_OF_SCHEMAS.addSimpleType(anySimpleType);
            
        } catch (Exception e) {
            throw new UncheckedException("Cannot read schema of schemas.", e);
        }
    }

    
    private SchemaOfSchemas() {
    }
    
    
    public static Schema getSchema() {
        return SCHEMA_OF_SCHEMAS;
    }
    
    
}
