/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyschema10.api.with;

import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easyschema10.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easyschema10.api.element.AttributeGroup;
import com.ebmwebsourcing.easyschema10.api.with.WithAttributeGroups;
import java.util.Arrays;
import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class WithAttributeGroupsTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_ATTRIBUTE_GROUPS = "expectedAttributeGroups";

    public WithAttributeGroupsTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetAttributeGroups() {
        WithAttributeGroups attributeGroups = (WithAttributeGroups)this.newXmlObjectUnderTest();
        Object[] expectedAttributeGroups = (AttributeGroup[])this.getTestData(EXPECTED_ATTRIBUTE_GROUPS);
        Assert.assertArrayEquals((Object[])expectedAttributeGroups, (Object[])attributeGroups.getAttributeGroups());
    }

    @Test
    public void testGetAttributeGroupByName() {
        AttributeGroup[] expectedAttributeGroups;
        WithAttributeGroups attributeGroups = (WithAttributeGroups)this.newXmlObjectUnderTest();
        for (AttributeGroup expectedAttributeGroup : expectedAttributeGroups = (AttributeGroup[])this.getTestData(EXPECTED_ATTRIBUTE_GROUPS)) {
            if (expectedAttributeGroup.getName() == null) continue;
            Assert.assertEquals((Object)expectedAttributeGroup, (Object)attributeGroups.getAttributeGroupByName(expectedAttributeGroup.getName()));
        }
    }

    @Test
    public void testAddAttributeGroup() {
        WithAttributeGroups attributeGroups = (WithAttributeGroups)this.newXmlObjectUnderTest();
        LinkedList<AttributeGroup> expectedAttributeGroups = new LinkedList<AttributeGroup>(Arrays.asList((AttributeGroup[])this.getTestData(EXPECTED_ATTRIBUTE_GROUPS)));
        AttributeGroup newAttributeGroup = (AttributeGroup)this.getXmlContext().getXmlObjectFactory().create(AttributeGroup.class);
        newAttributeGroup.setName("newAttributeGroupName");
        newAttributeGroup.setId("newAttributeGroupId");
        expectedAttributeGroups.add(newAttributeGroup);
        attributeGroups.addAttributeGroup(newAttributeGroup);
        Assert.assertEquals(expectedAttributeGroups, Arrays.asList(attributeGroups.getAttributeGroups()));
    }

    @Test
    public void testRemoveAttributeGroup() {
        WithAttributeGroups attributeGroups = (WithAttributeGroups)this.newXmlObjectUnderTest();
        for (AttributeGroup e : attributeGroups.getAttributeGroups()) {
            attributeGroups.removeAttributeGroup(e);
            Assert.assertFalse((boolean)Arrays.asList(attributeGroups.getAttributeGroups()).contains(e));
        }
    }

    @Test
    public void testClearAttributeGroups() {
        WithAttributeGroups attributeGroups = (WithAttributeGroups)this.newXmlObjectUnderTest();
        attributeGroups.clearAttributeGroups();
        Assert.assertEquals((long)0L, (long)attributeGroups.getAttributeGroups().length);
    }

    @Test
    public void testGetParentAfterAdding() {
        WithAttributeGroups attributeGroups = (WithAttributeGroups)this.newXmlObjectUnderTest();
        AttributeGroup newAttributeGroup = (AttributeGroup)this.getXmlContext().getXmlObjectFactory().create(AttributeGroup.class);
        attributeGroups.addAttributeGroup(newAttributeGroup);
        Assert.assertEquals((Object)attributeGroups, (Object)newAttributeGroup.getXmlObjectParent());
    }

    @Test
    public void testGetParentAfterRemoval() {
        WithAttributeGroups attributeGroups = (WithAttributeGroups)this.newXmlObjectUnderTest();
        AttributeGroup newAttributeGroup = (AttributeGroup)this.getXmlContext().getXmlObjectFactory().create(AttributeGroup.class);
        attributeGroups.addAttributeGroup(newAttributeGroup);
        attributeGroups.removeAttributeGroup(newAttributeGroup);
        Assert.assertNull((Object)newAttributeGroup.getXmlObjectParent());
    }
}

