/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easyschema10.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.with.WithElements;

import easybox.org.w3._2001.xmlschema.EJaxbGroup;

abstract class AbstractElementsImpl<Model extends EJaxbGroup> extends AbstractAnnotatedImpl<Model> implements
        WithElements {

    protected AbstractElementsImpl(XmlContext xmlContext, Model jaxbModel) {
        super(xmlContext, jaxbModel);
    }
    

    public final void addElement(Element element) {
        addToChildren(getModelObject().getParticle(), (ElementImpl) element);
    }

    public final void clearElements() {
        clearChildren(getModelObject().getParticle(),
                easybox.org.w3._2001.xmlschema.EJaxbElement.class, ANY_QNAME);
    }

    @Override
    public final Element getElementByName(String name) {
        return getChildByName(getElements(), name);
    }

    public final Element[] getElements() {
        return createChildrenArray(getModelObject().getParticle(),
                easybox.org.w3._2001.xmlschema.EJaxbElement.class, ANY_QNAME, Element.class);
    }


    public final void removeElement(Element element) {
        removeFromChildren(getModelObject().getParticle(),
                (ElementImpl) element);
    }

    

}
