/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easyschema10.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Sequence;
import com.ebmwebsourcing.easyschema10.api.type.ExtensionType;
import com.ebmwebsourcing.easyschema10.api.type.Type;

import easybox.org.w3._2001.xmlschema.EJaxbExtensionType;

final class ExtensionTypeImpl extends AbstractAnnotatedImpl<EJaxbExtensionType> implements
        ExtensionType {

    protected ExtensionTypeImpl(XmlContext xmlContext, EJaxbExtensionType jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    protected Class<? extends EJaxbExtensionType> getCompliantModelClass() {
        return EJaxbExtensionType.class;
    }

    @Override
    public QName getBase() {
        return getModelObject().getBase();
    }

    @Override
    public void setBase(QName base) {
        getModelObject().setBase(base);
    }

    @Override
    public boolean hasSequence() {
        return getModelObject().getSequence() != null;
    }

    @Override
    public Sequence getSequence() {
        if (!hasSequence())
            return null;
        return getXmlContext().getXmlObjectFactory().wrap(getModelObject().getSequence(),
                SequenceImpl.class);
    }

    @Override
    public void setSequence(Sequence sequence) {
        if(sequence != null) {
            getModelObject().setSequence(((SequenceImpl) sequence).getModelObject());
        } else {
            getModelObject().setSequence(null);
        }
    }
    
    @Override
    public Type findBase() {
        QName base = getBase();
        if (base == null) return null;
        return SchemaHelper.findTypeByQName(SchemaHelper.findParentSchema(this), base);
    }

}
