/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easyschema10.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easyschema10.api.element.Attribute;
import com.ebmwebsourcing.easyschema10.api.element.AttributeGroup;
import com.ebmwebsourcing.easyschema10.api.element.ComplexType;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Import;
import com.ebmwebsourcing.easyschema10.api.element.Include;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.element.SimpleType;
import com.ebmwebsourcing.easyschema10.api.type.Form;

import easybox.org.w3._2001.xmlschema.EJaxbAttribute;
import easybox.org.w3._2001.xmlschema.EJaxbAttributeGroup;
import easybox.org.w3._2001.xmlschema.EJaxbComplexType;
import easybox.org.w3._2001.xmlschema.EJaxbElement;
import easybox.org.w3._2001.xmlschema.EJaxbFormChoice;
import easybox.org.w3._2001.xmlschema.EJaxbImport;
import easybox.org.w3._2001.xmlschema.EJaxbInclude;
import easybox.org.w3._2001.xmlschema.EJaxbSchema;
import easybox.org.w3._2001.xmlschema.EJaxbSimpleType;

final class SchemaImpl extends AbstractOpenAttrsImpl<EJaxbSchema> implements
        Schema {

    protected SchemaImpl(XmlContext xmlContext, EJaxbSchema jaxbModel) {
        super(xmlContext, jaxbModel);
    }

    @Override
    public Form getAttributeFormDefault() {
        return Form.valueOf(getModelObject().getAttributeFormDefault().value().toUpperCase());
    }
    
    @Override
    public void setAttributeFormDefault(Form attributeFormDefault) {
        if (attributeFormDefault == null) {
            getModelObject().setAttributeFormDefault(null);
        } else {
            getModelObject().setAttributeFormDefault(
                    EJaxbFormChoice.fromValue(attributeFormDefault.toString().toLowerCase()));
        }
    }
    
    @Override
    public Form getElementFormDefault() {
        return Form.valueOf(getModelObject().getElementFormDefault().value().toUpperCase()); 
    }

    @Override
    public void setElementFormDefault(Form elementFormDefault) {
        if (elementFormDefault == null) {
            getModelObject().setElementFormDefault(null);
        } else {
            getModelObject().setElementFormDefault(
                    EJaxbFormChoice.fromValue(elementFormDefault.toString().toLowerCase()));
        }
    }

    
    @Override
    protected Class<? extends EJaxbSchema> getCompliantModelClass() {
        return EJaxbSchema.class;
    }
    
    @Override
    public void addAttribute(Attribute attribute) {
        addToChildren(getModelObject().getSimpleTypeOrComplexTypeOrGroup(),
                (AttributeImpl) attribute);
    }

    @Override
    public void addAttributeGroup(AttributeGroup attributeGroup) {
        addToChildren(getModelObject().getSimpleTypeOrComplexTypeOrGroup(),
                (AttributeGroupImpl) attributeGroup);
    }

    @Override
    public void addComplexType(ComplexType complexType) {
        addToChildren(getModelObject().getSimpleTypeOrComplexTypeOrGroup(),
                (ComplexTypeImpl) complexType);
    }

    @Override
    public void addElement(Element element) {
        addToChildren(getModelObject().getSimpleTypeOrComplexTypeOrGroup(),
                (ElementImpl) element);
    }

    @Override
    public void addImport(Import impor) {
        addToChildren(getModelObject().getIncludeOrImportOrRedefine(),
                (ImportImpl) impor);
    }

    @Override
    public void addInclude(Include include) {
        addToChildren(getModelObject().getIncludeOrImportOrRedefine(),
                (IncludeImpl) include);
    }

    @Override
    public void addSimpleType(SimpleType simpleType) {
        addToChildren(getModelObject().getSimpleTypeOrComplexTypeOrGroup(),
                (SimpleTypeImpl) simpleType);
    }

    @Override
    public void clearAttributeGroups() {
        clearChildren(getModelObject().getSimpleTypeOrComplexTypeOrGroup(),
                EJaxbAttributeGroup.class, ANY_QNAME);
    }

    @Override
    public void clearAttributes() {
        clearChildren(getModelObject().getSimpleTypeOrComplexTypeOrGroup(),
                EJaxbAttribute.class, ANY_QNAME);
    }

    @Override
    public void clearComplexTypes() {
        clearChildren(getModelObject().getSimpleTypeOrComplexTypeOrGroup(),
                EJaxbComplexType.class, ANY_QNAME);
    }

    @Override
    public void clearElements() {
        clearChildren(getModelObject().getSimpleTypeOrComplexTypeOrGroup(),
                EJaxbElement.class, ANY_QNAME);
    }

    @Override
    public void clearImports() {
        clearChildren(getModelObject().getIncludeOrImportOrRedefine(),
                EJaxbImport.class, ANY_QNAME);
    }

    @Override
    public void clearIncludes() {
        clearChildren(getModelObject().getIncludeOrImportOrRedefine(),
                EJaxbInclude.class, ANY_QNAME);
    }

    @Override
    public void clearSimpleTypes() {
        clearChildren(getModelObject().getSimpleTypeOrComplexTypeOrGroup(),
                EJaxbSimpleType.class, ANY_QNAME);
    }

    @Override
    public Attribute getAttributeByName(String name) {
        return getChildByName(getAttributes(), name);
    }

    @Override
    public AttributeGroup getAttributeGroupByName(String name) {
        return getChildByName(getAttributeGroups(), name);
    }

    @Override
    public AttributeGroup[] getAttributeGroups() {
        return createChildrenArray(getModelObject()
                .getSimpleTypeOrComplexTypeOrGroup(), EJaxbAttributeGroup.class,
                ANY_QNAME, AttributeGroup.class);
    }

    @Override
    public Attribute[] getAttributes() {
        return createChildrenArray(getModelObject()
                .getSimpleTypeOrComplexTypeOrGroup(), EJaxbAttribute.class,
                ANY_QNAME, Attribute.class);
    }

    @Override
    public ComplexType getComplexTypeByName(String name) {
        return getChildByName(getComplexTypes(), name);
    }

    @Override
    public ComplexType[] getComplexTypes() {
        return createChildrenArray(getModelObject()
                .getSimpleTypeOrComplexTypeOrGroup(), EJaxbComplexType.class,
                ANY_QNAME, ComplexType.class);
    }

    @Override
    public Element getElementByName(String name) {
        return getChildByName(getElements(), name);
    }

    @Override
    public Element[] getElements() {
        return createChildrenArray(getModelObject()
                .getSimpleTypeOrComplexTypeOrGroup(), EJaxbElement.class,
                ANY_QNAME, Element.class);
    }

    @Override
    public String getId() {
        return getModelObject().getId();
    }

    @Override
    public Import[] getImports() {
        return createChildrenArray(getModelObject()
                .getIncludeOrImportOrRedefine(), EJaxbImport.class,
                ANY_QNAME, Import.class);
    }

    @Override
    public Include[] getIncludes() {
        return createChildrenArray(getModelObject()
                .getIncludeOrImportOrRedefine(), EJaxbInclude.class,
                ANY_QNAME, Include.class);
    }

    @Override
    public SimpleType getSimpleTypeByName(String name) {
        return getChildByName(getSimpleTypes(), name);
    }

    @Override
    public SimpleType[] getSimpleTypes() {
        return createChildrenArray(getModelObject()
                .getSimpleTypeOrComplexTypeOrGroup(), EJaxbSimpleType.class,
                ANY_QNAME, SimpleType.class);
    }

    @Override
    public String getTargetNamespace() {
        if (!hasTargetNamespace()) {
            return null;
        }
        return getModelObject().getTargetNamespace();
    }

    @Override
    public boolean hasTargetNamespace() {
        return getModelObject().getTargetNamespace() != null;
    }

    @Override
    public void removeAttribute(Attribute attribute) {
        removeFromChildren(getModelObject().getSimpleTypeOrComplexTypeOrGroup(),
                (AttributeImpl) attribute);
    }

    @Override
    public void removeAttributeGroup(AttributeGroup attributeGroup) {
        removeFromChildren(getModelObject().getSimpleTypeOrComplexTypeOrGroup(),
                (AttributeGroupImpl) attributeGroup);
    }

    @Override
    public void removeComplexType(ComplexType complexType) {
        removeFromChildren(getModelObject().getSimpleTypeOrComplexTypeOrGroup(),
                (ComplexTypeImpl) complexType);
    }

    @Override
    public void removeElement(Element element) {
        removeFromChildren(getModelObject().getSimpleTypeOrComplexTypeOrGroup(),
                (ElementImpl) element);
    }

    @Override
    public void removeImport(Import impor) {
        removeFromChildren(getModelObject().getIncludeOrImportOrRedefine(),
                (ImportImpl) impor);
    }

    @Override
    public void removeInclude(Include include) {
        removeFromChildren(getModelObject().getIncludeOrImportOrRedefine(),
                (IncludeImpl) include);
    }

    @Override
    public void removeSimpleType(SimpleType simpleType) {
        removeFromChildren(getModelObject().getSimpleTypeOrComplexTypeOrGroup(),
                (SimpleTypeImpl) simpleType);
    }

    @Override
    public void setId(String id) {
        getModelObject().setId(id);
    }

    @Override
    public void setTargetNamespace(String targetNamesapce) {
        getModelObject().setTargetNamespace(targetNamesapce);
    }
    
}
