/****************************************************************************
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easyschema10.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.easyschema10.api.Constants;

// TODO : should not be public but imposed by ServiceLoader
public final class XmlObjectSchemaBindingImpl extends
        AbstractXmlObjectSchemaBindingImpl {

    @Override
    public String getName() {
        return "easyschema10-impl";
    }
    
    @Override
    public String getOriginatingSchemaDir() {
        return Constants.XMLSCHEMA_ORIGINATING_SCHEMA_DIR;
    }

    @Override
    public String getOriginatingSchemaName() {
        return Constants.XMLSCHEMA_ORIGINATING_SCHEMA_NAME;
    }

    @Override
    public Package getModelObjectPackage() {
        return easybox.org.w3._2001.xmlschema.ObjectFactory.class.getPackage();
    }

    
    @Override
    public String getOriginatingSchemaNamespaceURI() {
        return Constants.XMLSCHEMA_NS_URI;
    }

    @Override
    public String getOriginatingSchemaPreferredNamespacePrefix() {
        return Constants.XMLSCHEMA_NS_PREFERRED_PREFIX;
    }
    
    @SuppressWarnings("unchecked")
    @Override
    public Class<? extends XmlObject>[] getFactorableClasses() {
        List<Class<? extends XmlObject>> factorableClasses = new ArrayList<Class<? extends XmlObject>>();
        
        factorableClasses.add(AllImpl.class);
        factorableClasses.add(AnnotationImpl.class);
        factorableClasses.add(AnyAttributeImpl.class);
        factorableClasses.add(AppInfoImpl.class);
        factorableClasses.add(AttributeGroupImpl.class);
        factorableClasses.add(AttributeImpl.class);
        factorableClasses.add(ChoiceImpl.class);
        factorableClasses.add(ComplexContentImpl.class);
        factorableClasses.add(ComplexTypeImpl.class);
        factorableClasses.add(DocumentationImpl.class);
        factorableClasses.add(ElementImpl.class);
        factorableClasses.add(EnumerationImpl.class);
        factorableClasses.add(ExtensionTypeImpl.class);
        factorableClasses.add(FieldImpl.class);
        factorableClasses.add(FractionDigitsImpl.class);
        factorableClasses.add(GroupImpl.class);
        factorableClasses.add(ImportImpl.class);
        factorableClasses.add(IncludeImpl.class);
        factorableClasses.add(KeyImpl.class);
        factorableClasses.add(KeybaseImpl.class);
        factorableClasses.add(LengthImpl.class);
        factorableClasses.add(ListImpl.class);
        factorableClasses.add(MaxExclusiveImpl.class);
        factorableClasses.add(MaxInclusiveImpl.class);
        factorableClasses.add(MaxLengthImpl.class);
        factorableClasses.add(MinExclusiveImpl.class);
        factorableClasses.add(MinInclusiveImpl.class);
        factorableClasses.add(MinLengthImpl.class);
        factorableClasses.add(NotationImpl.class);
        factorableClasses.add(PatternImpl.class);
        factorableClasses.add(RestrictionImpl.class);
        factorableClasses.add(RestrictionTypeImpl.class);
        factorableClasses.add(SchemaImpl.class);
        factorableClasses.add(SelectorImpl.class);
        factorableClasses.add(SequenceImpl.class);
        factorableClasses.add(SimpleContentImpl.class);
        factorableClasses.add(SimpleTypeImpl.class);
        factorableClasses.add(TotalDigitsImpl.class);
        factorableClasses.add(UnionImpl.class);
        factorableClasses.add(UniqueImpl.class);
        factorableClasses.add(WhitespaceImpl.class);

        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }
    
    
    @Override
    protected XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject ModelObject)
            throws InstantiationException, IllegalAccessException,
            InvocationTargetException {
        return xmlObjectImplConstructor.newInstance(xmlContext, ModelObject);
    }

}
