/****************************************************************************
 * 
 * Copyright (c) 2009-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 ****************************************************************************/

package com.ebmwebsourcing.easyschema.xsd2xml;

import java.util.HashMap;
import java.util.Map;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easyschema10.api.SchemaOfSchemas;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.type.Form;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public abstract class XSD2XML {

    public static XSD2XML newInstance() {
        return new XSD2XMLImpl();
    }

    public abstract String printXml(final Element e, Object value) /*
                                                                    * throws
                                                                    * SchemaException
                                                                    */;

    public abstract String printXml(final Element e, Map<com.ebmwebsourcing.easyschema10.api.type.Type, Object> value,
            boolean createOptionalElement, boolean createOptionalAttribute);

    public abstract org.jdom.Element generateElement(final Element eIn,
            XmlObject typeHolderXmlObject, 
            final Object values);

    public abstract org.jdom.Element generateElement(com.ebmwebsourcing.easyschema10.api.element.Element eIn,
            XmlObject typeHolderXmlObject,
            Map<com.ebmwebsourcing.easyschema10.api.type.Type, Object> values, Form form, int minOccurs,
            boolean createOptionalElement, boolean createOptionalAttribute);

    public abstract org.jdom.Element addMinOccursEqual0OrArrayElement(
            final Element childDefinition, XmlObject typeHolderXmlObject, 
            final org.jdom.Element parentElement);

    public static Map<com.ebmwebsourcing.easyschema10.api.type.Type, Object> createDefaultMap(Object value) {
        Map<com.ebmwebsourcing.easyschema10.api.type.Type, Object> values = 
            new HashMap<com.ebmwebsourcing.easyschema10.api.type.Type, Object>();
        for (com.ebmwebsourcing.easyschema10.api.type.Type type : SchemaOfSchemas.getSchema().getSimpleTypes()) {
            values.put(type, value);
        }
        return values;
    }
}
