package org.petalslink.abslayer.service.api;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;

public interface Description {
    
    public Message findMessage(QName qname);
    
    public Map<String, String> getNamespaces();
    
    public URI getDocumentBaseURI();
    
    public String getTargetNamespace();
    
    public Types getTypes();
    
    public org.petalslink.abslayer.service.api.PartnerLinkType getPartnerLinkType(QName qname);
    
    public Interface findInterface(final QName name);

    public Service findService(final QName name);
    
    public Binding findBinding(final QName name);
    
    public List<Interface> getInterfaces();

    public List<Endpoint> findEndpointsImplementingInterface(
            Interface itf);
    
    public List<Service> findServicesImplementingInterface(
            Interface itf);
    

    public XmlObject getModel();

    public Endpoint findEndpoint(String endpointName);

    public Collection<? extends Binding> getBindings();

    public Collection<? extends Element> findElementsInAllSchema(QName element);

    public Property findProperty(QName qname);

    public Collection<? extends PropertyAlias> getPropertyAliases4ThisProperty(
            QName propName);

	public Collection<? extends Service> getServices();
	
	public Collection<? extends Import> getImports();
	
	public Document write() throws XmlObjectWriteException;

	
}
