/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.petalslink.abslayer.service.impl.wsdl11;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Service;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.element.Port;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class EndpointImpl implements org.petalslink.abslayer.service.api.Endpoint {

    private Port model;

    private EndpointImpl(Port model) {
        this.model = model;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((model == null) ? 0 : model.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        EndpointImpl other = (EndpointImpl) obj;
        if (model == null) {
            if (other.model != null)
                return false;
        } else if (!model.equals(other.model))
            return false;
        return true;
    }

    @Override
    public String getName() {
        return model.getName();
    }

    @Override
    public String getAddress() {
        XmlObject xo = model.getAnyXmlObjects(new QName(
                "http://schemas.xmlsoap.org/wsdl/soap/", "address"))[0];
        return (String) xo.getXmlObjectAttributes().get(new  QName("location"));
    }

    @Override
    public Service getService() {
        com.ebmwebsourcing.easywsdl11.api.element.Service s = (com.ebmwebsourcing.easywsdl11.api.element.Service) model
                .getXmlObjectParent();
        assert s != null;
        return (org.petalslink.abslayer.service.api.Service) Factory.getInstance().wrap(s);
    }

    @Override
    public org.petalslink.abslayer.service.api.Binding getBinding() {
    	Binding b = model.findBinding();
    	if(b != null) {
    		return (org.petalslink.abslayer.service.api.Binding) Factory.getInstance().wrap(b);
    	}
        return null;
    }
    
	@Override
	public XmlObject getModel() {
		return this.model;
	}

	@Override
	public String toString() {
		return "EndpointImpl [model=" + model + "]";
	}


    
}
