/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.petalslink.abslayer;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class Constants {

    // WSDL11 CONSTANTS /////////

    /**
     * WSDL 1.1 Namespace
     */
    public static final String WSDL_11_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";

    /**
     * WSDL 1.1 package
     */
    public static final String WSDL11_PACKAGE = Constants.class.getPackage()
            .getName();

    /**
     * WSDL 1.1 schema name
     */
    public static final String XSD_WSDL_11 = "schema/wsdl/wsdl11/wsdl11.xsd";

    /**
     * WSDL 1.1 root tag
     */
    public static final String WSDL11_ROOT_TAG = "definitions";

    /**
     * Errors
     */
    public static final String NOT_SUPPORTED_11 = "the WSDL 1.1 model does not support this operation";

    /**
     * Transport soap/http
     */
    public static final String HTTP_SCHEMAS_XMLSOAP_ORG_SOAP_HTTP = "http://schemas.xmlsoap.org/soap/http";

    // WSDL20 CONSTANTS /////////

    /**
     * WSDL 2.0 Namespace
     */
    public static final String WSDL_20_NAMESPACE = "http://www.w3.org/ns/wsdl";

    /**
     * WSDL 2.0 package
     */
    public static final String WSDL20_PACKAGE = Constants.class.getPackage()
            .getName();

    /**
     * WSDL 2.0 schema name
     */
    public static final String XSD_WSDL_20 = "schema/wsdl/wsdl20/wsdl20.xsd";

    /**
     * WSDL 2.0 root tag
     */
    public static final String WSDL20_ROOT_TAG = "description";

    /**
     * http method default attribute in http binding
     */
    public static final String HTTP_METHOD_DEFAULT = "methodDefault";

    /**
     * http method attribute in http binding
     */
    public static final String HTTP_METHOD = "method";

    /**
     * soap protocol attribute in soap binding
     */
    public static final String SOAP_PROTOCOL = "protocol";

    /**
     * soap mep attribute in soap binding
     */
    public static final String MEP_ATTRIBUTE = "mep";

    /**
     * Errors
     */
    public static final String NOT_SUPPORTED_20 = "the WSDL 2.0 model does not support this operation";

    /**
     * transport soap/http
     */
    public static final String HTTP_WWW_W3_ORG_2003_05_SOAP_BINDINGS_HTTP = "http://www.w3.org/2003/05/soap/bindings/HTTP/";

}
