/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.petalslink.abslayer.service.impl.wsdl11;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.PartnerLinkType;
import org.petalslink.abslayer.service.api.Role;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class PartnerLinkTypeImpl implements PartnerLinkType {

    private com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType model;

    private PartnerLinkTypeImpl(
            com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType model) {
        this.model = model;
    }

    @Override
    public Role getRole(String partnerRole) {
        com.ebmwebsourcing.easyplnk20.api.element.Role role = model
                .getRoleByName(partnerRole);
        if (role == null)
            return null;
        return (org.petalslink.abslayer.service.api.Role) Factory.getInstance().wrap(role);
    }

    @Override
    public List<Role> getRoles() {
        com.ebmwebsourcing.easyplnk20.api.element.Role[] modelRoles = model
                .getRoles();
        List<Role> roles = new ArrayList<Role>();
        for (com.ebmwebsourcing.easyplnk20.api.element.Role role : modelRoles) {
            roles.add((org.petalslink.abslayer.service.api.Role) Factory.getInstance().wrap(role));
        }
        return roles;
    }

    @Override
    public QName getQName() {
        throw new UnsupportedOperationException();
    }
}
