/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.petalslink.abslayer.service.impl.wsdl11;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathExpressionException;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Interface;

import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import com.ebmwebsourcing.easyplnk20.api.element.Role;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class RoleImpl implements org.petalslink.abslayer.service.api.Role {

    private final Role model;

    private RoleImpl(Role model) {
        this.model = model;
    }

    @Override
    public String getName() {
        return model.getName();
    }

    // @Override
    // public Interface getInterface() {

    @Override
    public QName getInterfaceQName() {
        return model.getPortType();
        // // TODO : we should rather go up to bpel process to look for
        // interface
        // XmlObject xmlObject = model.getXmlObjectBaseRoot();
        // if (!(xmlObject instanceof Definitions)) return null;
        // Definitions definitions = (Definitions) xmlObject;
        // assert
        // model.getPortType().getNamespaceURI().equals(definitions.getTargetNamespace());
        // return new
        // InterfaceImpl(definitions.getPortTypeByName(model.getPortType().getLocalPart()));
    }

	@Override
	public Interface findInterface(QName qname) {
        assert qname != null;
        XmlObjectXPathEvaluator xpathEvaluator = model.getXmlContext()
                .createXPathEvaluator();
        try {
        	PortType result = xpathEvaluator
                    .selectSingleXmlObjectNode(
                            model,
                            String.format(
                                    "//wsdl11:portType[@name='%s'][parent::wsdl11:definitions/@targetNamespace='%s']",
                                    qname.getLocalPart(),
                                    qname.getNamespaceURI()), PortType.class);
            if (result == null)
                return null;
            return (org.petalslink.abslayer.service.api.Interface) Factory.getInstance().wrap(result);
        } catch (XPathExpressionException xee) {
            throw new UncheckedException(xee);
        }
	}
}
