/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.petalslink.abslayer.service.impl.wsdl11;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;

import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class InterfaceImpl implements Interface {

    private final PortType model;

    private QName qname;

    private InterfaceImpl(PortType model) {
        assert model != null;
        this.model = model;
    }

    @Override
    public QName getQName() {
        if (qname == null) {
            qname = new QName(getParentDescription().getTargetNamespace(),
                    model.getName());
        }
        return qname;
    }

    @Override
    public Description getParentDescription() {
        Definitions definitions = (Definitions) model.getXmlObjectParent();
        if (definitions == null)
            return null;
        return (org.petalslink.abslayer.service.api.Description) Factory.getInstance().wrap(definitions);
    }

    @Override
    public Operation getOperation(QName qname) {
        com.ebmwebsourcing.easywsdl11.api.element.Operation op = model
                .getOperationByName(qname.getLocalPart());
        if (op == null)
            return null;
        return (org.petalslink.abslayer.service.api.Operation) Factory.getInstance().wrap(op);
    }
    
    @Override
	public Operation[] getOperations() {
		List<Operation> ops = new ArrayList<Operation>();
		com.ebmwebsourcing.easywsdl11.api.element.Operation[] operations = model.getOperations();
		for(com.ebmwebsourcing.easywsdl11.api.element.Operation op: operations) {
			ops.add((org.petalslink.abslayer.service.api.Operation) Factory.getInstance().wrap(op));
		}
		return ops.toArray(new Operation[ops.size()]);
	}
    
    @Override
    public PortType getModel(){
    	return model;
    }
}
