/****************************************************************************
 *
 * Copyright (c) 2010-2012, EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA 
 *
 *****************************************************************************/

package org.petalslink.abslayer.service.impl.wsdl11;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;

import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

/**
 * @author Nicolas Salatge - EBM WebSourcing
 */
public class PartImpl implements org.petalslink.abslayer.service.api.Part {

    private final com.ebmwebsourcing.easywsdl11.api.element.Part model;
    private boolean partElementCacheSet = false;
    private com.ebmwebsourcing.easyschema10.api.element.Element partElementCache = null;

    private PartImpl(com.ebmwebsourcing.easywsdl11.api.element.Part model) {
        this.model = model;
    }

    @Override
    public QName getType() {
        return model.getType();
    }

    @Override
    public QName getQName() {
        Definitions definitions = (Definitions) model.getXmlObjectBaseRoot();
        return new QName(definitions.getTargetNamespace(), model.getName());
    }

    
    @Override
    public QName getElementQName() {
    	return model.getElement();
    }
    
    
    
    @Override
    public com.ebmwebsourcing.easyschema10.api.element.Element getElement() {
        if (partElementCache != null) return partElementCache;
        if ((partElementCache == null) && (partElementCacheSet)) return null;
        QName partElement = model.getElement();
        if (partElement == null) return null;
        partElementCache = SchemaHelper.findElementByQName(model.getXmlObjectBaseRoot(), partElement);
        partElementCacheSet = true;
        return partElementCache;
    }

    @Override
    public Element createElement() {
        return model.getXmlContext().getXmlObjectFactory()
                .create(Element.class);
    }

    @Override
    public Description getDescription() {
        return (org.petalslink.abslayer.service.api.Description) Factory.getInstance().wrap(model.getXmlObjectBaseRoot());
    }
}
