/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easytools.plugin.release.impl;

import com.ebmwebsourcing.easytools.plugin.release.impl.Dependency;
import com.ebmwebsourcing.easytools.plugin.release.impl.TreeMojo;
import com.ebmwebsourcing.easytools.plugin.release.impl.util.FileUtil;
import com.ebmwebsourcing.easytools.plugin.release.impl.util.OSValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class DistribMojo
extends AbstractMojo {
    private static Logger log = Logger.getLogger(DistribMojo.class.getName());
    protected String version = null;
    protected boolean testSkip = false;
    protected boolean clean = false;
    private MavenProject project = null;
    private TreeMojo tree = new TreeMojo();

    public void setBaseDir(URI baseDir) {
        this.tree.setBaseDir(baseDir);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isClean() {
        return this.clean;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    public void execute() throws MojoExecutionException {
        try {
            if (this.project != null) {
                if (this.version == null) {
                    throw new MojoExecutionException("Version cannot be null!!!");
                }
                this.tree.setProject(this.getProject());
                this.tree.validBaseDir();
                System.out.println("start tree on projet: " + this.project.getArtifactId());
                ArrayList<Dependency> childDependencies = new ArrayList<Dependency>();
                this.tree.getAllInternalSnapshotChildInDependencies(this.project, childDependencies, 0);
                ArrayList<Dependency> parentDependencies = new ArrayList<Dependency>();
                this.tree.getAllInternalSnapshotParentDependencies(this.project.getModel().getParent(), parentDependencies, 0);
                for (Dependency dependence : childDependencies) {
                    this.tree.getAllInternalSnapshotParentDependencies(dependence.getParent(), parentDependencies, 0);
                }
                for (Dependency dependence : parentDependencies) {
                    System.out.println(dependence);
                }
                ArrayList<Dependency> allDependencies = new ArrayList<Dependency>();
                allDependencies.addAll(childDependencies);
                allDependencies.addAll(parentDependencies);
                allDependencies.add(new Dependency(URI.create(this.tree.getBaseDir().toString() + "/pom.xml")));
                List<Dependency> distrib = this.verifyIfIsADsitrib(allDependencies);
                for (Dependency d : distrib) {
                    this.process(d);
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void process(Dependency dependence) throws MojoExecutionException {
        URI pomUri = URI.create(dependence.getLocation().toString().replace("pom.xml", "pom-" + this.version + ".xml"));
        if (!new File(pomUri).exists()) {
            throw new MojoExecutionException("Impossible to generate distrib corresponding to this version: " + this.version + ". this file " + "pom-" + this.version + ".xml" + "does not exist");
        }
        File destination = new File(URI.create(this.tree.getBaseDir().toString() + "target/release/distribution"));
        destination.mkdirs();
        this.installDistrib(dependence);
    }

    private void writeInputStream(InputStream ips) throws IOException {
        String ligne;
        InputStreamReader ipsr = new InputStreamReader(ips);
        BufferedReader br = new BufferedReader(ipsr);
        while ((ligne = br.readLine()) != null) {
            System.out.println(ligne);
            System.out.flush();
        }
        br.close();
    }

    private List<Dependency> verifyIfIsADsitrib(List<Dependency> allDependencies) {
        ArrayList<Dependency> distrib = new ArrayList<Dependency>();
        for (Dependency dep : allDependencies) {
            for (Profile pr : dep.getProjectModel().getModel().getProfiles()) {
                if (!pr.getId().equals("distrib")) continue;
                dep.setDistrib(true);
                distrib.add(dep);
                System.out.println("Distribution to generate in : " + dep.getArtifactId());
            }
        }
        return distrib;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isTestSkip() {
        return this.testSkip;
    }

    public void setTestSkip(boolean testSkip) {
        this.testSkip = testSkip;
    }

    public List<File> installDistrib(Dependency dependence) throws MojoExecutionException {
        ArrayList<File> distribs = new ArrayList<File>();
        String javaPath = System.getenv("JAVA_HOME");
        if (javaPath == null) {
            throw new MojoExecutionException("JAVA_HOME must be setted!!!");
        }
        String mavenPath = System.getenv("MAVEN_HOME");
        if (mavenPath == null) {
            throw new MojoExecutionException("MAVEN_HOME is not setted!!!");
        }
        try {
            String script = null;
            if (OSValidator.isWindows()) {
                script = new String(System.getenv("MAVEN_HOME") + "/bin/mvn.bat");
            } else if (OSValidator.isMac() || OSValidator.isUnix()) {
                script = new String(System.getenv("MAVEN_HOME") + "/bin/mvn");
            } else {
                throw new MojoExecutionException("Sorry, but this OS is not supported. EasiestDEMO SDK run on Windows, Mac or Unix system");
            }
            ProcessBuilder pb = new ProcessBuilder(script);
            pb.directory(new File(URI.create(dependence.getLocation().toString().replace("pom.xml", ""))));
            String pomFile = null;
            pomFile = this.version.contains("SNAPSHOT") ? "pom.xml" : "pom-" + this.version + ".xml";
            System.out.println("generate distribution of: " + dependence.getArtifactId());
            if (this.testSkip && !dependence.isTestIsRequired()) {
                if (this.clean) {
                    System.out.println("start command: " + script + " install" + " -f=" + pomFile + " -e" + " -Dmaven.test.skip" + " -Pdistrib");
                    pb.command(script, "clean", "install", "-f=" + pomFile, "-e", "-Dmaven.test.skip", "-Pdistrib");
                } else {
                    System.out.println("start command: " + script + " install" + " -f=" + pomFile + " -e" + " -Dmaven.test.skip" + " -Pdistrib");
                    pb.command(script, "install", "-f=" + pomFile, "-e", "-Dmaven.test.skip", "-Pdistrib");
                }
            } else if (this.clean) {
                System.out.println("start command: " + script + " install" + " -f=" + pomFile + " -e" + " -Pdistrib");
                pb.command(script, "clean", "install", "-f=" + pomFile, "-e", "-Pdistrib");
            } else {
                System.out.println("start command: " + script + " install" + " -f=" + pomFile + " -e" + " -Pdistrib");
                pb.command(script, "install", "-f=" + pomFile, "-e", "-Pdistrib");
            }
            pb.redirectErrorStream(true);
            Process p = pb.start();
            this.writeInputStream(p.getInputStream());
            this.writeInputStream(p.getErrorStream());
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new MojoExecutionException("Impossible to create distribution for : " + pomFile);
            }
            List<File> installers = this.findInstallersInTargetRepo(dependence);
            File destinationRepo = new File(URI.create(this.tree.getBaseDir().toString() + "target/release/distribution/" + dependence.getGroupId().replace("com.ebmwebsourcing.", "") + "/"));
            destinationRepo.mkdirs();
            for (File installer : installers) {
                FileInputStream source = new FileInputStream(installer);
                System.out.println("Move installer " + installer.getName() + " to " + destinationRepo);
                File outFile = new File(URI.create(this.tree.getBaseDir().toString() + "target/release/distribution/" + dependence.getGroupId().replace("com.ebmwebsourcing.", "") + "/" + installer.getName()));
                outFile.createNewFile();
                FileOutputStream destination = new FileOutputStream(outFile);
                FileUtil.copy(source, destination);
                distribs.add(outFile);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        return distribs;
    }

    private List<File> findInstallersInTargetRepo(Dependency dependence) throws MojoExecutionException {
        ArrayList<File> inst = new ArrayList<File>();
        File destination = new File(URI.create(dependence.getLocation().toString().replace("pom.xml", "target")));
        try {
            for (File f : FileUtil.getAllFiles(destination)) {
                if (!f.getName().contains("installer") && !f.getName().endsWith(".war") && !f.getName().endsWith(".zip") || !f.getName().contains(this.version) || f.getName().endsWith(".dir")) continue;
                inst.add(f);
                System.out.println("Installer to deploy: " + f);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
        return inst;
    }
}

