/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.esstar.management;

import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Notify;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Subscribe;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Unsubscribe;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.GetResourcePropertyResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDescriptorType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbLinkedResourceDescriptorType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbWsdl;
import easybox.esstar.petalslink.com.management.model.datatype._1.ObjectFactory;
import esstar.petalslink.com.data.management.user._1.Bind;
import esstar.petalslink.com.data.management.user._1.BindResponse;
import esstar.petalslink.com.data.management.user._1.Deploy;
import esstar.petalslink.com.data.management.user._1.DeployResponse;
import esstar.petalslink.com.data.management.user._1.Proxify;
import esstar.petalslink.com.data.management.user._1.ProxifyResponse;
import esstar.petalslink.com.service.management.user._1_0.UserManagement;
import esstar.petalslink.com.service.management.user._1_0.UserManagementException;
import java.io.File;
import java.util.ArrayList;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;

public class UserManagementClient
implements UserManagement {
    protected String address = null;
    private UserManagement clientProxy;
    private static ObjectFactory objectFactory = new ObjectFactory();

    public UserManagementClient(String address) {
        this.address = address;
    }

    private synchronized UserManagement getClientProxy() {
        if (this.clientProxy != null) {
            return this.clientProxy;
        }
        this.clientProxy = (UserManagement)CXFHelper.getClient((String)this.address, UserManagement.class);
        return this.clientProxy;
    }

    public SubscribeResponse subscribe(Subscribe subscribeRequest) throws NotifyMessageNotSupportedFault, InvalidFilterFault, InvalidTopicExpressionFault, TopicExpressionDialectUnknownFault, UnsupportedPolicyRequestFault, SubscribeCreationFailedFault, UnacceptableInitialTerminationTimeFault, UnrecognizedPolicyRequestFault, TopicNotSupportedFault, InvalidProducerPropertiesExpressionFault, ResourceUnknownFault, InvalidMessageContentExpressionFault {
        return this.getClientProxy().subscribe(subscribeRequest);
    }

    public UnsubscribeResponse unsubscribe(Unsubscribe unsubscribeRequest) throws UnableToDestroySubscriptionFault, ResourceUnknownFault {
        return this.getClientProxy().unsubscribe(unsubscribeRequest);
    }

    public ProxifyResponse proxify(Proxify parameters) throws UserManagementException {
        return this.getClientProxy().proxify(parameters);
    }

    public String expose(QName serviceName, String endpointName) throws UserManagementException {
        return this.getClientProxy().expose(serviceName, endpointName);
    }

    public BindResponse bind(Bind parameters) throws UserManagementException {
        return this.getClientProxy().bind(parameters);
    }

    public GetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest) throws ResourceUnavailableFault, InvalidResourcePropertyQNameFault, ResourceUnknownFault {
        return this.getClientProxy().getResourceProperty(getResourcePropertyRequest);
    }

    public DeployResponse deploy(Deploy parameters) throws UserManagementException {
        return this.getClientProxy().deploy(parameters);
    }

    public String bind(String externalAddres, String wsdlUrl) throws UserManagementException {
        Bind request = new Bind();
        request.setExternalAddress(externalAddres);
        EJaxbWsdl wsdl = new EJaxbWsdl();
        wsdl.setUrl(objectFactory.createEJaxbWsdlUrl(wsdlUrl));
        request.setWsdl(wsdl);
        BindResponse response = this.getClientProxy().bind(request);
        return response.getEndpointName();
    }

    public String proxify(String externalAddres, String wsdlUrl) throws UserManagementException {
        Proxify request = new Proxify();
        request.setExternalAddress(externalAddres);
        EJaxbWsdl wsdl = new EJaxbWsdl();
        wsdl.setUrl(objectFactory.createEJaxbWsdlUrl(wsdlUrl));
        request.setWsdl(wsdl);
        ProxifyResponse response = this.getClientProxy().proxify(request);
        return response.getExternalAddress();
    }

    public EJaxbDeployementReport deploy(File descriptorFile, File[] resources) throws UserManagementException {
        if (descriptorFile == null) {
            throw new UserManagementException("Descriptor file can not be null");
        }
        if (!descriptorFile.exists() || !descriptorFile.isFile()) {
            throw new UserManagementException("Descriptor file " + descriptorFile.getName() + " does not exists or is not a file");
        }
        EJaxbDescriptorType descriptor = new EJaxbDescriptorType();
        descriptor.setFileURI(descriptorFile.toURI().toString());
        descriptor.setAttachment(new DataHandler((DataSource)new FileDataSource(descriptorFile)));
        ArrayList<EJaxbLinkedResourceDescriptorType> list = new ArrayList<EJaxbLinkedResourceDescriptorType>();
        if (resources != null) {
            File[] fileArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file != null && file.exists() && file.isFile()) {
                    EJaxbLinkedResourceDescriptorType resource = new EJaxbLinkedResourceDescriptorType();
                    resource.setFileURI(file.toURI().toString());
                    resource.setResource(new DataHandler((DataSource)new FileDataSource(file)));
                    list.add(resource);
                }
                ++n2;
            }
        }
        Deploy request = new Deploy();
        request.setArtifact(descriptor);
        request.getResources().addAll(list);
        DeployResponse response = this.deploy(request);
        return response.getDeployementReport();
    }

    public void notify(Notify notify) {
        this.getClientProxy().notify(notify);
    }
}

