/**
 * Raphael Diagram - A crossbrowser SVG/VML library creating diagrams - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.diagram.element;

import java.util.ArrayList;

import com.ebmwebsourcing.gwt.raphael.client.core.SVGElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.ComplexElementEvent;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.ComplexElementHandler;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramElementMouseListenerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.diagram.semantic.DiagramEntity;
import com.ebmwebsourcing.gwt.raphael.client.diagram.type.DiagramDefaultType;
import com.ebmwebsourcing.gwt.raphael.client.diagram.type.DiagramElementType;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.shared.HandlerRegistration;



/**
 * 
 * @author nfleury
 *
 */
public class DiagramComplexElement extends DiagramElement{
	
	private ArrayList<DiagramElementChildData> children  = new ArrayList<DiagramElementChildData>();
	
	public DiagramComplexElement(SVGElement svgElement) {
		super(svgElement,new DiagramDefaultType());
	}

	
	
	public DiagramComplexElement(SVGElement svgElement, DiagramElementType type) {
		super(svgElement, type);
	}



	public ArrayList<DiagramElementChildData> getDiagramElementChildren() {
		return children;
	}
	
	

	/**
	 * Remove a diagramElement child from current element
	 * @param element
	 */
	public void removeChild(DiagramElement element){
		
		DiagramElementChildData childToRemove = null;
		
		for(DiagramElementChildData data: this.children){
			
			if (data.getDiagramElement() == element){
				childToRemove = data;
			}
			
		}
		
		children.remove(childToRemove);
		
		
	}
	
	@Override
	protected void onLoad() {
		super.onLoad();
		
		for(DiagramElementChildData data: this.children){
			
			this.addChildElementToPanel(data);
			
		}
		
		this.refreshSVGPosition();
		

	}
	
	/**
	 * Add an element to current diagram element
	 * at the specified positions
	 * 
	 * @param element
	 * @param x relative position to the parent element
	 * @param y relative position to the parent element
	 */
	public void addDiagramElement(final DiagramElement element,int x, int y,boolean resizeWithParent){
		
		DiagramElementChildData dep = new DiagramElementChildData(element,x,y,resizeWithParent);
		
		this.children.add(dep);
		
		//if element is already loaded directly add the child
		//to the panel
		if (this.getDiagramPanel() !=null){
			this.addChildElementToPanel(dep);
			
		}
		
		
		if (element instanceof DiagramEntity){
			//A way to prevent DOM bubbling => (fake) Stop propagation
			element.addMouseListener(new DiagramElementMouseListenerAdapter(){
				@Override
				public void onMouseEnter() {
//					DebugerHelper.debug("Mouse enter a DE child of Complex element - child id:"+element.getId());
//					DebugerHelper.debug("MouseListeners size before remove:"+DiagramComplexElement.this.getMouseListeners().size());
					DiagramComplexElement.this.getMouseListeners().remove(getDefaultMouseListener());
//					DebugerHelper.debug("MouseListeners size after remove:"+DiagramComplexElement.this.getMouseListeners().size());
				}
				
				@Override
				public void onMouseLeave() {

//					DebugerHelper.debug("Mouse leave a DE child of Complex element- child id:"+element.getId());
//					DebugerHelper.debug("MouseListeners size before add:"+DiagramComplexElement.this.getMouseListeners().size());
					DiagramComplexElement.this.addMouseListener(getDefaultMouseListener());
//					DebugerHelper.debug("MouseListeners size after add:"+DiagramComplexElement.this.getMouseListeners().size());
				}
				
				
				
			});			
		}
		

		
		
	}
	
	@Override
	public void remove() {
		super.remove();
		
		for(DiagramElementChildData cdata : children){
			DiagramElement el = cdata.getDiagramElement();
			el.remove();
		}
		

		
	}
	
	@Override
	protected void refreshSpecific() {

		for(DiagramElementChildData childData:this.getDiagramElementChildren()){
			
			//only add the childs that were not added yet
			if (childData.getDiagramElement().getParentElement()==null){
				childData.getDiagramElement().setDiagramPanel(this.getDiagramPanel());
				this.addChildElementToPanel(childData);
			}
				
		}
		
	}
	
	/**
	 * Check if a child is a containee of current element
	 * @param diagramElement
	 * @return
	 */
	public boolean containsChild(DiagramElement diagramElement){
		
		for(DiagramElementChildData data: this.children){
			
			if (data.getDiagramElement() == diagramElement){
				return true;
			}
			
		}
		
		return false;

	}
	
	/**
	 * Add all childs of current element to the diagram panel
	 * and to current complex element
	 */
	private void addChildElementToPanel(DiagramElementChildData childData){
		

//			DebugerHelper.debug("adding child to canevas:"+childData.getDiagramElement().getId());
			//add the svg childs to the panel
		if (!getDiagramPanel().getRaphael().isAttached(childData.getDiagramElement().getSvgElement())){
			this.getDiagramPanel().getRaphael().addElement(childData.getDiagramElement().getSvgElement());
		}

			int x = childData.getX()+this.getX();
			int y = childData.getY()+this.getY();
			
			childData.getDiagramElement().getSvgElement().setX(x);
			childData.getDiagramElement().getSvgElement().setY(y);	

			
			
			//set the parent
			childData.getDiagramElement().setParentElement(this);
			childData.getDiagramElement().setDiagramPanel(this.getDiagramPanel());
			//Do the same thing recursively if a childs is a complex element
			//and if it haven't been aded to the parent yet
			if (childData.getDiagramElement() instanceof DiagramComplexElement){				
				
//				DebugerHelper.debug(childData.getDiagramElement().getId() + "-->Complex Element");

				DiagramComplexElement complexElementChild = (DiagramComplexElement) childData.getDiagramElement();
				
				complexElementChild.refresh();
				
			}
						
		
			//Add the html container of the child to the html container of the father
			//Can only add here because of childs dependencies
			this.add(childData.getDiagramElement(),childData.getX(),childData.getY());
			
			
	}
	
	
	public DiagramElement getDiagramElementById(String id){
		
		for(DiagramElementChildData element: this.children){
			
			if (element.getDiagramElement().getId().equals(id)){
				
				return element.getDiagramElement();
				
			}
			
		}
		
		return null;
		
	}
	
	
	@Override
	public void refreshSVGPosition() {
		
		//Move Parent svg Element		
		super.refreshSVGPosition();
		
		
		//But also move all of its childs relatively
		for(DiagramElementChildData elp:this.children){

			elp.getDiagramElement().refreshSVGPosition();
			
		}
		
	
		
		ComplexElementEvent.fire(this);
	}
	
	
	@Override
	protected void refreshSVGsize() {
		//Resize the Parent SVG Element
		super.refreshSVGsize();
		
		
	
		//Also resize all children that haven been marked as resizable
//		for(DiagramElementChildData data:this.children){
//			
//		 if (data.getDiagramElement().isLoaded()){
//			
//			if (data.getResizeWithParent()==true){
//				
//				double xScale = (double) ( (double) this.getWidth() / (double) context.getWidth());
//				double yScale = (double) ( (double) this.getHeight() / (double) context.getHeight());
//				
//				data.getDiagramElement().setWidth(""+data.getDiagramElement().getContext().getWidth()*xScale);
//				data.getDiagramElement().setHeight(""+data.getDiagramElement().getContext().getHeight()*yScale);
//				
//				//Update the element position
//				data.getDiagramElement().getJqueryObject().css("top",""+(data.getY()*yScale)+"px");
//				data.getDiagramElement().getJqueryObject().css("left",""+(data.getX()*xScale)+"px");
//				
////				SVGElement svgElement = data.getDiagramElement().getSvgElement();
////
////				svgElement.scale(xScale, yScale);
//				data.getDiagramElement().refreshSVGPosition();
//				data.getDiagramElement().refreshSVGsize();
//			
//			}
//			
//		 }	
//		
//		}
		ComplexElementEvent.fire(this);
	}
	
	
	public HandlerRegistration addComplexElementHandler(ComplexElementHandler handler){
		return addHandler(handler, ComplexElementEvent.getType());
	}



	@Override
	protected void hideSpecific() {
		super.hideSpecific();
		for (DiagramElementChildData child : children) {
			child.getDiagramElement().hide();
		}
	}



	@Override
	protected void showSpecific() {
		super.showSpecific();
		for (DiagramElementChildData child : children) {
			child.getDiagramElement().show();
		}
		
	}



	@Override
	public void setZIndex(int zIndex) {
		super.setZIndex(zIndex);
		for (DiagramElementChildData child : children) {
			child.getDiagramElement().getElement().getStyle().setZIndex(zIndex+1);
		}
	}
	

	
	
	
}
