/**
 * Raphael Diagram - A crossbrowser SVG/VML library creating diagrams - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.diagram.event;

import com.ebmwebsourcing.gwt.jquery.client.ui.handler.adapter.ResizableHandlerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElement;
import com.google.gwt.user.client.Event;
import com.j4g.client.api.F;


public class DiagramElementResizableListenerBinder {
	
	
	private DiagramElement diagramElement;

	public DiagramElementResizableListenerBinder(DiagramElement element) {
		this.diagramElement = element;
		
		
		//Bind the resizable event to all the current diagram element listeners
		ResizableHandlerAdapter resizableHandler = new ResizableHandlerAdapter(){
			
			@Override
			public F resize() {
				
				F f = new F(){

					public void f(Event event) {
						
							for(DiagramElementResizableListener listener:diagramElement.getResizableListerners()){
								
								listener.onResize();
								
							}
						
					}
					
				};
				
				return f;
			}
			
			
			@Override
			public F stop() {
			
				F f = new F(){

					public void f(Event event) {
						
						for(DiagramElementResizableListener listener:diagramElement.getResizableListerners()){
							
							listener.onStop();
							
						}
						
					}
					
				};
				
				return f;
			}
			
			
			@Override
			public F start() {
				F f = new F(){

					public void f(Event event) {
						
						for(DiagramElementResizableListener listener:diagramElement.getResizableListerners()){
							
							listener.onStart();
							
						}
						
					}
					
				};
				
				return f;
			}
			
			
			
		};
		
		
		diagramElement.getJqueryObject().resizable(resizableHandler);
		
		
	}
	
}
