/**
 * Raphael Diagram - A crossbrowser SVG/VML library creating diagrams - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.diagram.event;

import com.google.gwt.event.shared.GwtEvent;

public class ShowEvent extends GwtEvent<ShowHandler> {
	
	private static Type<ShowHandler> TYPE;
	
	public static void fire(HasShowHandlers source){
		if (TYPE != null){
			ShowEvent ev = new ShowEvent();
			source.fireEvent(ev);
		}
	}
	
	public static Type<ShowHandler> getType(){
		if (TYPE == null){
			TYPE = new Type<ShowHandler>();
		}
		return TYPE;
	}
	
	protected ShowEvent(){
		
	}

	@Override
	protected void dispatch(ShowHandler handler) {
		handler.onShow(this);
	}

	@Override
	public Type<ShowHandler> getAssociatedType() {
		return TYPE;
	}

}
