/**
 * Raphael Diagram - A crossbrowser SVG/VML library creating diagrams - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.diagram;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.gwt.jquery.client.core.J4GUI;
import com.ebmwebsourcing.gwt.jquery.client.core.JqueryUI;
import com.ebmwebsourcing.gwt.raphael.client.core.Raphael;
import com.ebmwebsourcing.gwt.raphael.client.diagram.connector.ConnectorExtremity;
import com.ebmwebsourcing.gwt.raphael.client.diagram.connector.DiagramConnector;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElement;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramElementDragListener;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramElementListenerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramElementMouseListenerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramPanelListener;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramPanelListenerAdapter;
import com.ebmwebsourcing.gwt.raphael.client.diagram.event.DiagramPanelListenerBinder;
import com.ebmwebsourcing.gwt.raphael.client.diagram.semantic.DiagramEntity;
import com.ebmwebsourcing.gwt.raphael.client.diagram.semantic.Selectable;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.ScrollPanel;

/**
 * TODO: IMPROVE !!!!!!!
 * @author nfleury
 * 
 */
public class DiagramPanel extends ScrollPanel implements DiagramElementDragListener{
	
	
	private static final int MARGIN = 20;
	

	private ArrayList<DiagramElement> diagramElements = new ArrayList<DiagramElement>();
	
	private J4GUI jqueryObject ;
	
	private AbsolutePanel overlayPanel;
	
	private ArrayList<DiagramConnector> connectors = new ArrayList<DiagramConnector>();
	
	private Raphael raphael;
	
	private ArrayList<DiagramPanelListener> panelListeners = new ArrayList<DiagramPanelListener>();
	
	private ArrayList<Selectable> selectedElements = new ArrayList<Selectable>();

	private int width;

	private int height;
	
	private AbsolutePanel canvas;

	public static DiagramElement draggedElement;
	
	
	public DiagramPanel(int width, int height) {
		
		
		canvas = new AbsolutePanel();
		
		this.raphael = new Raphael(canvas, width, height);
		
//		this.setWidth(""+width);
//		this.setHeight(""+height);
		add(canvas);
		canvas.setPixelSize(width, height);
		setPixelSize(width, height);
		
		
		this.width = width;
		this.height = height;
		
		
	}
	
	
	public void refresh(){
		
		for(DiagramElement element : diagramElements){
			element.refresh();
		}
		
		for(DiagramConnector connector: connectors){
			connector.refresh();
		}
	}
	
	public J4GUI getJqueryObject() {
		return jqueryObject;
	}
	
	@Override
	protected void onLoad() {
		
		//This panel overlays the Canevas because Jquery doesnt support
		//svg element for selection
		
		this.overlayPanel	 = new AbsolutePanel();
		
		String layerId	     = this.getElement().getId()+"-overlay"; 
		
		this.overlayPanel.getElement().setId(layerId);
		
		overlayPanel.setPixelSize(width, height);
//		this.setHeight(""+height);
//		this.setWidth(""+width);
		//Set the overlay on same position of the current panel
		
//		this.ovelayPanel.setHeight(""+height);
//		this.ovelayPanel.setWidth(""+width);
		
		

		canvas.add(overlayPanel, 0, 0);
		
		
		
		JqueryUI jui 		 = new JqueryUI();
		
		this.jqueryObject = jui.$("#"+this.overlayPanel.getElement().getId());

//		this.jqueryObject.css("border","1px solid black");
		
		//Bind EVENTS
		new DiagramPanelListenerBinder(this);
		
		initListeners();
		
		super.onLoad();
		
		for(DiagramPanelListener listener:panelListeners){
			listener.onLoad();
		}
	
	}
	
	

	
	private void initListeners() {
		
		this.addPanelListener(new DiagramPanelListenerAdapter(){
			
	    	 @Override
		    	public void onDiagramElementsSelected(List<Selectable> elements) {
		    		 
		    		 
		    		 for(Selectable selectable : elements){
		    			
		    			 selectable.isSelected();
		    			 
		    		 }
		    	 
		    	 
		    	 }
		    	 
		    	 @Override
		    	public void onDiagramElementsUnselected(List<Selectable> unselectedElements) {
		    
		    		 for(Selectable selectable : unselectedElements){
		    			
		    		
		    			 selectable.isDeselected();
		    		 }
		    		 
		    		 
		    		 
		    	}
		    	 
		     });
		     
			
			
	
		
	}


	/**
	 * Get the list of all the element that have been selected
	 * @return
	 */
	public ArrayList<Selectable> getSelectedElements() {
		return selectedElements;
	}
	
	public void addPanelListener(DiagramPanelListener listener){
		this.panelListeners.add(listener);
	}
	
	public ArrayList<DiagramPanelListener> getPanelListeners() {
		return panelListeners;
	}
	
	@SuppressWarnings("unused")
	private void setSelectedElementsFromIds(String selectedIds){
		
		this.selectedElements.clear();
		
		String[] ids = selectedIds.split(",");
		
		for(int i=0;i<ids.length;i++){
			
			
			//Seach in diagramElements first
			DiagramElement element = this.getDiagramElementById(ids[i]);
			
			if (element!=null){
				
				if (element instanceof Selectable){
					this.addSelectedElement((Selectable)element);	
				}
				
				//if this is a connector
				if (element instanceof ConnectorExtremity){
				
					ConnectorExtremity connectorExtremity = (ConnectorExtremity) element;
					
					DiagramConnector connector = connectorExtremity.getConnector();
			
					
					if (connector instanceof Selectable){
						
						this.addSelectedElement((Selectable)connector);
						
					}
					
					
				}
				
				
			}
						
		}
		
		

	}
	
	
	public ArrayList<Selectable> getUnselectedElements(){
		
		ArrayList<Selectable> result = new ArrayList<Selectable>();
		
		ArrayList<String> copyOfPreviousSelectedElements = new ArrayList<String>();
		ArrayList<String> copyOfCurrentSelectedElements = new ArrayList<String>();
		
		//Copy the previous selected elements
		for(Selectable selectable:selectedElements){
			
			copyOfPreviousSelectedElements.add(new String(selectable.getId()));
			
		}
		
		//Get the new selected elements
		this.getSelectedElementsIds();
		
		//Now copy the newly selected elements to compare
		for(Selectable selectable:selectedElements){
			
			copyOfCurrentSelectedElements.add(new String(selectable.getId()));
			
			
			
		}
		
		//Now compare witch elements was selected previously to those which are now
		for(String id:copyOfPreviousSelectedElements){
			
			if (copyOfCurrentSelectedElements.contains(id)==false){
				
				DiagramElement element = getDiagramElementById(id); 
				
			
				
				if (element instanceof Selectable){
					
					result.add((Selectable)getDiagramElementById(id));
				
				//if we didn't found the element maybe thats because its a diagramConnector	
				}else if (element == null){
					

					
					DiagramConnector connector = getDiagramConnectorById(id);
					

					
					if (connector instanceof Selectable){
							
						result.add((Selectable)connector);
						
						
					}
					
					
				}
				
					
				
			}
			
		}
		

		
		return result;
	}
	
	
	public void addSelectedElement(Selectable element){
		
		if (this.selectedElements.contains(element)==false){
			this.selectedElements.add(element);		
		}
	
	}
	
	
	
	
	
	public void defaultSelectableStopFunction(){
		
        //get the selected elements and the unselected one at the same time
			
		triggerElementsUnselected(getUnselectedElements());
		
		triggerElementsSelectedListener(getSelectedElements());
		


	}
	
	public void triggerElementsSelectedListener(ArrayList<Selectable> selectedElements){
		
		for(DiagramPanelListener listener:panelListeners){
			listener.onDiagramElementsSelected(selectedElements);
		}
		
	}
	
	
	public void triggerElementsUnselected(ArrayList<Selectable> unselectedElements){
		
		for(DiagramPanelListener listener:panelListeners){
			listener.onDiagramElementsUnselected(unselectedElements);
		}
		
		
	}
	
	public void triggerElementSelected(Selectable element){
		
		for(DiagramPanelListener listener:panelListeners){
			
			if (selectedElements.contains(element)==false){
				listener.onDiagramElementSelected(element);
			}
				
		}		
		
	}
	
	
	private native void getSelectedElementsIds()/*-{
		  var t="";
		  
		  $wnd.$(".ui-selected").each(function(){
		 
		  	t=t+","+this.id;
 		 });	
		 	
		 
		 this.@com.ebmwebsourcing.gwt.raphael.client.diagram.DiagramPanel::setSelectedElementsFromIds(Ljava/lang/String;)(t);

	
	}-*/;
	
	
	public ArrayList<DiagramElement> getDiagramElements() {
		return diagramElements;
	}
	
	
	/**
	 * Add a connector to the drawing panel with default <br>
	 * positions that were specified by the diagram connector
	 * @param diagramConnector
	 */
	public void add(final DiagramConnector diagramConnector){
	

				
			DiagramPanel.this.add(diagramConnector.getBeginPoint());
			DiagramPanel.this.add(diagramConnector.getEndPoint());
			
			
			diagramConnector.getBeginPoint().addMouseListener(new DiagramElementMouseListenerAdapter(){
				@Override
				public void onMouseDown() {
				
					uniqueElementSelected((Selectable)diagramConnector);
					DiagramPanel.draggedElement = diagramConnector.getBeginPoint();
				}
			});
			
			diagramConnector.getEndPoint().addMouseListener(new DiagramElementMouseListenerAdapter(){
				@Override
				public void onMouseDown() {
				
					uniqueElementSelected((Selectable)diagramConnector);
					DiagramPanel.draggedElement = diagramConnector.getEndPoint();
				}
			});		
			
			diagramConnector.setDiagramPanel(DiagramPanel.this);
			
			diagramConnector.refresh();
			
			DiagramPanel.this.connectors.add(diagramConnector);
			
			diagramConnector.onLoad();
					


		
		
	}

	/**
	 * Add a connector to the drawing panel at the specified x and y positions
	 * @param diagramConnector
	 * @param x
	 * @param y
	 */
	public void add(final DiagramConnector diagramConnector,final int x,final int y){


				
			DiagramPanel.this.add(diagramConnector.getBeginPoint());
			DiagramPanel.this.add(diagramConnector.getEndPoint());
			
			
			diagramConnector.getBeginPoint().addMouseListener(new DiagramElementMouseListenerAdapter(){
				@Override
				public void onMouseDown() {
				
					uniqueElementSelected((Selectable)diagramConnector);
					DiagramPanel.draggedElement = diagramConnector.getBeginPoint();
				}
			});
			
			diagramConnector.getEndPoint().addMouseListener(new DiagramElementMouseListenerAdapter(){
				@Override
				public void onMouseDown() {
				
					uniqueElementSelected((Selectable)diagramConnector);
					DiagramPanel.draggedElement = diagramConnector.getEndPoint();
				}
			});		
			
			
			
			
			diagramConnector.setDiagramPanel(DiagramPanel.this);
			
	
			diagramConnector.getBeginPoint().setX(x+getHorizontalScrollPosition());
			diagramConnector.getBeginPoint().setY(y+getScrollPosition());
			
			diagramConnector.getEndPoint().setX(x+diagramConnector.X2_DISTANCE+getHorizontalScrollPosition());
			diagramConnector.getEndPoint().setY(y+diagramConnector.Y2_DISTANCE+getScrollPosition());
			
			diagramConnector.refresh();
			
			DiagramPanel.this.connectors.add(diagramConnector);
			
			diagramConnector.onLoad();

		

	}
	
	private void genericAdd(final DiagramElement diagramElement){

		//Add the svg element and the html artifact to diagram panel
		this.raphael.addElement(diagramElement.getSvgElement());
		
		//when element is removed => remove it from raphael canvas
		diagramElement.addDiagramElementListener(new DiagramElementListenerAdapter(){
			@Override
			public void onRemove() {
			
				removeDiagramElement(diagramElement);
			}
		});
	
		
		if (diagramElement instanceof DiagramEntity){


			this.diagramElements.add(diagramElement);
			
		}
		
		
		//If current element is selectable add a listener on mouse down
		if (diagramElement instanceof Selectable){
			
			diagramElement.setDefaultMouseListener((new DiagramElementMouseListenerAdapter(){
				
				
				
				
				@Override
				public void onMouseDown() {
				
					
					uniqueElementSelected((Selectable)diagramElement);
				
				}
				

				
				
			}));
		
		}else if ( (diagramElement instanceof DiagramEntity) && (diagramElement instanceof Selectable==false)){

			
			diagramElement.setDefaultMouseListener((new DiagramElementMouseListenerAdapter(){
				
				@Override
				public void onMouseDown() {
		
					DiagramPanel.draggedElement = diagramElement;

				
				}
				

			
		
		}));
		
		}
		
		diagramElement.addDragListener(this);
		
		diagramElement.setDiagramPanel(this);
		
		diagramElement.refresh();
		

		
	}
	
	
	public void uniqueElementSelected(Selectable element){
		triggerElementsUnselected(selectedElements);
		
		selectedElements.clear();
		
		addSelectedElement((Selectable)element);	
		
		triggerElementsSelectedListener(selectedElements);
		
		if (element instanceof DiagramElement){
		
			DiagramPanel.draggedElement =(DiagramElement) element;
		
		}
	}

	
	
	
	public void add(DiagramElement diagramElement) {
		
		this.genericAdd(diagramElement);
		
		this.overlayPanel.add(diagramElement, diagramElement.getX(), diagramElement.getY());
		updateCanvasBoundaries(diagramElement.getX(),diagramElement.getY(), diagramElement.getOffsetWidth(), diagramElement.getOffsetHeight());
		
	}

	
	public void add(DiagramElement diagramElement,int x,int y){
		
		this.genericAdd(diagramElement);
		
		
		this.overlayPanel.add(diagramElement, x+getHorizontalScrollPosition(), y+getScrollPosition());
		
		
		diagramElement.getSvgElement().setX(x+getHorizontalScrollPosition());
		diagramElement.getSvgElement().setY(y+getScrollPosition());
		
		updateCanvasBoundaries(x, y, diagramElement.getOffsetWidth(), diagramElement.getOffsetHeight());
		
	}
	
	public Raphael getRaphael() {
		return raphael;
	}
	
	
	
	public DiagramConnector getDiagramConnectorById(String id){
		
		for(DiagramConnector connector:this.connectors){
			
			if (connector.getId().equals(id)){
				return connector;
			}
			
		}
		
		return null;
	}
	
	
	public DiagramElement getDiagramElementById(String id){
		
		//Don't loose time we don't even want them !
		if (id.equals("") || id.equals(" ")){
			return null;
		}
		
		for(DiagramElement element:this.diagramElements){
			
			if (element.getId().equals(id)){
				return element;
			}
			
		}
		
		return null;
		
	}
	
	private void updateCanvasBoundaries(int x, int y, int width, int height){
		// assume x and y are in canvas coordinate (not sure !)
		
		if (x+width > canvas.getOffsetWidth()){
			raphael.setSize(x+width+MARGIN,this.height);
			canvas.setWidth(x+width+MARGIN+"px");
			overlayPanel.setWidth(width+x+MARGIN+"px");
			this.width = x+width+MARGIN;
			
			
		}
		
		if (y+height > canvas.getOffsetHeight()){
			raphael.setSize(this.width, y+height+MARGIN);
			canvas.setHeight(y+height+MARGIN+"px");
			overlayPanel.setHeight(height+y+MARGIN+"px");
			this.height = y+height+MARGIN;
		}
		
	}


	public void onDrag(DiagramElement diagramElement) {
		updateCanvasBoundaries(diagramElement.getX(), diagramElement.getY(), diagramElement.getOffsetWidth(), diagramElement.getOffsetHeight());
		
	}


	public void onStart(DiagramElement diagramElement) {
		updateCanvasBoundaries(diagramElement.getX(), diagramElement.getY(), diagramElement.getOffsetWidth(), diagramElement.getOffsetHeight());
		
	}


	public void onStop(DiagramElement diagramElement) {
		updateCanvasBoundaries(diagramElement.getX(), diagramElement.getY(), diagramElement.getOffsetWidth(), diagramElement.getOffsetHeight());
		
	}
	
	
	public int getRelativeX(DiagramElement diagramElement){
		
		// this is the relative x (does not care about scrolling)
		return diagramElement.getAbsoluteLeft() - canvas.getAbsoluteLeft();
		
		// impossible due to initial design :(
//		return canvas.getWidgetLeft(diagramElement);
		
		
	}
	
	public int getRelativeY(DiagramElement diagramElement){
//		return canvas.getWidgetTop(diagramElement);
		return diagramElement.getAbsoluteTop() - canvas.getAbsoluteTop();
	}
	
	@Override
	public void setPixelSize(int width, int height) {
		super.setPixelSize(width, height);
		this.width = width;
		this.height = height;
	}
	
	public void removeDiagramElement(DiagramElement diagramElement){
		this.diagramElements.remove(diagramElement);
		this.raphael.removeElement(diagramElement.getSvgElement());
	}
	

}
