/**
 * Raphael Diagram - A crossbrowser SVG/VML library creating diagrams - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.diagram.connector;

import java.util.HashMap;



public class MagnetPositionHelper {
	
	private Connectable connectable;
	
	private Connectable connectable1;
	private Connectable connectable2;

	public MagnetPositionHelper(Connectable connectable) {
		this.connectable = connectable;
	}
	
	public MagnetPositionHelper(Connectable connectable1,Connectable connectable2) {
		
		this.connectable1 = connectable1;
		this.connectable2 = connectable2;
		
	}
	
	public MagnetPosition getMagetTopLeftPosition(){
		
		MagnetPosition result = new MagnetPosition();
		
		
		int x = connectable.getConnectableElement().getX() - Magnet.getMAGNET_WIDTH();
		int y = connectable.getConnectableElement().getY() - Magnet.getMAGNET_HEIGHT();
		
		result.setX(x);
		result.setY(y);
		
		return result;
		
	}
	
	public MagnetPosition getMagetTopMiddlePosition(){
		
		MagnetPosition result = new MagnetPosition();
		
		int connectableWidthMiddle = connectable.getConnectableElement().getOffsetWidth() / 2;
		
		int x = connectable.getConnectableElement().getX() + (connectableWidthMiddle - (Magnet.getMAGNET_WIDTH()/2));
		int y = connectable.getConnectableElement().getY() - Magnet.getMAGNET_HEIGHT();
		
		result.setX(x);
		result.setY(y);
		
		return result;
	}
	
	public MagnetPosition getMagetTopRightPosition(){
		
		MagnetPosition result = new MagnetPosition();
		
		int x = connectable.getConnectableElement().getX() + connectable.getConnectableElement().getOffsetWidth();
		int y = connectable.getConnectableElement().getY() - Magnet.getMAGNET_HEIGHT();
		
		result.setX(x);
		result.setY(y);
		
		return result;
	}
	
	public MagnetPosition getMagetLeftMiddlePosition(){
		
		MagnetPosition result = new MagnetPosition();
		
		
		int connectableHeightMiddle = connectable.getConnectableElement().getOffsetHeight() / 2;
		
		int x = connectable.getConnectableElement().getX()  - Magnet.getMAGNET_WIDTH();
		int y = connectable.getConnectableElement().getY() 	+ (connectableHeightMiddle - (Magnet.getMAGNET_HEIGHT()/2));
		
		result.setX(x);
		result.setY(y);
		
		return result;
	}
	
	public MagnetPosition getMagetBottomLeftPosition(){
		
		MagnetPosition result = new MagnetPosition();
		
		int x = connectable.getConnectableElement().getX() - Magnet.getMAGNET_WIDTH();
		int y = connectable.getConnectableElement().getY() + connectable.getConnectableElement().getOffsetHeight() ;
		
		result.setX(x);
		result.setY(y);
		
		return result;
	}
	
	public MagnetPosition getMagetBottomMiddlePosition(){
		
		MagnetPosition result = new MagnetPosition();
		
		int connectableWidthMiddle = connectable.getConnectableElement().getOffsetWidth() / 2;
		
		int x = connectable.getConnectableElement().getX() + (connectableWidthMiddle - (Magnet.getMAGNET_WIDTH()/2));
		int y = connectable.getConnectableElement().getY() + connectable.getConnectableElement().getOffsetHeight();
		
		
	
		result.setX(x);
		result.setY(y);
		
		return result;
	}
	
	public MagnetPosition getMagetBottomRightPosition(){
		
		MagnetPosition result = new MagnetPosition();
		
		int x = connectable.getConnectableElement().getX() + connectable.getConnectableElement().getOffsetWidth() ;
		int y = connectable.getConnectableElement().getY() + connectable.getConnectableElement().getOffsetHeight() ;
		

		result.setX(x);
		result.setY(y);
		
		return result;
	}
	
	public MagnetPosition getMagetRightMidlePosition(){
		
		MagnetPosition result = new MagnetPosition();
		
		int connectableHeightMiddle = connectable.getConnectableElement().getOffsetHeight() / 2;
		
		int x = connectable.getConnectableElement().getX() + connectable.getConnectableElement().getOffsetWidth();
		int y = connectable.getConnectableElement().getY() 	+ (connectableHeightMiddle - (Magnet.getMAGNET_HEIGHT()/2));
		
				
		result.setX(x);
		result.setY(y);
		
		return result;
	}
	
	
	public ClosestMagnets getClosestsMagnets(){
		
		HashMap<Integer,ClosestMagnets> p = new HashMap<Integer,ClosestMagnets>();
		
		for(Magnet magnet1 : connectable1.getActualMagnets()){
			
			for(Magnet magnet2 : connectable2.getActualMagnets()){
				
				int distance = calculateDistance(magnet1.getX(), magnet1.getY(), magnet2.getX(), magnet2.getY());
				
//				DebugerHelper.debug("magnet1:"+magnet1.getId() +" to magnet2:"+magnet2.getId() + "distance =>"+distance);
				
				ClosestMagnets c = new ClosestMagnets();
				
				c.setConnectable1Magnet(magnet1);
				c.setConnectable2Magnet(magnet2);
				
				p.put(distance, c);
				
				
			}
			
		}
		
		int shortest = 0;
		int i = 0;
		for (Integer integer:p.keySet()){
			
			if (i == 0){
				shortest = integer;
			}
			
			if (integer<shortest){
				shortest = integer;
			}
			
			
			i++;
			
		}
		
//		DebugerHelper.debug("shortest distance:"+shortest);

		return p.get(shortest);
	}
	
	
	public int calculateDistance(int x, int y,int x2,int y2){
		
		int dx = x2 - x;
		int dy = y2 - y;
		
		int dxa = Math.abs(dx);
		int dya = Math.abs(dy);
		
		double dxs = Math.sqrt(dxa);
		double dys = Math.sqrt(dya);
		
		
		return (int)(dxs + dys);
	}
	
	
	public int bresenham(int x, int y,int x2,int y2){
		
      int w = x2 - x ;
      int h = y2 - y ;
      int dx1 = 0, dy1 = 0, dx2 = 0, dy2 = 0 ;
      if (w<0) dx1 = -1 ; else if (w>0) dx1 = 1 ;
      if (h<0) dy1 = -1 ; else if (h>0) dy1 = 1 ;
      if (w<0) dx2 = -1 ; else if (w>0) dx2 = 1 ;
      int longest = Math.abs(w) ;
      int shortest = Math.abs(h) ;
      if (!(longest>shortest)) {
          longest = Math.abs(h) ;
          shortest = Math.abs(w) ;
          if (h<0) dy2 = -1 ; else if (h>0) dy2 = 1 ;
          dx2 = 0 ;            
      }
      int numerator = longest >> 1 ;
      
      return numerator;
      
//      for (int i=0;i<=longest;i++) {
//          
//          
//          HTML div = new HTML();
//       
//       if (this.isDotted()){   
//          
//            if (i%2==0){  
//            
//                div.setHTML("<div style='border:0.05px black solid;width:0.01px;height:0.01px;background:#000;'></div>");           
//            
//            }else{
//            
//                div.setHTML("<div style='border:0.05px white solid;width:0.01px;height:0.01px;background:#FFF;'></div>");  
//            
//       }
//       }else{
//           
//           div.setHTML("<div style='border:0.05px black solid;width:0.01px;height:0.01px;background:#000;'></div>");
//       }
//            
////          System.out.println("Adding point to array:"+i);
//
//          this.points.add(i, div);
//          
//          this.boundaryPanel.add(div,x,y);
//         
//
//          numerator += shortest ;
//          if (!(numerator<longest)) {
//              numerator -= longest ;
//              x += dx1 ;
//              y += dy1 ;
//          } else {
//              x += dx2 ;
//              y += dy2 ;
//          }
//          
//   
//          
//      }
		
		
	}
	
	
	public class ClosestMagnets{
		
		private Magnet connectable1Magnet;
		private Magnet connectable2Magnet;
		
		public Magnet getConnectable1Magnet() {
			return connectable1Magnet;
		}
		
		public Magnet getConnectable2Magnet() {
			return connectable2Magnet;
		}
		
		public void setConnectable1Magnet(Magnet connectable1Magnet) {
			this.connectable1Magnet = connectable1Magnet;
		}
		
		public void setConnectable2Magnet(Magnet connectable2Magnet) {
			this.connectable2Magnet = connectable2Magnet;
		}
		
	}
	
	
	
	public class MagnetPosition{
		
		private int x;
		private int y;
		
		public void setX(int x) {
			this.x = x;
		}
		
		public void setY(int y) {
			this.y = y;
		}
		
		public int getX() {
			return x;
		}
		
		public int getY() {
			return y;
		}
		
		
	}
	
}
