/**
 * Raphael Diagram - A crossbrowser SVG/VML library creating diagrams - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.diagram.event;

import java.util.ArrayList;

import com.ebmwebsourcing.gwt.jquery.client.core.J4GUI;
import com.google.gwt.user.client.Event;
import com.j4g.client.api.F;


public class DiagramElementMouseListenerBinder {
	
	private J4GUI jqueryObject;
	
	public DiagramElementMouseListenerBinder(J4GUI jqueryObject, final ArrayList<DiagramElementMouseListener> mouseListeners){
		this.jqueryObject = jqueryObject;
		
		
		
		//Click
		this.jqueryObject.bind("click", new F(){
			
			public void f(Event event) {
					
					for(DiagramElementMouseListener listener:mouseListeners){
							
							listener.onClick();
						
					}
				
				
			}
			
			
		});
		

		//Mouse Down
		this.jqueryObject.bind("mousedown", new F(){
			
			public void f(Event event) {
					
					//event.stopPropagation();
				
					for(DiagramElementMouseListener listener:mouseListeners){
							
							listener.onMouseDown();
						
					}
				
				
			}
			
		});
		
		
		//Mouse Enter
		this.jqueryObject.bind("mouseenter", new F(){
			
			public void f(Event event) {

					for(DiagramElementMouseListener listener:mouseListeners){
				
							listener.onMouseEnter();
						
					}
				
				
			}
			
		});		
		
		//Mouse Leave
		this.jqueryObject.bind("mouseleave", new F(){
			
			public void f(Event event) {
				
					for(DiagramElementMouseListener listener:mouseListeners){
							
							listener.onMouseLeave();
						
					}
				
				
			}
			
		});				

		
		//Mouse Move
		this.jqueryObject.bind("mousemove", new F(){
			
			public void f(Event event) {
					
					for(DiagramElementMouseListener listener:mouseListeners){
							
							listener.onMouseMove();
						
					}
				
				
			}
			
		});
		
		
		//Mouse out
		this.jqueryObject.bind("mouseout", new F(){
			
			public void f(Event event) {
					
					for(DiagramElementMouseListener listener:mouseListeners){
							
							listener.onMouseOut();
						
					}
				
				
			}
			
		});	
		
		
		//Mouse Over
		this.jqueryObject.bind("mouseover", new F(){
			
			public void f(Event event) {
					
					for(DiagramElementMouseListener listener:mouseListeners){
							
							listener.onMouseOver();
						
					}
				
				
			}
			
		});	
		
		
		//Mouse Up
		this.jqueryObject.bind("mouseup", new F(){
			
			public void f(Event event) {
					
					for(DiagramElementMouseListener listener:mouseListeners){
							
							listener.onMouseUp();
						
					}
				
				
			}
			
		});	
		
		
		
		
		
		
		
	}
	
	
}
