/**
 * Raphael Diagram - A crossbrowser SVG/VML library creating diagrams - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.raphael.client.diagram.event;

import com.ebmwebsourcing.gwt.jquery.client.ui.handler.SortableHandler;
import com.ebmwebsourcing.gwt.raphael.client.diagram.DiagramPanel;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElement;
import com.google.gwt.user.client.Event;
import com.j4g.client.api.F;


public class DiagramElementSortableListenerBinder {

	private DiagramElement diagramElement;

	public DiagramElementSortableListenerBinder(DiagramElement element) {
		
		this.diagramElement = element;
		
		
		SortableHandler sortableHandler = new SortableHandler(){

			public F activate() {
					
				F f = new F(){

					public void f(Event event) {
						
							for(DiagramElementSortableListener listener:diagramElement.getSortableListerners()){
								
								listener.onActivate(diagramElement);
								
							}
						
					}
					
				};
				
				return f;
				
			}

			public F beforeStop() {
				F f = new F(){

					public void f(Event event) {
						
							for(DiagramElementSortableListener listener:diagramElement.getSortableListerners()){
								
								listener.onBeforeStop(diagramElement);
								
							}
						
					}
					
				};
				
				return f;
			}

			public F change() {
				F f = new F(){

					public void f(Event event) {
						
							for(DiagramElementSortableListener listener:diagramElement.getSortableListerners()){
								
								listener.onChange(diagramElement);
								
							}
						
					}
					
				};
				
				return f;
			}

			public F deactivate() {
				F f = new F(){

					public void f(Event event) {
						
							for(DiagramElementSortableListener listener:diagramElement.getSortableListerners()){
								
								listener.onDeactivate(diagramElement);
								
							}
						
					}
					
				};
				
				return f;
			}

			public F out() {
				F f = new F(){

					public void f(Event event) {
						
							for(DiagramElementSortableListener listener:diagramElement.getSortableListerners()){
								
								listener.onOut(diagramElement,DiagramPanel.draggedElement);
								
							}
						
					}
					
				};
				
				return f;
			}

			public F over() {
				F f = new F(){

					public void f(Event event) {
						
							for(DiagramElementSortableListener listener:diagramElement.getSortableListerners()){
								
								listener.onOver(diagramElement,DiagramPanel.draggedElement);
								
							}
						
					}
					
				};
				
				return f;
			}

			public F receive() {
				F f = new F(){

					public void f(Event event) {
						
							for(DiagramElementSortableListener listener:diagramElement.getSortableListerners()){
								
								listener.onReceive(diagramElement,DiagramPanel.draggedElement);
								
							}
						
					}
					
				};
				
				return f;
			}

			public F remove() {
				F f = new F(){

					public void f(Event event) {
						
							for(DiagramElementSortableListener listener:diagramElement.getSortableListerners()){
								
								listener.onRemove(diagramElement,DiagramPanel.draggedElement);
								
							}
						
					}
					
				};
				
				return f;
			}

			public F sort() {
				F f = new F(){

					public void f(Event event) {
							
							
						
							for(DiagramElementSortableListener listener:diagramElement.getSortableListerners()){
								
								listener.onSort(diagramElement);
								
							}
						
					}
					
				};
				
				return f;
			}

			public F start() {
				F f = new F(){

					public void f(Event event) {
						
							for(DiagramElementSortableListener listener:diagramElement.getSortableListerners()){
								
								listener.onStart(diagramElement);
								
							}
						
					}
					
				};
				
				return f;
			}

			public F stop() {
				F f = new F(){

					public void f(Event event) {
						
							for(DiagramElementSortableListener listener:diagramElement.getSortableListerners()){
								
								listener.onStop(diagramElement);
								
							}
						
					}
					
				};
				
				return f;
			}

			public F update() {
				F f = new F(){

					public void f(Event event) {
						
							for(DiagramElementSortableListener listener:diagramElement.getSortableListerners()){
								
								listener.onUpdate(diagramElement);
								
							}
						
					}
					
				};
				
				return f;
			}
			
			
		};
		
		
		
		
		diagramElement.getJqueryObject().sortable(sortableHandler);
		
		
	}
	
}
