/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram;

public class BPMNElementsPath {
	
	
	//////////////
	//GATEWAYS
	//////////////
	
	
	public static String GATEWAY_PARALLEL = "M15.561,29.782c-0.092,0-0.184-0.035-0.254-0.105L1.133,15.506c-0.068-0.067-0.105-0.159-0.105-0.255s0.038-0.187,0.105-0.254l14.173-14.17c0.141-0.141,0.368-0.141,0.509,0l14.173,14.17c0.067,0.067,0.105,0.159,0.105,0.254s-0.038,0.188-0.105,0.255l-14.173,14.17C15.745,29.747,15.653,29.782,15.561,29.782L15.561,29.782z M1.896,15.251l13.664,13.661l13.664-13.661L15.561,1.591L1.896,15.251L1.896,15.251z M23.12,13.691h-5.999v-6H14v6H8.001v3.12H14v6.001h3.12v-6.001h5.999V13.691z";
	
	public static String GATEWAY_EXCLUSIVE = "M15.561,29.783c-0.092,0-0.184-0.035-0.254-0.105L1.133,15.506c-0.068-0.067-0.105-0.159-0.105-0.254s0.038-0.187,0.105-0.254l14.173-14.17c0.141-0.141,0.369-0.141,0.509,0l14.173,14.17c0.067,0.067,0.105,0.159,0.105,0.254s-0.038,0.187-0.105,0.254L15.815,29.677C15.745,29.748,15.653,29.783,15.561,29.783L15.561,29.783z M1.896,15.251l13.664,13.662l13.664-13.662L15.561,1.591L1.896,15.251L1.896,15.251z M16.824,15.413l2.752-6.352c0.237-0.547-0.015-1.183-0.562-1.42c-0.553-0.239-1.185,0.015-1.421,0.562l-1.978,4.565L13.52,8.183c-0.248-0.542-0.888-0.78-1.432-0.533c-0.542,0.248-0.781,0.889-0.533,1.432l2.905,6.355l-2.914,6.726c-0.237,0.548,0.015,1.184,0.562,1.421c0.14,0.061,0.285,0.089,0.429,0.089c0.417,0,0.815-0.243,0.992-0.65l2.141-4.941l1.934,4.23c0.182,0.396,0.573,0.631,0.983,0.631c0.149,0,0.303-0.031,0.448-0.098c0.542-0.248,0.781-0.889,0.533-1.432L16.824,15.413z";
	
	public static String GATEWAY_INCLUSIVE = "M15.561,29.792c-0.096,0-0.187-0.038-0.254-0.105L1.133,15.506c-0.141-0.141-0.141-0.369,0-0.509l14.173-14.17c0.141-0.141,0.368-0.141,0.509,0l14.173,14.17c0.141,0.14,0.141,0.369,0,0.509l-14.173,14.18C15.748,29.753,15.656,29.792,15.561,29.792L15.561,29.792z M1.896,15.251l13.664,13.671l13.664-13.671L15.561,1.591L1.896,15.251L1.896,15.251z M15.561,23.611c-4.607,0-8.356-3.75-8.356-8.359c0-4.604,3.749-8.351,8.356-8.351c4.608,0,8.356,3.746,8.356,8.351C23.917,19.861,20.168,23.611,15.561,23.611L15.561,23.611z M15.561,9.061c-3.417,0-6.196,2.777-6.196,6.19c0,3.418,2.779,6.199,6.196,6.199s6.196-2.781,6.196-6.199C21.756,11.838,18.977,9.061,15.561,9.061L15.561,9.061z";

	public static String GATEWAY_EVENT_BASED = "M15.561,29.789c-0.092,0-0.184-0.035-0.254-0.105L1.133,15.513c-0.141-0.14-0.141-0.368,0-0.509L15.306,0.824c0.135-0.136,0.374-0.136,0.509,0l14.173,14.181c0.141,0.141,0.141,0.369,0,0.509l-14.173,14.17C15.745,29.754,15.653,29.789,15.561,29.789L15.561,29.789zM1.896,15.259L15.561,28.92l13.664-13.661L15.561,1.587L1.896,15.259L1.896,15.259zM15.561,23.739c-4.679,0-8.486-3.805-8.486-8.48c0-4.681,3.807-8.49,8.486-8.49s8.486,3.809,8.486,8.49C24.046,19.935,20.24,23.739,15.561,23.739L15.561,23.739zM15.561,7.489c-4.282,0-7.766,3.486-7.766,7.77c0,4.279,3.484,7.76,7.766,7.76c4.282,0,7.765-3.48,7.765-7.76C23.326,10.975,19.842,7.489,15.561,7.489L15.561,7.489zM15.561,22.429c-3.958,0-7.178-3.217-7.178-7.17c0-3.959,3.22-7.18,7.178-7.18c3.958,0,7.178,3.221,7.178,7.18C22.739,19.212,19.518,22.429,15.561,22.429L15.561,22.429zM15.561,8.798c-3.561,0-6.458,2.898-6.458,6.46c0,3.557,2.897,6.449,6.458,6.449s6.458-2.893,6.458-6.449C22.018,11.697,19.122,8.798,15.561,8.798L15.561,8.798zM18.583,19.869h-6.044c-0.158,0-0.297-0.104-0.344-0.254l-1.713-5.54c-0.045-0.146,0.006-0.304,0.128-0.395l4.735-3.53c0.128-0.096,0.303-0.096,0.431,0l4.734,3.53c0.122,0.091,0.174,0.25,0.129,0.395l-1.713,5.54C18.879,19.766,18.741,19.869,18.583,19.869L18.583,19.869zM12.804,19.148h5.513l1.56-5.043l-4.316-3.218l-4.316,3.218L12.804,19.148L12.804,19.148z";
	
	
	////////////
	//EVENTS
	/////////////
	
		//None (Empty)
	
	public static String EVENT_START_TOPLEVEL_NONE	  = "M15.688,30.186c-8.012,0-14.53-6.518-14.53-14.53c0-8.018,6.519-14.54,14.53-14.54c8.018,0,14.54,6.522,14.54,14.54C30.229,23.668,23.706,30.186,15.688,30.186L15.688,30.186z M15.688,1.836c-7.615,0-13.811,6.2-13.811,13.82c0,7.615,6.195,13.81,13.811,13.81c7.62,0,13.82-6.195,13.82-13.81C29.509,8.036,23.309,1.836,15.688,1.836L15.688,1.836z";
	
	public static String EVENT_END_NONE				 = "M15.567,0.722c-8.017,0-14.54,6.518-14.54,14.53s6.522,14.53,14.54,14.53c8.012,0,14.53-6.519,14.53-14.53S23.579,0.722,15.567,0.722z M15.567,27.361c-6.683,0-12.12-5.432-12.12-12.109c0-6.677,5.437-12.11,12.12-12.11c6.678,0,12.11,5.433,12.11,12.11C27.677,21.929,22.245,27.361,15.567,27.361z";
	
		//Message
	public static String EVENT_START_TOPLEVEL_MESSAGE = "M15.557,29.792c-8.012,0-14.53-6.519-14.53-14.53c0-8.018,6.518-14.54,14.53-14.54c8.018,0,14.541,6.522,14.541,14.54C30.098,23.273,23.575,29.792,15.557,29.792L15.557,29.792z M15.557,1.441c-7.615,0-13.81,6.2-13.81,13.82c0,7.615,6.195,13.81,13.81,13.81c7.621,0,13.82-6.194,13.82-13.81C29.377,7.641,23.178,1.441,15.557,1.441L15.557,1.441z M24.42,9.56c-0.002-0.024-0.007-0.047-0.014-0.07c-0.009-0.03-0.02-0.057-0.034-0.083c-0.003-0.004-0.003-0.009-0.006-0.014C24.365,9.39,24.362,9.39,24.36,9.388c-0.064-0.097-0.169-0.165-0.295-0.165H7.057c-0.125,0-0.229,0.067-0.294,0.165C6.761,9.389,6.759,9.39,6.758,9.392S6.756,9.396,6.755,9.398c-0.019,0.031-0.032,0.063-0.041,0.1C6.709,9.516,6.706,9.533,6.704,9.551C6.703,9.562,6.697,9.571,6.697,9.583v11.339c0,0.199,0.161,0.36,0.36,0.36h17.008c0.199,0,0.36-0.161,0.36-0.36V9.583C24.425,9.574,24.421,9.567,24.42,9.56z M22.891,9.942l-7.334,4.887L8.231,9.942H22.891z M7.417,20.562V10.265l7.94,5.297c0.061,0.04,0.13,0.061,0.2,0.061s0.14-0.021,0.199-0.061l7.948-5.296v10.296H7.417z"; 
	
	public static String EVENT_INTERMEDIATE_CATCHING_MESSAGE = "M24.42,9.56c-0.002-0.024-0.007-0.047-0.014-0.07c-0.009-0.03-0.02-0.057-0.034-0.083c-0.003-0.004-0.003-0.009-0.006-0.014C24.365,9.39,24.362,9.39,24.36,9.388c-0.064-0.097-0.169-0.165-0.295-0.165H7.057c-0.125,0-0.229,0.067-0.294,0.165C6.761,9.389,6.759,9.39,6.758,9.392S6.756,9.396,6.755,9.398c-0.019,0.031-0.032,0.063-0.041,0.1C6.709,9.516,6.706,9.533,6.704,9.551C6.703,9.562,6.697,9.571,6.697,9.583v11.339c0,0.199,0.161,0.36,0.36,0.36h17.008c0.199,0,0.36-0.161,0.36-0.36V9.583C24.425,9.574,24.421,9.567,24.42,9.56z M22.891,9.942l-7.334,4.887L8.231,9.942H22.891z M7.417,20.562V10.265l7.94,5.297c0.061,0.04,0.13,0.061,0.2,0.061s0.14-0.021,0.199-0.061l7.948-5.296v10.296H7.417z M15.557,29.782c-8.012,0-14.53-6.519-14.53-14.53s6.518-14.53,14.53-14.53c8.018,0,14.54,6.518,14.54,14.53S23.575,29.782,15.557,29.782L15.557,29.782z M15.557,1.441c-7.615,0-13.81,6.195-13.81,13.81c0,7.615,6.195,13.81,13.81,13.81c7.62,0,13.819-6.194,13.819-13.81C29.376,7.637,23.177,1.441,15.557,1.441L15.557,1.441z M15.557,28.083c-7.075,0-12.831-5.756-12.831-12.831c0-7.074,5.756-12.83,12.831-12.83c7.074,0,12.83,5.755,12.83,12.83C28.387,22.327,22.631,28.083,15.557,28.083L15.557,28.083z M15.557,3.142c-6.678,0-12.111,5.433-12.111,12.11c0,6.678,5.433,12.11,12.111,12.11s12.109-5.433,12.109-12.11C27.667,8.574,22.235,3.142,15.557,3.142L15.557,3.142z";
	
	public static String EVENT_INTERMEDIATE_THROWING_MESSAGE =  "M15.557,29.782c-8.012,0-14.53-6.519-14.53-14.53s6.518-14.53,14.53-14.53c8.018,0,14.54,6.518,14.54,14.53S23.575,29.782,15.557,29.782L15.557,29.782z M15.557,1.441c-7.615,0-13.81,6.195-13.81,13.81c0,7.615,6.195,13.81,13.81,13.81c7.62,0,13.819-6.194,13.819-13.81C29.376,7.637,23.177,1.441,15.557,1.441L15.557,1.441z M15.557,28.082c-7.075,0-12.831-5.756-12.831-12.83s5.756-12.83,12.831-12.83c7.074,0,12.83,5.755,12.83,12.83S22.631,28.082,15.557,28.082L15.557,28.082z M15.557,3.142c-6.678,0-12.111,5.433-12.111,12.11c0,6.678,5.433,12.109,12.111,12.109s12.109-5.432,12.109-12.109C27.667,8.574,22.235,3.142,15.557,3.142L15.557,3.142z M23.705,20.561H7.417v-8.879l7.808,5.198c0.101,0.067,0.217,0.101,0.333,0.101s0.231-0.033,0.332-0.1l7.815-5.198V20.561z M23.705,10.242v-0.3H7.417v0.298l8.14,5.42L23.705,10.242z";
	
	public static String EVENT_END_THROWING_MESSAGE = "M15.557,29.782c-8.012,0-14.53-6.519-14.53-14.53s6.518-14.53,14.53-14.53c8.018,0,14.54,6.518,14.54,14.53S23.575,29.782,15.557,29.782L15.557,29.782z M15.557,1.441c-7.615,0-13.81,6.195-13.81,13.81c0,7.615,6.195,13.81,13.81,13.81c7.62,0,13.819-6.194,13.819-13.81C29.376,7.637,23.177,1.441,15.557,1.441L15.557,1.441z M15.557,28.082c-7.075,0-12.831-5.756-12.831-12.83s5.756-12.83,12.831-12.83c7.074,0,12.83,5.755,12.83,12.83S22.631,28.082,15.557,28.082L15.557,28.082z M15.557,3.142c-6.678,0-12.111,5.433-12.111,12.11c0,6.678,5.433,12.109,12.111,12.109s12.109-5.432,12.109-12.109C27.667,8.574,22.235,3.142,15.557,3.142L15.557,3.142z M23.705,20.561H7.417v-8.879l7.808,5.198c0.101,0.067,0.217,0.101,0.333,0.101s0.231-0.033,0.332-0.1l7.815-5.198V20.561z M23.705,10.242v-0.3H7.417v0.298l8.14,5.42L23.705,10.242z";
	
	public static String EVENT_END_MESSAGE = "M23.705,20.561H7.417v-8.878l7.808,5.199c0.101,0.066,0.217,0.1,0.333,0.1s0.231-0.033,0.332-0.1l7.815-5.198V20.561z M23.705,10.243v-0.3H7.417v0.298l8.14,5.42L23.705,10.243z M15.567,0.722c-8.017,0-14.54,6.518-14.54,14.53s6.522,14.53,14.54,14.53c8.012,0,14.53-6.519,14.53-14.53S23.579,0.722,15.567,0.722zM15.567,27.361c-6.683,0-12.12-5.432-12.12-12.109c0-6.677,5.437-12.11,12.12-12.11c6.678,0,12.11,5.433,12.11,12.11C27.677,21.929,22.245,27.361,15.567,27.361z";
	
	public static String EVENT_TERMINATE = "M15.567,0.722c-8.017,0-14.54,6.522-14.54,14.54c0,8.012,6.522,14.53,14.54,14.53c8.012,0,14.53-6.519,14.53-14.53C30.097,7.244,23.579,0.722,15.567,0.722z M15.567,27.371c-6.683,0-12.12-5.432-12.12-12.109c0-6.683,5.437-12.12,12.12-12.12c6.678,0,12.11,5.437,12.11,12.12C27.677,21.939,22.245,27.371,15.567,27.371z M25.828,15.261c0,5.657-4.603,10.26-10.261,10.26c-5.657,0-10.26-4.603-10.26-10.26s4.603-10.26,10.26-10.26C21.225,5.001,25.828,9.604,25.828,15.261z";
	
		//Conditional
	public static String EVENT_START_TOPLEVEL_CONDITIONAL = "M15.567,29.792c-8.017,0-14.54-6.522-14.54-14.54c0-8.012,6.522-14.53,14.54-14.53c8.012,0,14.53,6.518,14.53,14.53C30.097,23.27,23.579,29.792,15.567,29.792L15.567,29.792z M15.567,1.441c-7.62,0-13.82,6.195-13.82,13.811c0,7.62,6.2,13.819,13.82,13.819c7.615,0,13.81-6.199,13.81-13.819C29.376,7.637,23.182,1.441,15.567,1.441L15.567,1.441z M21.912,23.692H9.217c-0.199,0-0.36-0.161-0.36-0.36V7.175c0-0.199,0.161-0.36,0.36-0.36h12.694c0.199,0,0.36,0.161,0.36,0.36v16.157C22.272,23.531,22.111,23.692,21.912,23.692L21.912,23.692z M9.577,22.972h11.974V7.535H9.577V22.972L9.577,22.972z M20.757,9.152c0.199,0,0.36-0.161,0.36-0.36s-0.161-0.36-0.36-0.36H10.367c-0.199,0-0.36,0.161-0.36,0.36s0.161,0.36,0.36,0.36H20.757L20.757,9.152z M20.757,12.612c0.199,0,0.36-0.161,0.36-0.36s-0.161-0.36-0.36-0.36H10.367c-0.199,0-0.36,0.161-0.36,0.36s0.161,0.36,0.36,0.36H20.757L20.757,12.612z M20.757,16.772c0.199,0,0.36-0.161,0.36-0.36s-0.161-0.36-0.36-0.36H10.367c-0.199,0-0.36,0.161-0.36,0.36s0.161,0.36,0.36,0.36H20.757L20.757,16.772z M20.757,21.382c0.199,0,0.36-0.161,0.36-0.36s-0.161-0.36-0.36-0.36H10.367c-0.199,0-0.36,0.161-0.36,0.36s0.161,0.36,0.36,0.36H20.757L20.757,21.382z";
	
	
		//Timer
	public static String EVENT_START_TOPLEVEL_TIMER = "M15.557,29.782c-8.012,0-14.53-6.519-14.53-14.53s6.518-14.53,14.53-14.53c8.018,0,14.541,6.518,14.541,14.53S23.575,29.782,15.557,29.782L15.557,29.782z M15.557,1.441c-7.615,0-13.81,6.195-13.81,13.81c0,7.615,6.195,13.81,13.81,13.81c7.621,0,13.82-6.194,13.82-13.81C29.377,7.637,23.178,1.441,15.557,1.441L15.557,1.441z M24.563,9.751c-0.008-0.022-0.01-0.046-0.022-0.067c-0.017-0.029-0.04-0.05-0.063-0.072c-1.877-2.951-5.17-4.919-8.921-4.919c-0.076,0-0.149,0.01-0.224,0.011c-0.019-0.003-0.036-0.011-0.056-0.011c-0.033,0-0.063,0.011-0.094,0.019c-1.847,0.065-3.571,0.605-5.061,1.504c-0.027,0.008-0.055,0.013-0.08,0.028c-0.028,0.017-0.047,0.041-0.069,0.063c-2.876,1.802-4.821,4.944-4.957,8.548c-0.016,0.045-0.022,0.093-0.019,0.144c0,0.009,0.009,0.014,0.011,0.022c-0.001,0.078-0.012,0.154-0.012,0.232c0,5.828,4.737,10.57,10.56,10.57c3.846,0,7.208-2.071,9.058-5.15c0.014-0.016,0.032-0.023,0.043-0.042c0.012-0.021,0.015-0.043,0.022-0.064c0.914-1.563,1.447-3.376,1.447-5.313C26.127,13.235,25.548,11.355,24.563,9.751z M24.211,19.951l-0.914-0.535c-0.114,0.211-0.241,0.415-0.372,0.616l0.912,0.534c-0.781,1.212-1.818,2.239-3.038,3.01l-0.541-0.908c-0.203,0.129-0.409,0.253-0.622,0.364l0.544,0.912c-1.364,0.729-2.918,1.146-4.567,1.154c0.013-0.037,0.023-0.075,0.023-0.116v-0.944c-0.027,0-0.053,0.004-0.08,0.004c-0.216,0-0.428-0.017-0.64-0.032v0.973c0,0.031,0.01,0.059,0.018,0.088c-1.625-0.103-3.143-0.6-4.46-1.4c0.003-0.005,0.009-0.007,0.012-0.012l0.534-0.891c-0.206-0.125-0.407-0.257-0.602-0.397l-0.544,0.908c-1.181-0.84-2.169-1.931-2.885-3.199l0.913-0.52c-0.118-0.208-0.224-0.424-0.325-0.643l-0.915,0.521c-0.593-1.256-0.935-2.652-0.943-4.13l1.048-0.074c0-0.241,0.017-0.478,0.036-0.714c-0.018-0.001-0.035-0.008-0.053-0.006L5.75,14.583c0.096-1.42,0.486-2.759,1.124-3.952l0.907,0.531c0.112-0.213,0.236-0.418,0.365-0.621l-0.904-0.529c0.742-1.172,1.717-2.182,2.87-2.951l0.537,0.899c0.198-0.134,0.405-0.256,0.615-0.374l-0.537-0.899c1.252-0.709,2.674-1.146,4.189-1.244v1.05c0.212-0.015,0.424-0.032,0.64-0.032c0.027,0,0.053,0.004,0.08,0.004v-1.05c1.553,0.013,3.017,0.391,4.322,1.045l-0.542,0.904c0.216,0.106,0.427,0.221,0.633,0.344l0.54-0.9c1.241,0.741,2.313,1.739,3.123,2.933l-0.923,0.524c0.137,0.198,0.262,0.403,0.382,0.611l0.917-0.521c0.732,1.269,1.186,2.714,1.286,4.257h-0.747c-0.131,0-0.24,0.073-0.304,0.178c0.007,0.131,0.019,0.261,0.02,0.394c0.066,0.087,0.166,0.148,0.284,0.148h0.76c0.006,0,0.01-0.003,0.016-0.003C25.39,17,24.961,18.575,24.211,19.951z M21.667,15.611c0.198,0,0.358-0.16,0.36-0.357c0.001-0.199-0.159-0.361-0.358-0.362l-5.815-0.038l1.438-8.332c0.034-0.196-0.098-0.382-0.293-0.416c-0.208-0.033-0.382,0.099-0.416,0.294l-1.51,8.75c-0.018,0.104,0.011,0.211,0.079,0.292s0.168,0.128,0.273,0.129l6.241,0.04C21.666,15.611,21.667,15.611,21.667,15.611L21.667,15.611z";
	
	public static String EVENT_INTERMEDIATE_CATCHING_TIMER = "M15.567,29.792c-8.017,0-14.54-6.522-14.54-14.54c0-8.012,6.522-14.53,14.54-14.53c8.013,0,14.531,6.518,14.531,14.53C30.098,23.269,23.58,29.792,15.567,29.792L15.567,29.792z M15.567,1.441c-7.62,0-13.82,6.195-13.82,13.81c0,7.62,6.2,13.819,13.82,13.819c7.615,0,13.811-6.199,13.811-13.819C29.377,7.637,23.182,1.441,15.567,1.441L15.567,1.441z M15.567,28.091c-7.08,0-12.839-5.76-12.839-12.84c0-7.075,5.76-12.83,12.839-12.83c7.075,0,12.831,5.755,12.831,12.83C28.398,22.332,22.642,28.091,15.567,28.091L15.567,28.091z M15.567,3.141c-6.683,0-12.12,5.433-12.12,12.11c0,6.683,5.437,12.119,12.12,12.119c6.678,0,12.11-5.437,12.11-12.119C27.677,8.574,22.245,3.141,15.567,3.141L15.567,3.141z M24.563,9.75c-0.008-0.022-0.01-0.046-0.022-0.067c-0.017-0.029-0.04-0.05-0.063-0.072c-1.877-2.951-5.17-4.919-8.921-4.919c-0.076,0-0.149,0.01-0.224,0.011c-0.019-0.003-0.036-0.011-0.056-0.011c-0.033,0-0.063,0.011-0.094,0.019c-1.847,0.065-3.571,0.605-5.061,1.504c-0.027,0.008-0.055,0.013-0.08,0.028c-0.028,0.017-0.047,0.041-0.069,0.063c-2.876,1.802-4.821,4.944-4.957,8.548c-0.016,0.045-0.022,0.094-0.019,0.145c0,0.008,0.009,0.014,0.011,0.021c-0.001,0.078-0.012,0.154-0.012,0.232c0,5.828,4.737,10.57,10.56,10.57c3.846,0,7.208-2.071,9.058-5.15c0.014-0.016,0.032-0.023,0.043-0.042c0.012-0.021,0.015-0.043,0.022-0.064c0.914-1.563,1.447-3.376,1.447-5.313C26.127,13.234,25.548,11.354,24.563,9.75z M24.211,19.95l-0.914-0.535c-0.114,0.211-0.241,0.415-0.372,0.616l0.912,0.534c-0.781,1.212-1.818,2.239-3.038,3.01l-0.541-0.908c-0.203,0.129-0.409,0.253-0.622,0.364l0.544,0.912c-1.364,0.729-2.918,1.146-4.567,1.154c0.013-0.037,0.023-0.075,0.023-0.116v-0.944c-0.027,0-0.053,0.004-0.08,0.004c-0.216,0-0.428-0.017-0.64-0.032v0.973c0,0.031,0.01,0.059,0.018,0.088c-1.625-0.103-3.143-0.6-4.46-1.4c0.003-0.005,0.009-0.007,0.012-0.012l0.534-0.891c-0.206-0.125-0.407-0.257-0.602-0.397l-0.544,0.908c-1.181-0.84-2.169-1.931-2.885-3.199l0.913-0.52c-0.118-0.208-0.224-0.424-0.325-0.643l-0.915,0.521C6.07,18.18,5.728,16.784,5.72,15.305l1.048-0.073c0-0.241,0.017-0.478,0.036-0.714c-0.018-0.001-0.035-0.008-0.053-0.006l-1.001,0.07c0.096-1.42,0.486-2.759,1.124-3.952l0.907,0.531c0.112-0.213,0.236-0.418,0.365-0.621l-0.904-0.529c0.742-1.172,1.717-2.182,2.87-2.951l0.537,0.899c0.198-0.134,0.405-0.256,0.615-0.374l-0.537-0.899c1.252-0.709,2.674-1.146,4.189-1.244v1.05c0.212-0.015,0.424-0.032,0.64-0.032c0.027,0,0.053,0.004,0.08,0.004v-1.05c1.553,0.013,3.017,0.391,4.322,1.045l-0.542,0.904c0.216,0.106,0.427,0.221,0.633,0.344l0.54-0.9c1.241,0.741,2.313,1.739,3.123,2.933l-0.923,0.524c0.137,0.198,0.262,0.403,0.382,0.611l0.917-0.521c0.732,1.269,1.186,2.714,1.286,4.257h-0.747c-0.131,0-0.24,0.073-0.304,0.178c0.007,0.132,0.019,0.261,0.02,0.394c0.066,0.088,0.166,0.148,0.284,0.148h0.76c0.006,0,0.01-0.003,0.016-0.003C25.39,17,24.961,18.574,24.211,19.95z M21.667,15.61c0.198,0,0.358-0.159,0.36-0.357c0.001-0.198-0.159-0.361-0.358-0.361l-5.815-0.038l1.438-8.332c0.034-0.196-0.098-0.382-0.293-0.416c-0.208-0.033-0.382,0.099-0.416,0.294l-1.51,8.75c-0.018,0.104,0.011,0.211,0.079,0.293c0.068,0.08,0.168,0.128,0.273,0.129l6.241,0.039C21.666,15.61,21.667,15.61,21.667,15.61L21.667,15.61z";
	
	/////////////
	//DATA
	//////////////
	
	//Data Object
	public static String DATA_DATAOBJECT	= "M33.125,12.362c-0.003-0.015-0.004-0.027-0.009-0.042c-0.019-0.062-0.049-0.118-0.096-0.161c-0.001-0.002-0.001-0.004-0.003-0.006l-12.56-11.34c-0.005-0.004-0.012-0.004-0.018-0.008c-0.041-0.034-0.09-0.056-0.145-0.068c-0.015-0.003-0.026-0.007-0.041-0.009c-0.014-0.001-0.024-0.007-0.038-0.007H1.387c-0.199,0-0.36,0.161-0.36,0.36v42.521c0,0.199,0.161,0.36,0.36,0.36h31.39c0.199,0,0.36-0.161,0.36-0.36V12.421C33.137,12.4,33.128,12.382,33.125,12.362z M20.578,1.892l11.264,10.17H20.578V1.892z M32.417,43.242H1.747v-41.8h18.11v10.98c0,0.199,0.161,0.36,0.36,0.36h12.199V43.242z";
	
	public static final String DATA_INPUT = "M33.125,12.362c-0.003-0.015-0.004-0.027-0.009-0.042c-0.019-0.062-0.049-0.118-0.096-0.161c-0.001-0.002-0.001-0.004-0.003-0.006L20.458,0.814C20.453,0.81,20.445,0.81,20.44,0.806c-0.041-0.033-0.089-0.056-0.143-0.068c-0.015-0.004-0.028-0.007-0.044-0.009c-0.013-0.001-0.024-0.007-0.037-0.007H1.387c-0.199,0-0.36,0.161-0.36,0.36v42.52c0,0.199,0.161,0.36,0.36,0.36h31.39c0.199,0,0.36-0.161,0.36-0.36v-31.18C33.137,12.4,33.128,12.382,33.125,12.362zM20.577,1.892l11.265,10.17H20.577V1.892zM32.417,43.241H1.747V1.441h18.109v10.98c0,0.199,0.161,0.36,0.36,0.36h12.2V43.241zM11.367,13.961c-0.016,0-0.031-0.003-0.046-0.009c-0.045-0.019-0.074-0.062-0.074-0.111v-3.62h-6.74c-0.066,0-0.12-0.054-0.12-0.12v-3.86c0-0.066,0.054-0.12,0.12-0.12h6.74V2.501c0-0.049,0.029-0.092,0.074-0.111c0.044-0.02,0.096-0.009,0.131,0.026l5.62,5.67c0.046,0.047,0.046,0.122,0,0.169l-5.62,5.67C11.429,13.949,11.398,13.961,11.367,13.961L11.367,13.961zM4.626,9.981h6.74c0.066,0,0.12,0.054,0.12,0.12v3.449l5.331-5.378l-5.331-5.378v3.448c0,0.066-0.054,0.12-0.12,0.12h-6.74V9.981L4.626,9.981z";
	public static final String DATA_OUTPUT = "M33.125,12.362c-0.003-0.015-0.004-0.027-0.009-0.042c-0.019-0.062-0.049-0.118-0.096-0.161c-0.001-0.002-0.001-0.004-0.003-0.006l-12.55-11.34c-0.005-0.004-0.013-0.004-0.018-0.008c-0.041-0.034-0.089-0.056-0.143-0.068c-0.016-0.003-0.028-0.007-0.044-0.009c-0.013-0.001-0.024-0.007-0.037-0.007H1.387c-0.199,0-0.36,0.161-0.36,0.36v42.52c0,0.199,0.161,0.36,0.36,0.36h31.39c0.199,0,0.36-0.161,0.36-0.36v-31.18C33.137,12.4,33.128,12.382,33.125,12.362zM20.587,1.892l11.254,10.169H20.587V1.892zM32.417,43.241H1.747V1.441h18.12v10.98c0,0.199,0.161,0.36,0.36,0.36h12.189V43.241zM16.793,7.976l-5.62,5.67c-0.023,0.023-0.054,0.036-0.085,0.036c-0.016,0-0.031-0.003-0.046-0.009c-0.045-0.019-0.074-0.062-0.074-0.111v-3.63h-6.74c-0.066,0-0.12-0.054-0.12-0.12v-3.85c0-0.066,0.054-0.12,0.12-0.12h6.74v-3.62c0-0.049,0.029-0.092,0.074-0.111c0.044-0.019,0.096-0.009,0.131,0.026l5.62,5.67C16.839,7.854,16.839,7.929,16.793,7.976z";
	public static final String COLLECTION_DATA_OBJECT ="M33.125,12.362c-0.003-0.015-0.004-0.027-0.009-0.042c-0.019-0.062-0.049-0.118-0.096-0.161c-0.001-0.002-0.001-0.004-0.003-0.006l-12.56-11.34c-0.005-0.004-0.012-0.004-0.018-0.008c-0.041-0.034-0.09-0.056-0.145-0.068c-0.015-0.003-0.026-0.007-0.041-0.009c-0.014-0.001-0.024-0.007-0.038-0.007H1.387c-0.199,0-0.36,0.161-0.36,0.36v42.521c0,0.199,0.161,0.36,0.36,0.36h31.39c0.199,0,0.36-0.161,0.36-0.36V12.421C33.137,12.4,33.128,12.382,33.125,12.362zM20.578,1.892l11.264,10.17H20.578V1.892zM32.417,43.242H1.747v-41.8h18.11v10.98c0,0.199,0.161,0.36,0.36,0.36h12.199V43.242zM13.658,42.862h-2.16v-9.851h2.16V42.862L13.658,42.862zM18.158,42.862h-2.16v-9.851h2.16V42.862L18.158,42.862zM22.658,42.862h-2.16v-9.851h2.16V42.862L22.658,42.862z";
	
	public static final String MESSAGE = "M31.59,1.056c-0.002-0.03-0.008-0.06-0.019-0.089c-0.006-0.018-0.013-0.034-0.021-0.05c-0.007-0.013-0.009-0.028-0.018-0.041c-0.004-0.006-0.013-0.005-0.018-0.011c-0.049-0.063-0.117-0.107-0.198-0.126c-0.012-0.003-0.021-0.005-0.034-0.007c-0.016-0.002-0.031-0.01-0.048-0.01H1.387c-0.011,0-0.02,0.005-0.031,0.006C1.332,0.73,1.309,0.735,1.285,0.742C1.263,0.749,1.243,0.756,1.223,0.767c-0.02,0.01-0.038,0.023-0.056,0.038c-0.02,0.015-0.037,0.031-0.053,0.05C1.107,0.863,1.098,0.867,1.092,0.876c-0.007,0.01-0.008,0.022-0.014,0.033C1.065,0.93,1.056,0.952,1.049,0.975C1.042,0.999,1.037,1.022,1.034,1.047C1.033,1.059,1.027,1.069,1.027,1.082v20.786c0,0.199,0.161,0.36,0.36,0.36h29.848c0.199,0,0.36-0.161,0.36-0.36V1.082C31.595,1.073,31.591,1.065,31.59,1.056z M30.089,1.441l-13.782,9.594L2.534,1.441H30.089z M1.747,21.507V1.771l14.354,9.998c0.062,0.044,0.134,0.065,0.206,0.065s0.144-0.021,0.206-0.064l14.362-9.998v19.735H1.747z";
	
	//////////////
	//CONNECTORS
	//////////////
	public static String CONNECTOR_ASSOCIATION_BEGINPOINT 		= "M4.959,4.605c0-0.003,0-0.006,0-0.009c0-0.1-0.041-0.189-0.106-0.254L1.615,1.105c-0.141-0.141-0.369-0.141-0.51,0s-0.141,0.368,0,0.509L4.092,4.6L1.105,7.585c-0.141,0.141-0.141,0.369,0,0.51c0.07,0.07,0.163,0.105,0.255,0.105s0.185-0.035,0.255-0.105l3.24-3.241c0.001,0,0-0.001,0.001-0.002C4.919,4.789,4.957,4.702,4.959,4.605z";
	public static String CONNECTOR_CONDITIONAL_SEQUENCE_FLOW 	= "M 0 5 L 8 0 L 16 5 L 8 10 L 0 5";
	public static final String CONNECTOR_DEFAULT_SEQUENCE_FLOW 	= "M13.465,3.96H8.014L4.88,0.827c-0.141-0.141-0.368-0.141-0.509,0s-0.141,0.368,0,0.509L6.996,3.96H1.387c-0.199,0-0.36,0.161-0.36,0.36s0.161,0.36,0.36,0.36h6.328l3.14,3.141c0.07,0.07,0.162,0.105,0.254,0.105s0.184-0.035,0.254-0.105c0.141-0.141,0.141-0.369,0-0.51L8.733,4.68h4.731V3.96z";
	
	
	///////////
	//MARKERS
	//////////
	
	// Task markers
	public static final String TASK_MARKER_SEND = "M19.068,1.6v12.37c0,0.331-0.269,0.6-0.6,0.6H1.6c-0.332,0-0.6-0.269-0.6-0.6V1.6C1,1.269,1.269,1,1.6,1h16.869C18.8,1,19.068,1.269,19.068,1.6z M10.04,8.46c0.125,0,0.249-0.038,0.355-0.116l8.29-6.08c0.268-0.196,0.325-0.571,0.129-0.839s-0.573-0.323-0.838-0.129l-7.936,5.82l-7.935-5.82C1.837,1.101,1.461,1.158,1.266,1.425C1.07,1.693,1.128,2.068,1.395,2.264l8.29,6.08C9.791,8.422,9.916,8.46,10.04,8.46L10.04,8.46z" ;
	public static final String TASK_MARKER_RECEIVE = "M19.085,1.27c-0.004-0.048-0.012-0.094-0.028-0.141c-0.011-0.033-0.026-0.063-0.043-0.093c-0.013-0.023-0.017-0.048-0.032-0.07c-0.011-0.014-0.026-0.021-0.038-0.035c-0.024-0.028-0.051-0.05-0.08-0.073c-0.033-0.026-0.065-0.051-0.103-0.069c-0.03-0.015-0.063-0.024-0.096-0.034c-0.042-0.012-0.082-0.022-0.126-0.025c-0.015-0.001-0.027-0.009-0.043-0.009H1.627c-0.015,0-0.028,0.007-0.043,0.009C1.542,0.733,1.502,0.743,1.461,0.755c-0.035,0.01-0.069,0.02-0.101,0.036c-0.034,0.017-0.064,0.04-0.095,0.063C1.233,0.88,1.203,0.905,1.177,0.937c-0.01,0.012-0.024,0.018-0.033,0.03C1.13,0.985,1.127,1.007,1.116,1.027C1.095,1.063,1.078,1.098,1.064,1.138c-0.013,0.04-0.02,0.078-0.024,0.118C1.038,1.279,1.027,1.298,1.027,1.322v12.37c0,0.331,0.269,0.6,0.6,0.6h16.869c0.331,0,0.6-0.269,0.6-0.6V1.322C19.096,1.304,19.087,1.288,19.085,1.27z M16.667,1.922l-6.6,4.846L3.46,1.922H16.667zM2.228,13.092V2.506l7.485,5.489c0.106,0.078,0.23,0.116,0.355,0.116s0.25-0.038,0.355-0.116l7.474-5.488v10.584H2.228z";
	public static final String TASK_MARKER_USER ="M19.096,12.285c-0.071-0.118-1.736-2.837-5.205-3.831c-0.122-0.186-0.273-0.348-0.408-0.471c0.051-0.071,0.081-0.151,0.128-0.224c0.644-0.749,1.048-1.709,1.048-2.772c0-2.352-1.918-4.265-4.275-4.265c-2.352,0-4.265,1.913-4.265,4.265c0,0.619,0.138,1.204,0.375,1.735C6.5,6.736,6.51,6.75,6.517,6.765C6.755,7.282,7.092,7.739,7.505,8.12C7.418,8.208,7.338,8.298,7.263,8.392H7.034L6.925,8.408c-3.258,0.983-5.715,4.127-5.818,4.26l-0.08,0.104l0.066,5.71h18.056v-6.107L19.096,12.285zM8.174,7.986c-0.78-0.42-1.8-1.71-1.35-2.16c0,0,2.02-1.74,3.86-1.3c1.84,0.45,3.331-0.49,3.331-0.49c0.17,1.21,0.029,2.69-1.051,4.01c0,0,0.78,0.54,0.78,1.08s0.09,1.34-0.72,2.149c-0.811,0.811-3.96,0.9-4.85,0c-0.9-0.899-0.9-1.31-0.9-1.909C7.274,8.767,7.694,8.466,8.174,7.986zM18.399,17.731h-2.79v-2.625h-0.75v2.625h-9.25v-2.685h-0.75v2.685H1.834L1.78,13.027c0.428-0.52,2.525-2.93,5.14-3.818c-0.006,0.054-0.021,0.1-0.021,0.158c0,0.722,0.049,1.214,1.008,2.173c0.672,0.68,2.072,0.753,2.643,0.753c0.96,0,2.185-0.197,2.74-0.751c0.831-0.832,0.838-1.665,0.83-2.231c2.549,0.879,3.993,2.848,4.279,3.277V17.731z";
	public static final String TASK_MARKER_MANUAL ="M18.019,14.296H3.087l-2.06-1.672V3.47l3.761-2.737l0.162,0c0,0,6.228-0.024,7.652,0c0.853,0.015,1.42,0.617,1.412,1.497c-0.002,0.247-0.053,0.5-0.146,0.733c3.194,0.007,6.608,0.014,7.729,0.014c1.417,0,2.05,0.892,2.05,1.776c0,0.863-0.598,1.789-1.58,1.917c0.226,0.315,0.34,0.673,0.339,1.022c-0.003,0.744-0.52,1.493-1.636,1.83c0.108,0.212,0.156,0.443,0.158,0.66c0.006,0.686-0.438,1.44-1.142,1.701c0.17,0.268,0.264,0.571,0.264,0.866C20.05,13.461,19.518,14.296,18.019,14.296L18.019,14.296zM3.442,13.296h14.577c0.646,0,1.031-0.206,1.031-0.549c0-0.302-0.313-0.738-0.879-0.738c-0.729,0-5.088-0.027-6.165-0.034l-0.241-0.001l0.007-1l0.24,0.001c0.018,0,0.037,0,0.056,0c0.817,0.005,3.165,0.018,4.981,0.018c1.605,0,2.104-0.01,2.239-0.019c0.364-0.023,0.642-0.441,0.639-0.787c-0.001-0.104-0.003-0.423-0.573-0.449c-0.186-0.009-0.426-0.015-0.707-0.02c-4.819,0.095-6.896,0.021-6.897,0.02l0.011-1c0,0,4.679-0.06,6.904-0.021l0.701-0.015c1.403,0,2.037-0.528,2.039-1.018c0.002-0.487-0.57-0.997-1.532-1.005l-8.131-0.014l-0.001-1c0,0,2.238-0.008,4.386-0.008c2.09,0,3.355,0.007,3.763,0.022c0.006,0,0.012,0,0.018,0l1.927,0.002c0.486,0,0.813-0.481,0.813-0.932c0-0.5-0.373-0.776-1.05-0.776c-2.291,0-14.154-0.028-14.154-0.028l0.002-1h5.135c0.215,0,0.43-0.36,0.434-0.727c0.004-0.48-0.311-0.486-0.43-0.488c-1.284-0.023-6.485-0.004-7.469,0L2.027,3.979v8.168L3.442,13.296L3.442,13.296z";
	public static final String TASK_MARKER_BUSINESS_RULE ="M1.027,0.722v2.857v0.846v8.95h17.156v-8.95V3.579V0.722H1.027z M5.387,4.425v3.7h-3.61v-3.7H5.387z M1.777,8.875h3.61v3.75h-3.61V8.875z M6.137,12.625v-3.75h11.296v3.75H6.137zM17.434,8.125H6.137v-3.7h11.296V8.125zM1.777,3.579V1.472h15.656v2.107H1.777z"; // Well, there is a rect missing from the original svg. 
	public static final String TASK_MARKER_SERVICE = "M12.121,16.962H9.489v-2.138L8.69,14.49l-1.52,1.518l-1.848-1.862l1.506-1.515l-0.337-0.8H4.354V9.197h2.138l0.337-0.798L5.31,6.881L7.171,5.02l1.521,1.509l0.798-0.33V4.064h2.632v2.135l0.807,0.331l1.51-1.51L16.3,6.881l-1.51,1.51l0.33,0.806h2.135v2.634h-2.136l-0.329,0.795l1.509,1.521l-1.861,1.86l-1.51-1.518l-0.807,0.335V16.962L12.121,16.962zM10.239,16.21h1.131v-1.884l1.735-0.724l1.333,1.342l0.801-0.8l-1.333-1.344l0.711-1.723h1.887V9.948h-1.888l-0.71-1.734l1.333-1.333l-0.802-0.8l-1.332,1.332l-1.735-0.71V4.814h-1.131v1.888L8.515,7.413L7.172,6.08l-0.8,0.801l1.345,1.344L6.99,9.948H5.105v1.131H6.99l0.727,1.723L6.38,14.145l0.792,0.8l1.344-1.342l1.724,0.724V16.21L10.239,16.21zM10.805,12.949c-1.343,0-2.437-1.093-2.437-2.435c0-1.351,1.094-2.447,2.437-2.447c1.349,0,2.446,1.097,2.446,2.447C13.251,11.856,12.153,12.949,10.805,12.949L10.805,12.949zM10.805,8.818c-0.93,0-1.686,0.76-1.686,1.696c0,0.929,0.756,1.686,1.686,1.686c0.936,0,1.695-0.757,1.695-1.686C12.5,9.578,11.74,8.818,10.805,8.818L10.805,8.818zM6.497,9.198H6.113C5.467,8.757,5.04,8.014,5.04,7.172c0-1.344,1.094-2.437,2.438-2.437c0.838,0,1.578,0.425,2.017,1.071V6.2l-0.52,0.214c-0.251-0.495-0.736-0.846-1.311-0.91L7.177,5.021l-1.86,1.861l0.495,0.496c0.069,0.57,0.418,1.048,0.906,1.299L6.497,9.198zM6.834,12.63l-0.337-0.8H6.161v1.478L6.834,12.63zM4.36,11.831v-0.742l-0.517,0.517l-0.799-0.801L4.36,9.488V9.432L3.665,7.747H1.778V6.616h1.888l0.71-1.734L3.045,3.549l0.799-0.8l1.333,1.332l1.735-0.71V1.472h1.13v1.896l1.684,0.696h0.059l1.324-1.316l0.801,0.8l-0.519,0.517h0.735v0.327l0.847-0.841L11.11,1.688L9.593,3.197l-0.8-0.33V0.722H6.161v2.145L5.354,3.197l-1.511-1.51l-1.86,1.862l1.508,1.51L3.162,5.865H1.027v2.632h2.136l0.328,0.799l-1.508,1.508l1.86,1.861l0.836-0.835H4.36zM12.126,6.199l0.808,0.331l0.674-0.674h-1.481V6.199z";
	public static final String TASK_MARKER_SCRIPT = "M11.076,14.352H1.204l-0.177-0.706c1.176-0.629,3.042-1.975,3.042-2.909c0-0.634-0.705-1.687-1.386-2.705C1.869,6.813,1.099,5.664,1.099,4.727c0-1.792,3.525-3.744,3.927-3.96l0.178-0.045h9.42l0.164,0.712c-0.996,0.484-3.579,2.019-3.579,3.292c0,0.739,0.627,1.619,1.29,2.55c0.776,1.091,1.58,2.22,1.58,3.4c0,2.274-2.81,3.586-2.929,3.641L11.076,14.352L11.076,14.352zM2.534,13.602h8.374c0.404-0.204,2.422-1.305,2.422-2.925c0-0.941-0.732-1.97-1.441-2.965c-0.734-1.032-1.429-2.007-1.429-2.985c0-1.293,1.55-2.513,2.729-3.255H5.3C3.931,2.225,1.849,3.731,1.849,4.727c0,0.709,0.774,1.866,1.458,2.888c0.778,1.162,1.513,2.261,1.513,3.122C4.819,11.822,3.539,12.913,2.534,13.602L2.534,13.602zM9.754,4.419V3.294h-6.39v1.125H9.754L9.754,4.419zM9.914,6.969V5.844h-6.39v1.125H9.914L9.914,6.969zM11.534,9.669V8.544h-6.38v1.125H11.534L11.534,9.669zM11.694,12.379v-1.125h-6.38v1.125H11.694L11.694,12.379z";
	
	// activity markers 
	public static final String ACTIVITY_MARKER_AD_HOC ="M1.031,5.251c-0.09-3,1.5-4.53,3.57-4.53c1.26,0,2.22,0.39,4.26,1.35c1.5,0.72,2.61,1.26,3.72,1.26c1.08,0,1.59-0.87,1.62-2.52h1.77c0.15,3.33-1.559,4.53-3.419,4.53c-1.2,0-2.28-0.36-4.35-1.319c-1.41-0.69-2.52-1.32-3.6-1.32c-1.08,0-1.74,0.75-1.77,2.55H1.031z";
	public static final String ACTIVITY_MARKER_COMPENSATION="M19.519,0.793c-0.195-0.106-0.432-0.093-0.616,0.03l-7.871,5.248V1.322c0-0.221-0.122-0.425-0.317-0.529c-0.196-0.105-0.432-0.093-0.616,0.03l-8.804,5.87C1.127,6.805,1.027,6.992,1.027,7.192c0,0.2,0.1,0.388,0.267,0.499l8.804,5.87c0.101,0.067,0.217,0.101,0.333,0.101c0.097,0,0.194-0.023,0.283-0.07c0.195-0.104,0.317-0.308,0.317-0.529V8.313l7.871,5.248c0.101,0.067,0.217,0.101,0.333,0.101c0.097,0,0.194-0.023,0.283-0.07c0.195-0.104,0.316-0.308,0.316-0.529V1.322C19.835,1.101,19.714,0.897,19.519,0.793zM9.831,11.941L2.709,7.192l7.122-4.749V11.941zM18.636,11.941l-7.123-4.749l7.123-4.749V11.941z";
	public static final String ACTIVITY_MARKER_LOOP="M17.534,8.972c0,4.549-3.702,8.249-8.253,8.249c-0.332,0-0.6-0.269-0.6-0.6s0.269-0.6,0.6-0.6c3.889,0,7.054-3.163,7.054-7.05c0-3.888-3.165-7.05-7.054-7.05s-7.053,3.163-7.053,7.05c0,2.642,1.153,4.919,2.626,5.416v-2.356c0-0.331,0.269-0.6,0.6-0.6s0.6,0.269,0.6,0.6v3.83c0,0.331-0.269,0.6-0.6,0.6H1.627c-0.332,0-0.6-0.269-0.6-0.6s0.269-0.6,0.6-0.6h2.255c-1.683-0.944-2.855-3.368-2.855-6.29c0-4.549,3.702-8.25,8.253-8.25C13.832,0.722,17.534,4.423,17.534,8.972z";
	public static final String ACTIVITY_MARKER_PARALLEL="M4.147,14.332h-3.12V0.722h3.12V14.332L4.147,14.332z M9.816,14.332V0.722h-3.12v13.61H9.816L9.816,14.332z M15.485,14.332V0.722h-3.119v13.61H15.485L15.485,14.332z";
	public static final String ACTIVITY_MARKER_SEQUENCIAL="M17.543,3.842H1.027v-3.12h16.516V3.842L17.543,3.842z M17.543,9.821v-3.12H1.027v3.12H17.543L17.543,9.821z M17.543,15.811v-3.119H1.027v3.119H17.543L17.543,15.811z";
	public static final String ACTIVITY_MARKER_SUBPROCESS_EXTENDED="M17.349,17.643H1.627c-0.332,0-0.6-0.269-0.6-0.6V1.322c0-0.332,0.269-0.6,0.6-0.6h15.722c0.331,0,0.6,0.269,0.6,0.6v15.722C17.949,17.375,17.68,17.643,17.349,17.643L17.349,17.643zM2.228,16.444H16.75V1.922H2.228V16.444L2.228,16.444zM13.419,9.784c0.331,0,0.6-0.269,0.6-0.6c0-0.332-0.269-0.6-0.6-0.6H5.559c-0.332,0-0.6,0.269-0.6,0.6c0,0.331,0.269,0.6,0.6,0.6H13.419L13.419,9.784z";
	public static final String ACTIVITY_MARKER_SUBPROCESS_COLLAPSED="M17.349,17.643H1.627c-0.332,0-0.6-0.269-0.6-0.6V1.322c0-0.332,0.269-0.6,0.6-0.6h15.722c0.331,0,0.6,0.269,0.6,0.6v15.722C17.949,17.375,17.68,17.643,17.349,17.643L17.349,17.643zM2.228,16.444H16.75V1.922H2.228V16.444L2.228,16.444zM9.488,13.713c0.332,0,0.6-0.269,0.6-0.6v-7.86c0-0.332-0.269-0.6-0.6-0.6s-0.6,0.269-0.6,0.6v7.86C8.888,13.445,9.157,13.713,9.488,13.713L9.488,13.713zM13.419,9.784c0.331,0,0.6-0.269,0.6-0.6c0-0.332-0.269-0.6-0.6-0.6H5.559c-0.332,0-0.6,0.269-0.6,0.6c0,0.331,0.269,0.6,0.6,0.6H13.419L13.419,9.784z";
	
}
