/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram;

import java.util.ArrayList;

import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Rectangle;
import com.ebmwebsourcing.geasytools.geasyui.api.selectable.ISelectable;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.INewUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IRemoveUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IResizeRequestEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.ISelectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUnselectedElementsEvent;

public class DefinitionPanelSelectionHandler implements IUIPanelHandler{
	
	private DescriptiveProcessPanel defPanel;
	
	private int SELECTION_RECT_WIDTH = 3;
	private int SELECTION_RECT_HEIGHT = 3;
	
	private ArrayList<Rectangle> rects;
	
	public DefinitionPanelSelectionHandler(DescriptiveProcessPanel defPanel) {
		this.defPanel 	= defPanel;
		this.rects 		= new ArrayList<Rectangle>();
	}
	
	public void onNewUIElement(INewUIElementEvent newElementEvent) {
	
		
	}

	public void onRemoveUIElement(IRemoveUIElementEvent removeElementEvent) {
	
		
	}

	public void onResizeRequest(IResizeRequestEvent event) {
	
		
	}

	public void onSelectUIElement(ISelectedElementsEvent selectedElementsEvent) {
		
		for(ISelectable s: selectedElementsEvent.getSelectedElements().values()){
			
			Rectangle nwRect = defPanel.getCanvas().createRectangle(s.getAbsoluteLeft()-defPanel.getAbsoluteLeft()-SELECTION_RECT_WIDTH, s.getAbsoluteTop() - defPanel.getAbsoluteTop()-SELECTION_RECT_HEIGHT, SELECTION_RECT_WIDTH, SELECTION_RECT_HEIGHT);
			nwRect.setStokeColour("blue");
			nwRect.setFillColour("blue");
			this.rects.add(nwRect);
		}
		
		
		
	}

	public void onUnSelectUIElement(
			IUnselectedElementsEvent unselectedElementsEvent) {
		
		//delete all rects
		for(Rectangle r: rects){
			r.remove();
		}
		
	}

}
