/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.collaboration;

import java.util.ArrayList;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.service.IInterfaceBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.LaneBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.common.ParticipantBean;
import com.ebmwebsourcing.bpmneditor.business.domain.di.api.IBPMNShape;
import com.ebmwebsourcing.bpmneditor.business.domain.di.impl.BPMNShape;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.DescriptiveProcessPanel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.LaneEditorModel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.PoolEditorModel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template.LaneFormTemplate;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template.PoolFormTemplate;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicFactory;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.google.gwt.user.client.DOM;

public class SwimlaneFactory implements IDiagramElementGraphicFactory{

	private DescriptiveProcessPanel definitionPanel;
	
	public SwimlaneFactory(DescriptiveProcessPanel definitionPanel) {
		
		this.definitionPanel = definitionPanel;
	
	}
	
	public Swimlane getSwimlane(IHasDragProxy bpmndragproxydata){
		
		if (bpmndragproxydata.getIUIElementType()==Lane.class){
		
			return this.createLane(null);
		
		}else if (bpmndragproxydata.getIUIElementType()==Pool.class){
			
			return this.createPool(null);
		
		}else if (bpmndragproxydata.getIUIElementType()==CollapsedPool.class){
			
			return this.createCollapsedPool(null);
		}
		
		
		return null;
	}
	

	//LANE
	public Lane createLane(LaneBean laneBean){
		
		String id = DOM.createUniqueId();
		
		if (laneBean!=null) id=laneBean.getId();
		
		Lane laneView = new Lane(definitionPanel, id);
		
		if (laneBean==null){
			
			laneView.getDiagramElement().setModelElement(new LaneBean(id));
			LaneEditorModel lem = (LaneEditorModel) laneView.getEditorModel();
			lem.setName("Lane");			
		
		}else{
			
			LaneEditorModel lem = (LaneEditorModel) laneView.getEditorModel();
			lem.setName(laneBean.getName());
			lem.setDocumentation(laneBean.getDocumentation());
			
			laneView.getDiagramElement().setModelElement(laneBean);
		}

		LaneFormTemplate lft = new LaneFormTemplate(laneView);
		
		return laneView;
	}
	
	//POOL
	public Pool createPool(ParticipantBean participantBean){
		
		String id = DOM.createUniqueId();
		
		if (participantBean!=null) id=participantBean.getId();
		
		Pool poolView = new Pool(definitionPanel,id);
		
		if (participantBean==null){
			
			ParticipantBean participantbean = new ParticipantBean(id);
			
			poolView.getDiagramElement().setModelElement(participantbean);
			
			PoolEditorModel pem = (PoolEditorModel) poolView.getEditorModel();
			pem.setName("Pool");
			
			//specify that pool is expanded
			BPMNShape poolShape = (BPMNShape) poolView.getDiagramElement();
			poolShape.setExpanded(true);

			
		}else{
			
			PoolEditorModel poolEditorModel = (PoolEditorModel) poolView.getEditorModel();
			poolEditorModel.setName(participantBean.getName());
			poolEditorModel.setDocumentation(participantBean.getDocumentation());
			
			poolView.getDiagramElement().setModelElement(participantBean);
			
		}
		

		PoolFormTemplate pft = new PoolFormTemplate(poolView);
		
		
		return poolView;
	}
	
	//COLLAPSED POOL
	public CollapsedPool createCollapsedPool(ParticipantBean participantBean){
		
		String id = DOM.createUniqueId();
		
		if (participantBean!=null) id=participantBean.getId();
		
		CollapsedPool cpoolView = new CollapsedPool(definitionPanel, id);
		
		if (participantBean==null){
			
			ParticipantBean participantbean = new ParticipantBean(id);
			
			cpoolView.getDiagramElement().setModelElement(participantbean);
			
			PoolEditorModel pem = (PoolEditorModel) cpoolView.getEditorModel();
			pem.setName("Collapsed Pool");
			
			//specify that pool is collapsed
			BPMNShape poolShape = (BPMNShape) cpoolView.getDiagramElement();
			poolShape.setExpanded(false);

			
			
		}else{
			
			PoolEditorModel poolEditorModel = (PoolEditorModel) cpoolView.getEditorModel();
			poolEditorModel.setName(participantBean.getName());
			poolEditorModel.setDocumentation(participantBean.getDocumentation());
			
			poolEditorModel.setInterfaces((ArrayList<IInterfaceBean>) participantBean.getInterfaces());
			poolEditorModel.setParticipantMultiplicityMax(String.valueOf(participantBean.getMaximumMultiplicity()));
			poolEditorModel.setParticipantMultiplicityMin(String.valueOf(participantBean.getMinimumMultiplicity()));
			
			
			cpoolView.getDiagramElement().setModelElement(participantBean);
			
		}
		

		PoolFormTemplate pft = new PoolFormTemplate(cpoolView);
		
		return cpoolView;
	}
	

	public IDiagramElementView getElement(
			Class<? extends IDiagramElementView> elementType) {
		// TODO Auto-generated method stub
		return null;
	}

	public IDiagramElementView getElementByDiagramElementModel(
			IDiagramElement diagramElement) {
		
		//POOL
		if (diagramElement.getModelElement() instanceof ParticipantBean){
			
			ParticipantBean participantBean = (ParticipantBean) diagramElement.getModelElement();
			
			IDiagramElementView poolView = null;
			
			IBPMNShape bpmnShape = (IBPMNShape) diagramElement;
			
			//we have to check if pool is expanded
			if (bpmnShape.isExpanded()==false){
				
				poolView = this.createCollapsedPool(participantBean);
				
			}else{
				
				poolView = this.createPool(participantBean);	
			
			}
			
			
			return poolView;
			
		}else if (diagramElement.getModelElement() instanceof LaneBean){
			
			LaneBean laneBean = (LaneBean) diagramElement.getModelElement();
			
			Lane laneView	  = this.createLane(laneBean);
			
			return laneView;
		}
		
		
		return null;
	}

	public IUIElement getElement(IHasDragProxy draggableProxyData) {
		// TODO Auto-generated method stub
		return null;
	}

	public IUIElement getElement(Class<? extends IUIElement> elementType) {
		// TODO Auto-generated method stub
		return null;
	}
	
	
	
}
