/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common;

import java.util.HashSet;

import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.DescriptiveProcessPanel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.connector.ConnectionMode;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.connector.MagnetElement;
import com.ebmwebsourcing.geasytools.geasygraph.api.IGraph;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectable;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IMagnet;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.events.IConnectableHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragMoveEvent;
import com.google.gwt.user.client.DOM;



public abstract class ConnectableFlowElement extends FlowElement implements IConnectable{
	
	private HashSet<IConnector> incommingConnectors;
	private HashSet<IConnector> outgoingConnectors;
	private HashSet<IMagnet>	magnets;
	
	private MagnetElement topLeftM;
	private MagnetElement topMiddleM;
	private MagnetElement topRightM;
	private MagnetElement leftM;
	private MagnetElement rightM;
	private MagnetElement bottomLeftM;
	private MagnetElement bottomRightM;
	private MagnetElement bottomMiddleM;
	
	
	private ConnectionMode connectionMode;
	
	
	public ConnectableFlowElement(DescriptiveProcessPanel definitionPanel, String id,ConnectionMode mode) {
		super(definitionPanel, id);
		
		this.incommingConnectors = new HashSet<IConnector>();
		this.outgoingConnectors  = new HashSet<IConnector>();
		this.magnets			 = new HashSet<IMagnet>();
		this.connectionMode		 = mode;
//		this.defaultHandlers	= new ConnectableElementDefaultHandlers(this);
//		this.defaultHandlers.attachDefaultHandlers();
		this.refreshMagnets();
	}

	

	
	@Override
	public void onMove(IDragMoveEvent event) {
		super.onMove(event);
	}
	
	
	@Override
	public void setRelativeX(float x) {
		super.setRelativeX(x);

	}
	
	@Override
	public void setRelativeY(float y) {
		super.setRelativeY(y);

	}
	
	@Override
	public void removeFromParent() {
		super.removeFromParent();
		
		if (topLeftM!=null) topLeftM.removeFromParent();
		if (topMiddleM!=null) topMiddleM.removeFromParent();
		if (topRightM!=null) topRightM.removeFromParent();
		if (leftM!=null) leftM.removeFromParent();
		if (rightM!=null) rightM.removeFromParent();
		if (bottomLeftM!=null) bottomLeftM.removeFromParent();
		if (bottomMiddleM!=null) bottomMiddleM.removeFromParent();
		if (bottomRightM!=null) bottomRightM.removeFromParent();
		
	}
	
	public HashSet<IConnector> getIncommingConnectors(){
		return incommingConnectors;
	}
	
	public HashSet<IConnector> getOutgoingConnectors(){
		return outgoingConnectors;
	}
	
	public void addConnectableHandler(IConnectableHandler connectableHandler){
		
	}
	
	public void addIncommingConnector(IConnector connector){
		this.incommingConnectors.add(connector);
	}
	
	public void addOutgoingConnector(IConnector connector){
		this.outgoingConnectors.add(connector);
	}
	
	public void refreshMagnets(){
		

		
		
		float topLeftMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft() +this.getUIPanel().getScrollLeft();
		float topLeftMY = this.getAbsoluteTop() - this.getUIPanel().getAbsoluteTop() +this.getUIPanel().getScrollTop(); 
		
		float topMiddleMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft() + (this.getWidth()) / 2 + this.getUIPanel().getScrollLeft();
		float topMiddleMY = this.getAbsoluteTop()- this.getUIPanel().getAbsoluteTop()+ this.getUIPanel().getScrollTop();
		
		float topRightMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft() + (this.getWidth())+ this.getUIPanel().getScrollLeft();
		float topRightMY = this.getAbsoluteTop()- this.getUIPanel().getAbsoluteTop()+ this.getUIPanel().getScrollTop();
		
		float rightMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft()+this.getWidth()+ this.getUIPanel().getScrollLeft();
		float rightMY = this.getAbsoluteTop()- this.getUIPanel().getAbsoluteTop()+(this.getHeight()/2)+ this.getUIPanel().getScrollTop();
		
		float leftMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft()+ this.getUIPanel().getScrollLeft();
		float leftMY = this.getAbsoluteTop()- this.getUIPanel().getAbsoluteTop()+(this.getHeight()/2)+ this.getUIPanel().getScrollTop();
		
		float bottomLeftMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft()+ this.getUIPanel().getScrollLeft();
		float bottomLeftMY = this.getAbsoluteTop()- this.getUIPanel().getAbsoluteTop()+this.getHeight()+ this.getUIPanel().getScrollTop();
 	
		float bottomRightMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft()+this.getWidth()+ this.getUIPanel().getScrollLeft();
		float bottomRightMY = this.getAbsoluteTop()- this.getUIPanel().getAbsoluteTop()+this.getHeight()+ this.getUIPanel().getScrollTop();
		
		float bottomMiddleMX = this.getAbsoluteLeft()-this.getUIPanel().getAbsoluteLeft()+(this.getWidth()/2)+ this.getUIPanel().getScrollLeft();
		float bottomMiddleMY = this.getAbsoluteTop()- this.getUIPanel().getAbsoluteTop()+this.getHeight()+ this.getUIPanel().getScrollTop();
		
		if (this.topLeftM ==null && this.topMiddleM ==null) {
			
			if (this.connectionMode == ConnectionMode.ALL ){
			this.topLeftM = new MagnetElement(this);
			this.topLeftM.getElement().setId(DOM.createUniqueId());
			this.topLeftM.setRelativeX(topLeftMX);
			this.topLeftM.setRelativeY(topLeftMY);
			this.magnets.add(topLeftM);
			}
			
			if (this.connectionMode == ConnectionMode.ALL || this.connectionMode == ConnectionMode.MIDDLES){
			this.topMiddleM = new MagnetElement(this);
			this.topMiddleM.getElement().setId(DOM.createUniqueId());
			this.topMiddleM.setRelativeX(topMiddleMX);
			this.topMiddleM.setRelativeY(topMiddleMY);
			this.magnets.add(topMiddleM);
			}
			
			if (this.connectionMode == ConnectionMode.ALL){
			this.topRightM = new MagnetElement(this);
			this.topRightM.getElement().setId(DOM.createUniqueId());
			this.topRightM.setRelativeX(topRightMX);
			this.topRightM.setRelativeY(topRightMY);
			this.magnets.add(topRightM);
			}
			
	
			if (this.connectionMode == ConnectionMode.ALL || this.connectionMode == ConnectionMode.MIDDLES){
			this.rightM = new MagnetElement(this);
			this.rightM.getElement().setId(DOM.createUniqueId());
			this.rightM.setRelativeX(rightMX);
			this.rightM.setRelativeY(rightMY);
			this.magnets.add(rightM);
			}
			
			if (this.connectionMode == ConnectionMode.ALL || this.connectionMode == ConnectionMode.MIDDLES){
			this.leftM = new MagnetElement(this);
			this.leftM.getElement().setId(DOM.createUniqueId());
			this.leftM.setRelativeX(leftMX);
			this.leftM.setRelativeY(leftMY);
			this.magnets.add(leftM);
			}
			
			if (this.connectionMode == ConnectionMode.ALL){
			this.bottomLeftM = new MagnetElement(this);
			this.bottomLeftM.getElement().setId(DOM.createUniqueId());
			this.bottomLeftM.setRelativeX(bottomLeftMX);
			this.bottomLeftM.setRelativeY(bottomLeftMY);
			this.magnets.add(bottomLeftM);
			}
			
			if (this.connectionMode == ConnectionMode.ALL){
			this.bottomRightM = new MagnetElement(this);
			this.bottomRightM.getElement().setId(DOM.createUniqueId());
			this.bottomRightM.setRelativeX(bottomRightMX);
			this.bottomRightM.setRelativeY(bottomRightMY);
			this.magnets.add(bottomRightM);
			}
			
			if (this.connectionMode == ConnectionMode.ALL || this.connectionMode == ConnectionMode.MIDDLES){
			this.bottomMiddleM = new MagnetElement(this);
			this.bottomMiddleM.getElement().setId(DOM.createUniqueId());
			this.bottomMiddleM.setRelativeX(bottomMiddleMX);
			this.bottomMiddleM.setRelativeY(bottomMiddleMY);
			this.magnets.add(bottomMiddleM);
			}
			

			
			
			
			
			
			
		} else {
			
			if (topLeftM!=null){
			this.topLeftM.setRelativeX(topLeftMX);
			this.topLeftM.setRelativeY(topLeftMY);				
			}
			
			if (topMiddleM!=null){
			this.topMiddleM.setRelativeX(topMiddleMX);
			this.topMiddleM.setRelativeY(topMiddleMY);
			}
			
			if (topRightM!=null){
			this.topRightM.setRelativeX(topRightMX);
			this.topRightM.setRelativeY(topRightMY);
			}
			
			if (rightM!=null){
			this.rightM.setRelativeX(rightMX);
			this.rightM.setRelativeY(rightMY);
			}
			
			if (leftM!=null){
			this.leftM.setRelativeX(leftMX);
			this.leftM.setRelativeY(leftMY);
			}
			
			if (bottomLeftM!=null){
			this.bottomLeftM.setRelativeX(bottomLeftMX);
			this.bottomLeftM.setRelativeY(bottomLeftMY);
			}
			
			if (bottomRightM!=null){
			this.bottomRightM.setRelativeX(bottomRightMX);
			this.bottomRightM.setRelativeY(bottomRightMY);
			}
			
			if (bottomMiddleM!=null){
			this.bottomMiddleM.setRelativeX(bottomMiddleMX);
			this.bottomMiddleM.setRelativeY(bottomMiddleMY);
			}
			
		}
		
		
		for(IMagnet m:this.getMagnets()){
			
			for(IConnectorPoint p :m.getConnectorPoints()){
				p.getConnector().refresh();
			}
			
		}
		
		
		
		
		
		
	}
	
	@Override
	public void refresh() {
		refreshMagnets();
	}
	
	public HashSet<IMagnet> getMagnets(){
		return magnets;
	}
	
	
	public IGraph getGraph(){
		return this.getUIPanel();
	}
	
	

	
	
}
