/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common;

import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Rectangle;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropAcceptedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropRefusedEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOutEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IOverEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.droppable.DropHandler;


/**
 * UI artifact that indicates if user can drop a
 * draggable element
 * 
 * @author nfleury
 *
 */
public class DropIndicatorHandler implements DropHandler{
	
	private CoreBPMNElement bpmnElement;
	
	private Rectangle r1;
	private Rectangle r2;
	private Rectangle r3;
	private Rectangle r4;
	
	
	public DropIndicatorHandler(CoreBPMNElement bpmnElement) {
		
		this.bpmnElement  = bpmnElement;
		
		this.r1 = bpmnElement.getDefinitionPanel().getCanvas().createRectangle(0, 0, 3, 3);
		this.r2 = bpmnElement.getDefinitionPanel().getCanvas().createRectangle(0, 0, 3, 3);
		this.r3 = bpmnElement.getDefinitionPanel().getCanvas().createRectangle(0, 0, 3, 3);
		this.r4 = bpmnElement.getDefinitionPanel().getCanvas().createRectangle(0, 0, 3, 3);
	
		this.hideIndicator();
	}

	@Override
	public void onDropAccepted(IDropAcceptedEvent event) {
		
		hideIndicator();
		
	}

	@Override
	public void onDropRefused(IDropRefusedEvent event) {
		
		hideIndicator();
		
	}

	@Override
	public void onOut(IOutEvent event) {
		
		hideIndicator();
		System.out.println("DROP INDICATOR OUT:"+bpmnElement.getName());
	}

	@Override
	public void onOver(IOverEvent event) {
		
		//System.out.println("DROP INDICATOR OVER:"+bpmnElement.getName());
		//can drop
		if (this.bpmnElement.getAcceptedTypes().contains(event.getDraggableElement().getClass())){
		
			this.showCanDropIndicator();
			
			
		//cannot drop			
		}{
			
			this.showCannotDropIndicator();
			
		}
		
		

		
	}
	
	private void refreshIndicatorPosition(){
		
		//top left
		this.r1.setX(bpmnElement.getAbsoluteLeft()-bpmnElement.getDefinitionPanel().getAbsoluteLeft());
		this.r1.setY(bpmnElement.getAbsoluteTop()-bpmnElement.getDefinitionPanel().getAbsoluteTop());
		
		//top right
		this.r2.setX(bpmnElement.getAbsoluteLeft()+bpmnElement.getWidth()-bpmnElement.getDefinitionPanel().getAbsoluteLeft());
		this.r2.setY(bpmnElement.getAbsoluteTop()-bpmnElement.getDefinitionPanel().getAbsoluteTop());

		//bottom left
		this.r3.setX(bpmnElement.getAbsoluteLeft()-bpmnElement.getDefinitionPanel().getAbsoluteLeft());
		this.r3.setY(bpmnElement.getAbsoluteTop()+bpmnElement.getHeight()-bpmnElement.getDefinitionPanel().getAbsoluteTop());

		//bottom right
		this.r4.setX(bpmnElement.getAbsoluteLeft()+bpmnElement.getWidth()-bpmnElement.getDefinitionPanel().getAbsoluteLeft());
		this.r4.setY(bpmnElement.getAbsoluteTop()+bpmnElement.getHeight()-bpmnElement.getDefinitionPanel().getAbsoluteTop());

		
	
	}
	
	
	private void showCannotDropIndicator(){
		
		refreshIndicatorPosition();
		
		this.r1.setStokeColour("red");
		this.r2.setStokeColour("red");
		this.r3.setStokeColour("red");
		this.r4.setStokeColour("red");
		
		this.r1.setVisible(true);
		this.r2.setVisible(true);
		this.r3.setVisible(true);
		this.r4.setVisible(true);
	
	}
	
	
	private void showCanDropIndicator(){
		
		refreshIndicatorPosition();
		
		this.r1.setStokeColour("green");
		this.r2.setStokeColour("green");
		this.r3.setStokeColour("green");
		this.r4.setStokeColour("green");

		
		this.r1.setVisible(true);
		this.r2.setVisible(true);
		this.r3.setVisible(true);
		this.r4.setVisible(true);
		
	}
	
	private void hideIndicator(){
		
			this.r1.setVisible(false);
			this.r2.setVisible(false);
			this.r3.setVisible(false);
			this.r4.setVisible(false);
	}
	
	
	
}
