/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.connector;

import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.DescriptiveProcessPanel;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Circle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Group;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.connectable.ConnectorPoint;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.user.client.DOM;


public class ConnectorPointElement extends ConnectorPoint{
	
	protected Circle circle;

	protected Group group;
	
	public ConnectorPointElement(IConnector connector,float x,float y) {
		super(connector);
		
		//this.circle = ((UIPanelImpl)this.getUIPanel()).getCanvas().createRectangle(0, 0, 10, 10);
		this.circle  = ((DescriptiveProcessPanel)this.getUIPanel()).getCanvas().createCircle(0, 0, 3);
		this.circle.setFillColour("red");
		
		this.group	 = ((DescriptiveProcessPanel)this.getUIPanel()).getCanvas().createGroup(x, y);
		this.group.appendChild(circle);
		//this.group.setContainer(((DefinitionPanel)this.getUIPanel()).getCanvas();
		//make adjustment for Drag dx/dy position
//		((DraggableElementDefaultHandlers)this.getDraggableElementDefaultHandlers()).getConfig().setDXadjustment(-7);
//		((DraggableElementDefaultHandlers)this.getDraggableElementDefaultHandlers()).getConfig().setDYadjustment(-8);
		
		
		initWidget(group);
		onAttach();
		
		this.getElement().setId(DOM.createUniqueId());
		
		this.addMouseMoveHandler(new MouseMoveHandler() {
			
			
			public void onMouseMove(MouseMoveEvent event) {
				
				event.preventDefault();
				
			}
		});
		
		
		this.addMouseDownHandler(new MouseDownHandler() {
			
			
			public void onMouseDown(MouseDownEvent event) {
				event.preventDefault();
				
			}
		});
		
		this.addMouseUpHandler(new MouseUpHandler() {
			
			
			public void onMouseUp(MouseUpEvent event) {
				event.preventDefault();
				group.toFront();
				circle.toFront();
			}
		});
		

		
		

	}
	
	@Override
	public void removeFromParent() {
		super.removeFromParent();
		group.remove();
	}
	
	@Override
	public float getRelativeX() {
		return this.getAbsoluteLeft() - this.getContainer().getAbsoluteLeft();
	}
	
	
	@Override
	public float getRelativeY() {
		return this.getAbsoluteTop() - this.getContainer().getAbsoluteTop();
	}
	
	@Override
	public int getAbsoluteLeft() {
		return group.getAbsoluteLeft();
	}

	@Override
	public int getAbsoluteTop() {
		return group.getAbsoluteTop();
	}


	public void setRelativeX(float x) {
		group.setX(x);
	}


	public void setRelativeY(float y) {
		group.setY(y);
	}

	public void hide(){
		group.setVisible(false);
	}
	
	public void show(){
		group.setVisible(true);
	}
	
	
	@Override
	public void onStart(IDragStartEvent event) {
		super.onStart(event);
		this.group.toFront();
	}
	
	@Override
	public void onMove(IDragMoveEvent event) {
		super.onMove(event);
		
		this.hide();
		
//		group.setX(group.getX()+6);
//		group.setY(group.getY()+0);
//		System.out.println("Group absolute top:"+group.getAbsoluteTop());
//		System.out.println("Group absolute left:"+group.getAbsoluteLeft());
	}
	
	@Override
	public void onStop(IDragStopEvent event) {
		super.onStop(event);
		
		this.show();
		
	}

	public void onAcceptedAfterDrop(IAcceptedAfterDropEvent event) {
		// TODO Auto-generated method stub
		
	}

	public void onAcceptedBeforeDrop(IAcceptedBeforeDropEvent event) {
		// TODO Auto-generated method stub
		
	}

	public void onRefusedAfterDrop(IRefusedAfterDropEvent event) {
		// TODO Auto-generated method stub
		
	}

	public void onRefusedBeforeDrop(IRefusedBeforeDropEvent event) {
		// TODO Auto-generated method stub
		
	}
	
}
