/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.connectors;

import java.util.HashSet;

import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.DescriptiveProcessPanel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.connector.ConnectorElement;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.DataAssociationEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicState;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.syntax.IDiagramElementSyntaxModelBinder;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IMainModelElement;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Circle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Marker;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Path;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.google.gwt.core.client.GWT;

public class DataAssociation extends ConnectorElement {

	
	private DataAssociationEditorModel editorModel ;
	
	private DataAssociationSyntaxModelBinder syntaxBinder;
	


	private IMainModelElement mainModel;
	
	public DataAssociation(IUIPanel uipanel, String id) {
		super(uipanel, id);


		
		Marker dataAssociationEndMarker = ((DescriptiveProcessPanel)uipanel).getCanvas().createMarker(id+"-dataAssociationEnd");
		Path dataAssociationArrow = ((DescriptiveProcessPanel)uipanel).getCanvas().createPath("M 0 0 L 10 5 L 0 10", 0, 0);
		dataAssociationArrow.setFillColour("white");
		//dataAssociationArrow.getElement().setAttribute("transform", "scale(0.5)");
		
		dataAssociationEndMarker.setRefX(10);
		dataAssociationEndMarker.setRefY(5);
		dataAssociationEndMarker.appendChild(dataAssociationArrow);

		dataAssociationEndMarker.setHeight(10);
		dataAssociationEndMarker.setWidth(10);
		dataAssociationEndMarker.setOrient("auto");
		
		
		this.linearPath.setMarkerEnd(dataAssociationEndMarker);
		
		
		
		linearPath.setStrokeDashArray("- ");


		
		Circle c = ((DescriptiveProcessPanel) this.getUIPanel()).getCanvas().createCircle(4, 3, 2);
		c.setFillColour("white");
		
		Marker m = ((DescriptiveProcessPanel) this.getUIPanel()).getCanvas().createMarker(
		"MessageFlowStart");
		m.setRefX(4);
		m.setRefY(3);
		m.appendChild(c);
//		m.appendChild(r);
		
		m.setHeight(200);
		m.setWidth(200);
		m.setOrient("auto");
		
		this.linearPath.setMarkerStart(m);
		
		this.syntaxBinder = new DataAssociationSyntaxModelBinder();
	}

	@Override
	public String getName() {
		return "Data Association";
	}

	@Override
	public HashSet<IDiagramElementViewConformityRule> getConformityRules() {
		HashSet<IDiagramElementViewConformityRule> rules = new HashSet<IDiagramElementViewConformityRule>();
		return rules;
	}

	@Override
	public IEditorModel getEditorModel() {
		
		if (editorModel==null){
			
			editorModel = GWT.create(DataAssociationEditorModel.class);
			
		}
		
		return editorModel;
	}

	@Override
	public IEditorView getEditorView() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public HashSet<IDiagramElementGraphicState> getStates() {
		
		HashSet<IDiagramElementGraphicState> states = new HashSet<IDiagramElementGraphicState>();
		
		return states;
	}

	@Override
	public IDiagramElementSyntaxModelBinder getSyntaxModelBinder() {
		return syntaxBinder;
	}

	@Override
	public void setEditorView(IEditorView editorView) {
		// TODO Auto-generated method stub

	}


	
	public IMainModelElement getMainModel(){
		return this.mainModel;
	}
	
	public void setMainModel(IMainModelElement mainModel){
		this.mainModel = mainModel;
	}

}
