/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.events;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.definition.IMessageEventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.process.event.definition.ITimerEventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.EndEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.IntermediateCatchEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.IntermediateThrowEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.StartEventBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.definition.MessageEventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.definition.TerminateEventDefinitionBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.event.definition.TimerEventDefinitionBean;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.DescriptiveProcessPanel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.CommonEditorModel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.EndNoneEventEditorModel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.MessageEventEditorModel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.StartTopLevelNoneEventEditorModel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.TimerEventEditorModel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template.EndEventFormTemplate;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template.MessageEventFormTemplate;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template.StartEventFormTemplate;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template.TerminateEventFormTemplate;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template.TimerEventFormTemplate;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicFactory;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.google.gwt.user.client.DOM;

public class EventFactory implements IDiagramElementGraphicFactory{
	
	private DescriptiveProcessPanel definitionPanel;
	
	public EventFactory(DescriptiveProcessPanel definitionPanel) {
		this.definitionPanel = definitionPanel;
	}

	public Event getEvent(IHasDragProxy bpmndragproxydata) {
		
		
		if (bpmndragproxydata.getIUIElementType()==StartTopLevelNoneEvent.class){
	
			return this.createStartTopLevelNoneEvent(null);
		
		}else if (bpmndragproxydata.getIUIElementType()==StartTopLevelMessageEvent.class){
			
			return this.createStartTopLevelMessageEvent(null);
		
		}else if (bpmndragproxydata.getIUIElementType()==EndNoneEvent.class){
		
			return this.createEndNoneEvent(null);
		
		}else if (bpmndragproxydata.getIUIElementType()==EndMessageEvent.class){
		
			return this.createEndMessageEvent(null);
			
		}else if (bpmndragproxydata.getIUIElementType()==IntermediateCatchingMessageEvent.class){
			
			return this.createIntermediateCatchingMessageEvent(null);
			
		}else if (bpmndragproxydata.getIUIElementType()==IntermediateThrowingMessageEvent.class){
			
			return this.createIntermediateThrowingMessageEvent(null);
			
		}else if (bpmndragproxydata.getIUIElementType()==TerminateEvent.class){
			
			return this.createTerminateEvent(null);
			
		}else if (bpmndragproxydata.getIUIElementType()==StartTimerEvent.class){
			
			return this.createStartTimerEvent(null);
			
		}else if (bpmndragproxydata.getIUIElementType()==IntermediateCatchingTimerEvent.class){
			
			return this.createIntermediateCatchingTimerEvent(null);
			
		}
		
		return null;
	}
	//START NONE
	private Event createStartTopLevelNoneEvent(StartEventBean startEventBean) {
		
		String id = DOM.createUniqueId(); 
		
		if (startEventBean!=null) id = startEventBean.getId();
		
		StartTopLevelNoneEvent startNoneEventView = new StartTopLevelNoneEvent(definitionPanel, id);
		
		if (startEventBean==null){
			
			startNoneEventView.getDiagramElement().setModelElement(new StartEventBean(id));
		
		}else{
			
			StartTopLevelNoneEventEditorModel startNoneEventEditorModel = (StartTopLevelNoneEventEditorModel) startNoneEventView.getEditorModel();
			startNoneEventEditorModel.setName(startEventBean.getName());
			startNoneEventEditorModel.setDocumentation(startEventBean.getDocumentation());
			
			startNoneEventView.getDiagramElement().setModelElement(startEventBean);
			
		}
		
		StartEventFormTemplate seft = new StartEventFormTemplate(startNoneEventView);
		
		return startNoneEventView;
	}
	
	
	//START MESSAGE
	private Event createStartTopLevelMessageEvent(StartEventBean startEventBean){
		
		 String id = DOM.createUniqueId();
		
		 if (startEventBean!=null) id = startEventBean.getId();
		 
		 StartTopLevelMessageEvent startMessageEventView = new StartTopLevelMessageEvent(definitionPanel, id); 
		 
		 if (startEventBean==null){
			 
			 MessageEventDefinitionBean medb = new MessageEventDefinitionBean();
			 StartEventBean seb = new StartEventBean(id);
			 seb.addTrigger(medb);
			 startMessageEventView.getDiagramElement().setModelElement(seb);
		 
		 }else{
			 
			MessageEventEditorModel startMessageEditorModel = (MessageEventEditorModel) startMessageEventView.getEditorModel();
			startMessageEditorModel.setName(startEventBean.getName());
			startMessageEditorModel.setDocumentation(startEventBean.getDocumentation());
			
			
			startMessageEventView.getDiagramElement().setModelElement(startEventBean);
			 
		 }
		 
		 MessageEventFormTemplate smft = new MessageEventFormTemplate(startMessageEventView);
		 
		return startMessageEventView;
	}
	
	//START TIMER 
	private Event createStartTimerEvent(StartEventBean startEventBean){
		
		String id = DOM.createUniqueId();
		
		if (startEventBean!=null) id = startEventBean.getId();
		
		StartTimerEvent startTimerEventView = new StartTimerEvent(definitionPanel, id);
		
		if (startEventBean==null){
			
			TimerEventDefinitionBean tedb = new TimerEventDefinitionBean();
			StartEventBean seb = new StartEventBean(id);
			seb.addTrigger(tedb);
			
			startTimerEventView.getDiagramElement().setModelElement(seb);
			
		}else{
			
			TimerEventEditorModel startTimerEditorModel = (TimerEventEditorModel) startTimerEventView.getEditorModel();
			
			startTimerEditorModel.setName(startEventBean.getName());
			startTimerEditorModel.setDocumentation(startEventBean.getDocumentation());
			if (startEventBean.getTriggers().get(0)!=null) startTimerEditorModel.setTimerEventDefinition((ITimerEventDefinitionBean) startEventBean.getTriggers().get(0));
		
			startTimerEventView.getDiagramElement().setModelElement(startEventBean);
		}
		
		TimerEventFormTemplate teft = new TimerEventFormTemplate(startTimerEventView);
		
		return startTimerEventView;
	}
	
	
	//INTERMEDIATE THROWING MESSAGE
	private Event createIntermediateThrowingMessageEvent(IntermediateThrowEventBean intermediateThrowBean){
		
		String id = DOM.createUniqueId();
		
		if (intermediateThrowBean!=null) id=intermediateThrowBean.getId();
		
		IntermediateThrowingMessageEvent throwingEventView = new IntermediateThrowingMessageEvent(definitionPanel, id);
		
		if (intermediateThrowBean==null){
			
			IntermediateThrowEventBean iteb = new IntermediateThrowEventBean(id);
			
			iteb.addResult(new MessageEventDefinitionBean());
			
			throwingEventView.getDiagramElement().setModelElement(iteb);
			
		}else{
		
			MessageEventEditorModel model = (MessageEventEditorModel) throwingEventView.getEditorModel();
			
			model.setName(intermediateThrowBean.getName());
			model.setDocumentation(intermediateThrowBean.getDocumentation());
			
			if (intermediateThrowBean.getResults().get(0)!=null) model.setMessageEventDefinition((IMessageEventDefinitionBean) intermediateThrowBean.getResults().get(0));
			
			throwingEventView.getDiagramElement().setModelElement(intermediateThrowBean);
			
		}
		
		MessageEventFormTemplate t = new MessageEventFormTemplate(throwingEventView);
		
		return throwingEventView;
	}
	
	//INTERMEDIATE CATCHING MESSAGE
	private Event createIntermediateCatchingMessageEvent(IntermediateCatchEventBean intermediateCatchBean){

		String id = DOM.createUniqueId();
		
		if (intermediateCatchBean!=null) id=intermediateCatchBean.getId();
		
		IntermediateCatchingMessageEvent catchingEventView = new IntermediateCatchingMessageEvent(definitionPanel, id);
		
		if (intermediateCatchBean==null){
			
			IntermediateCatchEventBean icb = new IntermediateCatchEventBean(id);
			
			icb.addTrigger(new MessageEventDefinitionBean());
			
			catchingEventView.getDiagramElement().setModelElement(icb);
			
		}else{
			
			
			MessageEventEditorModel model = (MessageEventEditorModel) catchingEventView.getEditorModel();
			
			model.setName(intermediateCatchBean.getName());
			model.setDocumentation(intermediateCatchBean.getDocumentation());
			
			if (intermediateCatchBean.getTriggers().get(0)!=null) model.setMessageEventDefinition((IMessageEventDefinitionBean) intermediateCatchBean.getTriggers().get(0));

			catchingEventView.getDiagramElement().setModelElement(intermediateCatchBean);
		}

		
		MessageEventFormTemplate t = new MessageEventFormTemplate(catchingEventView);
		
		return catchingEventView;
	}
	
	//INTERMEDIATE CATCHING TIMER
	private Event createIntermediateCatchingTimerEvent(IntermediateCatchEventBean intermediateCatchBean){
		

		String id = DOM.createUniqueId();

		if (intermediateCatchBean!=null) id=intermediateCatchBean.getId();
		
		IntermediateCatchingTimerEvent icTimerEventView = new IntermediateCatchingTimerEvent(definitionPanel, id);
		
		if (intermediateCatchBean==null){
			
			IntermediateCatchEventBean iceb = new IntermediateCatchEventBean(id);
			iceb.addTrigger(new TimerEventDefinitionBean());
			
			icTimerEventView.getDiagramElement().setModelElement(iceb);
			
		}else{
			
			TimerEventEditorModel model = (TimerEventEditorModel) icTimerEventView.getEditorModel();
			
			model.setName(intermediateCatchBean.getName());
			model.setDocumentation(intermediateCatchBean.getDocumentation());
		
			if (intermediateCatchBean.getTriggers().get(0)!=null) model.setTimerEventDefinition((ITimerEventDefinitionBean) intermediateCatchBean.getTriggers().get(0));
			
			icTimerEventView.getDiagramElement().setModelElement(intermediateCatchBean);
		}
		
		icTimerEventView.getDiagramElement().setModelElement(new IntermediateCatchEventBean(id));
		
		TimerEventFormTemplate t = new TimerEventFormTemplate(icTimerEventView);
		
		return icTimerEventView;
	}
	
	//END NONE
	private Event createEndNoneEvent(EndEventBean endEventBean){
		
		String id = DOM.createUniqueId();
		
		if (endEventBean!=null) id= endEventBean.getId();
		
		EndNoneEvent endNoneEventView = new EndNoneEvent(definitionPanel, id); 
		
		if (endEventBean==null){

			endNoneEventView.getDiagramElement().setModelElement(new EndEventBean(id));
			
		}else{
			
			EndNoneEventEditorModel endNoneEventEditorModel = (EndNoneEventEditorModel) endNoneEventView.getEditorModel();
			endNoneEventEditorModel.setName(endEventBean.getName());
			endNoneEventEditorModel.setDocumentation(endEventBean.getDocumentation());
			
			endNoneEventView.getDiagramElement().setModelElement(endEventBean);
			
		}

		
		EndEventFormTemplate t = new EndEventFormTemplate(endNoneEventView);
		
		return endNoneEventView;
	}
	
	//END MESSAGE
	private Event createEndMessageEvent(EndEventBean endEventBean){
		
		String id = DOM.createUniqueId();
		
		if (endEventBean!=null) id=endEventBean.getId(); 
			
		EndMessageEvent endMessageEventView = new EndMessageEvent(definitionPanel, id); 
		
		if (endEventBean==null){
			
			EndEventBean eb = new EndEventBean(id);
			MessageEventDefinitionBean medb = new MessageEventDefinitionBean();
			
			eb.addResult(medb);
			
			endMessageEventView.getDiagramElement().setModelElement(eb);			
		
		}else{
			
			MessageEventEditorModel model = (MessageEventEditorModel) endMessageEventView.getEditorModel();
			model.setName(endEventBean.getName());
			model.setDocumentation(endEventBean.getDocumentation());
			
			if (endEventBean.getResults().get(0)!=null) model.setMessageEventDefinition((IMessageEventDefinitionBean) endEventBean.getResults().get(0));
			
			endMessageEventView.getDiagramElement().setModelElement(endEventBean);
			
		}

		
		MessageEventFormTemplate t  =new MessageEventFormTemplate(endMessageEventView);
		
		return endMessageEventView;
	}

	//END TERMINATE
	private Event createTerminateEvent(EndEventBean endEventBean){
	
		String id = DOM.createUniqueId();
		
		if (endEventBean!=null) id=endEventBean.getId();
		
		TerminateEvent terminateEventView = new TerminateEvent(definitionPanel, id);
		
		if (endEventBean==null){
			
			EndEventBean eb = new EndEventBean(id);
			
			eb.addResult(new TerminateEventDefinitionBean());
			
			terminateEventView.getDiagramElement().setModelElement(eb);
			
		}else{
			
			CommonEditorModel model = (CommonEditorModel) terminateEventView.getEditorModel();
			
			model.setName(endEventBean.getName());
			model.setDocumentation(endEventBean.getDocumentation());
			
			terminateEventView.getDiagramElement().setModelElement(endEventBean);
		}
		
		
		

		
		TerminateEventFormTemplate t = new TerminateEventFormTemplate(terminateEventView);
		
		return terminateEventView;
	}
	

	
	
	public IDiagramElementView getElement(
			Class<? extends IDiagramElementView> elementType) {
		// TODO Auto-generated method stub
		return null;
	}

	public IDiagramElementView getElementByDiagramElementModel(
			IDiagramElement diagramElement) {
		
		//Start events
		if (diagramElement.getModelElement() instanceof StartEventBean){
			
			
			StartEventBean startEventBean = (StartEventBean) diagramElement.getModelElement();
			
			//Start none Event
			if (startEventBean.getTriggers().size()==0){

				return createStartTopLevelNoneEvent(startEventBean);
				
			}else if (startEventBean.getTriggers().size()==1){
				
				//Start Message Event
				if (startEventBean.getTriggers().get(0) instanceof MessageEventDefinitionBean){
					
					return createStartTopLevelMessageEvent(startEventBean);
				
				//Start Timer Event	
				}else if(startEventBean.getTriggers().get(0) instanceof TimerEventDefinitionBean) {
					
					return createStartTimerEvent(startEventBean);
					
				}
				
				
			}
			
		//INTERMEDIATE CATCH 
		}else if (diagramElement.getModelElement() instanceof IntermediateCatchEventBean){
			
			IntermediateCatchEventBean intermediateCatch = (IntermediateCatchEventBean) diagramElement.getModelElement();
			
			if (intermediateCatch.getTriggers().size()==1){
				
				//Message
				if (intermediateCatch.getTriggers().get(0) instanceof MessageEventDefinitionBean){
					
					return createIntermediateCatchingMessageEvent(intermediateCatch);
					
				//Timer	
				}else if (intermediateCatch.getTriggers().get(0) instanceof MessageEventDefinitionBean){
					
					return createIntermediateCatchingTimerEvent(intermediateCatch);
					
				}
				
			}
			
			
		//INTERMEDIATE THROW
		}else if (diagramElement.getModelElement() instanceof IntermediateThrowEventBean){	
			
			IntermediateThrowEventBean intermediateThrow = (IntermediateThrowEventBean) diagramElement.getModelElement();
			
			if (intermediateThrow.getResults().size()==1){
				
				//Message
				if (intermediateThrow.getResults().get(0) instanceof MessageEventDefinitionBean){
					
					return createIntermediateThrowingMessageEvent(intermediateThrow);
					
				}
				
			}
			
		//END EVENT	
		}else if (diagramElement.getModelElement() instanceof EndEventBean){
			
			EndEventBean endEventBean = (EndEventBean) diagramElement.getModelElement();
			
			//End none Event
			if (endEventBean.getResults().size()==0){
				
				return createEndNoneEvent(endEventBean);

			//End 	
			}else if (endEventBean.getResults().size()==1){
				
				//Message
				if (endEventBean.getResults().get(0) instanceof MessageEventDefinitionBean){
								
					return createEndMessageEvent(endEventBean);
				
				//Terminate
				}else if (endEventBean.getResults().get(0) instanceof TerminateEventDefinitionBean){
					
					return createTerminateEvent(endEventBean);
				}
				
				
			}
			
			
		}
		
		
		return null;
	}

	public IUIElement getElement(IHasDragProxy draggableProxyData) {
		// TODO Auto-generated method stub
		return null;
	}

	public IUIElement getElement(Class<? extends IUIElement> elementType) {
		// TODO Auto-generated method stub
		return null;
	}



}
