/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.gateways;

import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.DescriptiveProcessPanel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.ConnectableFlowElement;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.ContextualMenuHandler;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.connector.ConnectionMode;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.activities.TaskMenuDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.events.EndNoneMenuDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.gateways.ExclusiveGatewayMenuDragProxy;
import com.ebmwebsourcing.geasytools.diagrameditor.api.syntax.IDiagramElementSyntaxModelBinder;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Rectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasDragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasMenuDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.events.IDragProxyContextualMenuHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.impl.contextualmenu.DragProxyContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.ProxyRefusedBeforeDropEvent;


public abstract class Gateway extends ConnectableFlowElement implements IHasDragProxyContextualMenu{

	private Rectangle invisibleRectangle;
	
	public Gateway(DescriptiveProcessPanel definitionPanel, String id) {
		super(definitionPanel, id,ConnectionMode.MIDDLES);
	
		DragProxyContextualMenu dpm = new DragProxyContextualMenu(this);
		
		this.addContextualMenuHandler(new ContextualMenuHandler(this));
	}

	
	@Override
	protected void init() {
		super.init();
		
		this.label = this.getDefinitionPanel().getCanvas().createText(this.getWidth()/2, this.getHeight(), "");
		getGroup().appendChild(label);
	}
	
	@Override
	public SVGElement getMainShape() {
		
		if (invisibleRectangle==null){
			
			invisibleRectangle = this.getDefinitionPanel().getCanvas().createRectangle(0, 0, 22, 22);
			invisibleRectangle.setFillColour("white");
			invisibleRectangle.setStokeColour("white");
			//invisibleRectangle.rotate(50, false);
		}
		
		return invisibleRectangle;
	}
	
	public void addContextualMenuHandler(IDragProxyContextualMenuHandler handler) {
		handlerManager.addHandler(ProxyDragStartEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragMoveEvent.TYPE, handler);
		handlerManager.addHandler(ProxyDragStopEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedBeforeDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyAcceptedAfterDropEvent.TYPE, handler);
		handlerManager.addHandler(ProxyRefusedAfterDropEvent.TYPE, handler);	
	}
	
	public LinkedHashSet<IHasMenuDragProxy> getDragProxies() {
		LinkedHashSet<IHasMenuDragProxy> dps = new LinkedHashSet<IHasMenuDragProxy>();
		
		TaskMenuDragProxy tdp = new TaskMenuDragProxy(this.getUIPanel());
		tdp.setLabelVisible(false);
		tdp.setSmallIcon(true);
		
		ExclusiveGatewayMenuDragProxy gdp = new ExclusiveGatewayMenuDragProxy(getUIPanel());
		gdp.setLabelVisible(false);
		gdp.setSmallIcon(true);
		
		EndNoneMenuDragProxy endNoneDragProxy = new EndNoneMenuDragProxy(getUIPanel());
		endNoneDragProxy.setLabelVisible(false);
		endNoneDragProxy.setSmallIcon(true);
		
		dps.add(tdp);
		dps.add(gdp);
		dps.add(endNoneDragProxy);
		
		return dps;
	}
	
	public IDiagramElementSyntaxModelBinder getSyntaxModelBinder() {
		return new GatewaySyntaxModelBinder();
	}
	
	public Direction getMenuDirection() {
		// TODO Auto-generated method stub
		return null;
	}
}
