/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.palette;

import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.activities.CallActivityDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.activities.TaskDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.collaboration.CollapsedPoolDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.collaboration.LaneDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.collaboration.PoolDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.connectors.MessageFlowDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.connectors.SequenceFlowDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.data.DataInputDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.data.DataObjectDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.data.DataOutputDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.events.EndMessageDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.events.EndNoneDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.events.IntermediateCatchingMessageDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.events.IntermediateCatchingTimerDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.events.IntermediateThrowingMessageDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.events.StartTopLevelMessageDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.events.StartTopLevelNoneDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.events.StartTopLevelTimerDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.events.TerminateDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.gateways.EventBasedGatewayDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.gateways.ExclusiveGatewayDragProxy;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.dragproxy.impl.gateways.ParallelGatewayDragProxy;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.palette.Palette;
import com.ebmwebsourcing.geasytools.geasyui.impl.palette.PaletteGroup;

public class PrivateProcessPalette extends Palette {

	
	public PrivateProcessPalette(IUIPanel uipanel) {
		super(uipanel);
		
		//containers 
		PaletteGroup containersGroup = new PaletteGroup("Swimlanes");
		
		containersGroup.addElement(new CollapsedPoolDragProxy(uipanel));
		containersGroup.addElement(new PoolDragProxy(uipanel));
		containersGroup.addElement(new LaneDragProxy(uipanel));
		
		//activities
		PaletteGroup activitiesGroup = new PaletteGroup("Activities");
		activitiesGroup.addElement(new TaskDragProxy(uipanel));
		activitiesGroup.addElement(new CallActivityDragProxy(uipanel));
		
		//events
		PaletteGroup eventsGroup = new PaletteGroup("Events");
		
		StartTopLevelNoneDragProxy evdp1   			= new StartTopLevelNoneDragProxy(uipanel);
		StartTopLevelMessageDragProxy evdp2 		= new StartTopLevelMessageDragProxy(uipanel);
		StartTopLevelTimerDragProxy stltdp          = new StartTopLevelTimerDragProxy(uipanel);
		IntermediateCatchingMessageDragProxy icmdp 	= new IntermediateCatchingMessageDragProxy(uipanel);
		IntermediateThrowingMessageDragProxy itmdp 	= new IntermediateThrowingMessageDragProxy(uipanel);
		IntermediateCatchingTimerDragProxy ictdp    = new IntermediateCatchingTimerDragProxy(uipanel);
		EndNoneDragProxy evdp3						= new EndNoneDragProxy(uipanel);
		EndMessageDragProxy evdp4					= new EndMessageDragProxy(uipanel);
		TerminateDragProxy terminatedp				= new TerminateDragProxy(uipanel);
		
		eventsGroup.addElement(evdp1);
		eventsGroup.addElement(evdp2);
		eventsGroup.addElement(stltdp);
		eventsGroup.addElement(icmdp);
		eventsGroup.addElement(itmdp);
		eventsGroup.addElement(ictdp);
		eventsGroup.addElement(evdp3);
		eventsGroup.addElement(evdp4);
		eventsGroup.addElement(terminatedp);
		
		//Gateways
		PaletteGroup gatewaysGroup = new PaletteGroup("Gateways");
		
		ExclusiveGatewayDragProxy 	gwydp1	= new ExclusiveGatewayDragProxy(uipanel);
		ParallelGatewayDragProxy  	gwydp2	= new ParallelGatewayDragProxy(uipanel);
		EventBasedGatewayDragProxy 	gwydp3	= new EventBasedGatewayDragProxy(uipanel);
		
		gatewaysGroup.addElement(gwydp1);
		gatewaysGroup.addElement(gwydp2);
		gatewaysGroup.addElement(gwydp3);
		
		//connectors
		PaletteGroup connectorsGroup = new PaletteGroup("Connectors");
		
		SequenceFlowDragProxy sfDragProxy 	= new SequenceFlowDragProxy(uipanel);
		MessageFlowDragProxy mfdp 			= new MessageFlowDragProxy(uipanel);
		//DataAssociationDragProxy dadp 		= new DataAssociationDragProxy(uipanel);
		
		connectorsGroup.addElement(sfDragProxy);
		connectorsGroup.addElement(mfdp);
		//connectorsGroup.addElement(dadp);
		
		//Data
		PaletteGroup dataGroup				= new PaletteGroup("Data");
		
		DataObjectDragProxy dataDragProxy 	= new DataObjectDragProxy(uipanel);
		DataInputDragProxy dataInputDP	 	= new DataInputDragProxy(uipanel);
		DataOutputDragProxy dataOutputDP 	= new DataOutputDragProxy(uipanel);
		
		dataGroup.addElement(dataDragProxy);
		dataGroup.addElement(dataInputDP);
		dataGroup.addElement(dataOutputDP);
		
		this.addGroup(containersGroup);
		this.addGroup(activitiesGroup);
		this.addGroup(eventsGroup);
		this.addGroup(gatewaysGroup);
		this.addGroup(connectorsGroup);
		//this.addGroup(dataGroup);
		
	}
	
	
}
