/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.process.activities;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.api.standard.Constants.TaskType;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.CallActivityBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.ReceiveTaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.SendTaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.ServiceTaskBean;
import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.process.activity.TaskBean;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.DescriptiveProcessPanel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.CallActivityEditorModel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.editormodels.TaskEditorModel;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template.CallActivityFormTemplate;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.modeleditor.template.TaskFormTemplate;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementGraphicFactory;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;
import com.google.gwt.user.client.DOM;

public class ActivityFactory implements IDiagramElementGraphicFactory{
	
	private DescriptiveProcessPanel definitionPanel;
	
	public ActivityFactory(DescriptiveProcessPanel definitionPanel) {
		this.definitionPanel = definitionPanel;
	}

	public Activity getActivity(IHasDragProxy bpmndragproxydata) {
		
		
		if (bpmndragproxydata.getIUIElementType()==Task.class){
		
			return this.createTask(null);
		
		}else if (bpmndragproxydata.getIUIElementType()==CallActivity.class){
			
			return this.createCallActivity(null);
			
		}
		
		return null;
	}
	
	

	public CallActivity createCallActivity(CallActivityBean callActivityBean){
		
		String id = DOM.createUniqueId();
		
		if (callActivityBean!=null) id=callActivityBean.getId();
		
		CallActivity callActivityView = new CallActivity(definitionPanel, id);
		
		if (callActivityBean==null){
		
			callActivityView.getDiagramElement().setModelElement(new CallActivityBean(id));
			
			CallActivityEditorModel model = (CallActivityEditorModel) callActivityView.getEditorModel();
			model.setName("Call Activity");
			
		}else{
			
			CallActivityEditorModel model = (CallActivityEditorModel) callActivityView.getEditorModel();
			
			model.setName(callActivityBean.getName());
			model.setDocumentation(callActivityBean.getDocumentation());
			model.setDefaultSequenceFlow(callActivityBean.getDefaultSequenceFlow());
			model.setCalledElement(callActivityBean.getCalledElement());
			
			callActivityView.getDiagramElement().setModelElement(callActivityBean);
		}
		
		
		
		CallActivityFormTemplate caft = new CallActivityFormTemplate(callActivityView);
		
		return callActivityView;
	}
	
	
	public Task createTask(TaskBean taskBean){
		
		String id = DOM.createUniqueId();
		
		if (taskBean!=null) id=taskBean.getId();
		
		Task taskView = new Task(definitionPanel,id); 
		
		if (taskBean==null){
		
			taskView.getDiagramElement().setModelElement(new TaskBean(id));
			TaskEditorModel taskEditorModel = (TaskEditorModel) taskView.getEditorModel();
			taskEditorModel.setName("Task");
			taskEditorModel.setTaskType(TaskType.NONE);
			
		}else{
			
			TaskEditorModel taskEditorModel = (TaskEditorModel) taskView.getEditorModel();
			
			taskEditorModel.setName(taskBean.getName());
			taskEditorModel.setDocumentation(taskBean.getDocumentation());
			
			taskEditorModel.setTaskType(TaskType.NONE);
			
			//Service Task
			if (taskBean instanceof ServiceTaskBean){
				
				ServiceTaskBean serviceTaskBean = (ServiceTaskBean) taskBean;
				
				taskEditorModel.setImplementation(serviceTaskBean.getImplementation());
				taskEditorModel.setOperation(serviceTaskBean.getOperation());
				
				taskEditorModel.setTaskType(TaskType.SERVICE_TASK);
				
			//Send task
			}else if (taskBean instanceof SendTaskBean){
				
				SendTaskBean sendTaskBean = (SendTaskBean) taskBean;
				
				taskEditorModel.setImplementation(sendTaskBean.getImplementation());
				taskEditorModel.setMessage(sendTaskBean.getMessage());
				taskEditorModel.setOperation(sendTaskBean.getOperation());
				
				taskEditorModel.setTaskType(TaskType.SEND_TASK);
				
			//Receive task	
			}else if (taskBean instanceof ReceiveTaskBean){
				
				ReceiveTaskBean receiveTaskBean = (ReceiveTaskBean) taskBean;
				
				taskEditorModel.setMessage(receiveTaskBean.getMessage());
				taskEditorModel.setOperation(receiveTaskBean.getOperation());
				taskEditorModel.setInstantiate(receiveTaskBean.getInstanciate());
				
				taskEditorModel.setTaskType(TaskType.RECEIVE_TASK);
			}
			
			
			
			taskView.getDiagramElement().setModelElement(taskBean);
			
			
			
		}
		

		TaskFormTemplate tft = new TaskFormTemplate(taskView);

		
		
		return taskView;
	}

	public IDiagramElementView getElement(
			Class<? extends IDiagramElementView> elementType) {
		// TODO Auto-generated method stub
		return null;
	}

	public IDiagramElementView getElementByDiagramElementModel(
			IDiagramElement diagramElement) {
		
		//TASK
		if (diagramElement.getModelElement() instanceof TaskBean){
			
			TaskBean taskBean = (TaskBean) diagramElement.getModelElement(); 

			Task taskView = this.createTask(taskBean);
			
			return taskView;
			
		//CALL ACTIVITY	
		}else if (diagramElement.getModelElement() instanceof CallActivityBean){
			
			CallActivityBean callActivityBean = (CallActivityBean) diagramElement.getModelElement();
			
			return this.createCallActivity(callActivityBean);
			
		}
		
		
		
		return null;
	}

	public IUIElement getElement(IHasDragProxy draggableProxyData) {
		// TODO Auto-generated method stub
		return null;
	}

	public IUIElement getElement(Class<? extends IUIElement> elementType) {
		// TODO Auto-generated method stub
		return null;
	}
	
	
}
