/**
 * bpmn-diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasybpmneditor.bpmndiagram.process.activities;

import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.common.ConnectableFlowElement;
import com.ebmwebsourcing.geasybpmneditor.bpmndiagram.connectors.MessageFlow;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IRuleLevel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.RuleLevel;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;

public class TaskRules {
	
	/////////////////////
	//BPMN SPECIFICATION RULES: ERRORS
	///////////////////////

	public class SendTaskMustHaveAnOutgoingMessageFlow implements IDiagramElementViewConformityRule{
		
		private IDiagramElementView diagramElementView;
		
		public boolean canResolveNonConformity() {
			// TODO Auto-generated method stub
			return false;
		}

		public String getResolveConformityDescription() {
			return "Set actual task marker to 'None'";
		}

		public String getRuleDescription() {
			return "Current task is marked as a 'Send Task' but no outgoing message flow is connected";
		}

		public IRuleLevel getRuleLevel() {
			return RuleLevel.ERROR;
		}

		public String getRuleName() {
			return "Send Task must have an outgoing message flow";
		}

		public boolean isConform(IDiagramElementView diagramElementView) {
			
			this.diagramElementView = diagramElementView;
			
			ConnectableFlowElement connectableFlow = (ConnectableFlowElement) diagramElementView;
			
			boolean isConnectedToAnOutgointMessageFlow = false;
			
			for(IConnector connector:connectableFlow.getOutgoingConnectors()){
				
				if (connector instanceof MessageFlow){
					
					return true;
					
				}
				
			}
			
			
			return isConnectedToAnOutgointMessageFlow;
		}

		public void resolveNonConformity() {
			
			
		}

		public IDiagramElementView getNonConformElement() {
			return diagramElementView;
		}
		
	}
	
	
	
	
}
