/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.business.domain.to;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import com.ebmwebsourcing.bpmndiagram.business.domain.to.Constants.BPMNObjectType;



/**
 * This class is used to get all public informations about an user <br />
 * This class shouldn't be persisted
 * 
 * @author mcarpentier
 * 
 */
public class FlowNode implements Serializable {

    private static final long serialVersionUID = -4217847504186801919L;

    private String id;

    /** entity details* */
    private String title;
    private Lane lane;
    private Pool pool;
    private Set<Flow> outMsgFlow = new HashSet<Flow>();
    private Set<Flow> inMsgFlow = new HashSet<Flow>();
    private Set<Flow> outSeqFlow = new HashSet<Flow>();
    private Set<Flow> inSeqFlow = new HashSet<Flow>();

    private BPMNObjectType type;
    private String timer;
    private String positionX;
    private String positionY;
    private String width;
    private String height;
    private String[][] attributes;

    private String WSDLUrl;

	private Event associatedEvent;
    
    public String getWSDLUrl() {
		return WSDLUrl;
	}
    
    public void setWSDLUrl(String url) {
		WSDLUrl = url;
	}
    
    public void setAttributes(String[][] attributes) {
		this.attributes = attributes;
	}
    
    public String[][] getAttributes() {
		return attributes;
	}
    
    public String getTitle() {
        return title;
    }

    public String getId() {
        return id;
    }

    public Lane getLane() {
        return lane;
    }
    
    public Pool getPool() {
        return pool;
    }
    
    public Set<Flow> getOutgoingMsgFlow() {
        return outMsgFlow;
    }
    
    public Set<Flow> getInMsgFlow() {
        return inMsgFlow;
    }
    
    public Set<Flow> getOutgoingSeqFlow() {
        return outSeqFlow;
    }
    
    public Set<Flow> getInSeqFlow() {
        return inSeqFlow;
    }
    
    public void addInSeqFlow(Flow flow){
    	inSeqFlow.add(flow);
    	flow.setTargetService(this);
    }
    
    public void addInMsgFlow(Flow flow){
    	inMsgFlow.add(flow);
    	flow.setTargetService(this);
    }
    
    
    public void addOutSeqFlow(Flow flow){
    	outSeqFlow.add(flow);
    	flow.setSourceService(this);
    }
    
    public void addOutMsgFlow(Flow flow){
    	outMsgFlow.add(flow);
    	flow.setSourceService(this);
    }
    
    public BPMNObjectType getType() {
        return type;
    }
    public String getTimer() {
        return timer;
    }
    public String getPositionX() {
        return positionX;
    }
    
    public String getPositionY() {
        return positionY;
    }
    public String getWidth() {
        return width;
    }
    
    public String getHeight() {
        return height;
    }
    public void setTitle(final String title) {
        this.title = title;
    }


    public void setId(final String id) {
        this.id = id;
    }
    
    public void setLane(final Lane lane) {
        this.lane = lane;
    }

    public void setPool(final Pool pool) {
        this.pool = pool;
    }
    
    public void setOutMsgFlow(final Set<Flow> outMsgFlow) {
        this.outMsgFlow = outMsgFlow;
    }
    
    public void setInMsgFlow(final Set<Flow> inMsgFlow) {
        this.inMsgFlow = inMsgFlow;
    }

    public void setOutSeqFlow(final Set<Flow> outSeqFlow) {
        this.outSeqFlow = outSeqFlow;
    }
    
    public void setInSeqFlow(final Set<Flow> inSeqFlow) {
        this.inSeqFlow = inSeqFlow;
    }
    
    
    
    
    
    public void setType(final BPMNObjectType type) {
        this.type = type;
    }
    public void setTimer(final String timer) {
        this.timer = timer;
    }
    public void setPositionX(String positionX) {
        this.positionX = positionX;
    }
    public void setPositionY(String positionY) {
        this.positionY = positionY;
    }
    public void setWidth(String width) {
        this.width = width;
    }
    public void setHeight(String height) {
        this.height = height;
    }

	public void setAssociatedEvent(Event event) {
		this.associatedEvent = event;
	}
	
	public Event getAssociatedEvent() {
		return associatedEvent;
	}
	
	
}
