/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.business.domain.to;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;



/**
 * This class is used to get all public informations about an user <br />
 * This class shouldn't be persisted
 * 
 * @author mcarpentier
 * 
 */
public class Pool implements Serializable {

    private static final long serialVersionUID = -4217847504186801919L;

    private String id;

    /** entity details* */
    private String name;
    private Set<Lane> lanes = new HashSet<Lane>();
    private String positionX;
    private String positionY;
    private String width;
    private String height;

    public String getName() {
        return name;
    }

    public String getId() {
        return id;
    }
    public Set<Lane> getLanes() {
        return lanes;
    }
    public String getPositionX() {
        return positionX;
    }
    
    public String getPositionY() {
        return positionY;
    }
    public String getWidth() {
        return width;
    }
    
    public String getHeight() {
        return height;
    }
    public void setName(final String name) {
        this.name = name;
    }

    public void addLane(Lane lane){
    	this.lanes.add(lane);
    	lane.setPool(this);
    }
    
    
    public void setId(final String id) {
        this.id = id;
    }
    
    public void setLanes(final Set<Lane> lane) {
        this.lanes = lane;
    }
    public void setPositionX(String positionX) {
        this.positionX = positionX;
    }
    public void setPositionY(String positionY) {
        this.positionY = positionY;
    }
    public void setWidth(String width) {
        this.width = width;
    }
    public void setHeight(String height) {
        this.height = height;
    }
}
