/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.business.domain.util;

import java.util.HashMap;

import com.ebmwebsourcing.bpmndiagram.business.domain.to.FlowNode;
import com.ebmwebsourcing.bpmndiagram.business.domain.to.CPat;
import com.ebmwebsourcing.bpmndiagram.business.domain.to.Flow;
import com.ebmwebsourcing.bpmndiagram.business.domain.to.Lane;
import com.ebmwebsourcing.bpmndiagram.business.domain.to.Pool;
import com.ebmwebsourcing.bpmndiagram.business.domain.to.Constants.BPMNObjectType;

/**
 * 
 * @author nfleury
 *
 */
public class CPatVisitor {
	
	@SuppressWarnings("unused")
	private CPat cpat;
	
	private HashMap<String,Flow> flows = new HashMap<String, Flow>();
	
	public CPatVisitor(CPat cpat) {
		this.cpat = cpat;
	
		for(Pool pool:cpat.getParticipant()){
			
			this.visitPool(pool);
			
			for(Lane lane:pool.getLanes()){
			
				this.visitLane(lane);
					
				for(FlowNode flowNode:lane.getServices()){
					
					this.visitFlowNode(flowNode);
					
					for(Flow inSeqFlow:flowNode.getInSeqFlow()){
						flows.put(inSeqFlow.getId(), inSeqFlow);
					}
					for(Flow outSeqFlow:flowNode.getOutgoingSeqFlow()){
						flows.put(outSeqFlow.getId(), outSeqFlow);
					}
					for(Flow inMsgFlow:flowNode.getInMsgFlow()){
						flows.put(inMsgFlow.getId(), inMsgFlow);
					}
					for(Flow outMsgFlow:flowNode.getOutgoingMsgFlow()){
						flows.put(outMsgFlow.getId(), outMsgFlow);
					}
					
					//Specific Flow nodes
					if (flowNode.getType()==BPMNObjectType.Task){
					
						this.visitTask(flowNode);
					
					}else if (flowNode.getType()==BPMNObjectType.SubProcess){
					
						this.visitSubProcess(flowNode);
					
					}else if (flowNode.getType()==BPMNObjectType.ActivityLoop){
					
						this.visitActivityLoop(flowNode);
					
					}else if (flowNode.getType()==BPMNObjectType.DataBasedInclusiveGateway){
						
						this.visitDataBasedInclusiveGateway(flowNode);
						
					}else if (flowNode.getType()==BPMNObjectType.DataBaseExclusiveGateway){
						
						this.visitDataBasedExclusiveGateway(flowNode);
						
					}else if (flowNode.getType()==BPMNObjectType.ParallelGateway){
						
						this.visitParallelGateway(flowNode);
						
					}else if (flowNode.getType()==BPMNObjectType.EventBasedExclusiveGateway){
						
						this.visitEventBasedGateway(flowNode);
						
					}else if (flowNode.getType()==BPMNObjectType.EmptyStartEvent){
						
						this.visitEmptyStartEvent(flowNode);
						
					}else if (flowNode.getType()==BPMNObjectType.EmptyEndEvent){
						
						this.visitEmptyEndEvent(flowNode);
						
					}else if (flowNode.getType()==BPMNObjectType.MessageEvent){
						
						this.visitMessageEvent(flowNode);
						
					}else if (flowNode.getType()==BPMNObjectType.TimerEvent){
						
						this.visitTimerEvent(flowNode);
						
					}else if (flowNode.getType()==BPMNObjectType.ErrorEvent){
						
						this.visitErrorEvent(flowNode);
						
					}else if (flowNode.getType()==BPMNObjectType.RuleEvent){
						
						this.visitRuleEvent(flowNode);
						
					}else if (flowNode.getType()==BPMNObjectType.TerminationEvent){
					
						this.visitTerminationEvent(flowNode);
						
					}
					
				}
			
			}
			
		}
	
		
		for(Flow flow : flows.values()){
			
			if (flow.getFlowType()==BPMNObjectType.SequenceFlow){
			
				this.visitSequenceFlow(flow);
			
			}else if (flow.getFlowType()==BPMNObjectType.MessageFlow){
			
				this.visitMessageFlow(flow);
			
			}
			
			
		}
		
		
		
	}
	
	public void visitPool(Pool pool){}; 
	
	public void visitLane(Lane lane){};
	
	public void visitFlowNode(FlowNode flowNode){};
	
	public void visitSequenceFlow(Flow flow){};
	
	public void visitMessageFlow(Flow flow){};
	
	public void visitTask(FlowNode task){};
	
	public void visitSubProcess(FlowNode subProcess){};
	
	public void visitActivityLoop(FlowNode activityLoop){};
	
	public void visitDataBasedInclusiveGateway(FlowNode dataBasedInclusiveGateway){};
	
	public void visitDataBasedExclusiveGateway(FlowNode dataBasedExclusiveGateway){};
	
	public void visitParallelGateway(FlowNode parallelGateway){};
	
	public void visitEventBasedGateway(FlowNode eventBasedGateway){};
	
	public void visitEmptyStartEvent(FlowNode emptyStartEvent){};
	
	public void visitEmptyEndEvent(FlowNode emptyEntEvent){};
	
	public void visitMessageEvent(FlowNode messageEvent){};
	
	public void visitTimerEvent(FlowNode timerEvent){};
	
	public void visitErrorEvent(FlowNode errorEvent){};
	
	public void visitRuleEvent(FlowNode ruleEvent){};
	
	public void visitTerminationEvent(FlowNode terminationEvent){};
}
