/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.activity;

import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.BPMNElementsPath;
import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.activity.Activity.ActivityMarkerGraphic;

/**
 * This class is designed to retrieve easily path for markers in activities and tasks
 * @author enhan
 *
 */
public class PathHelper {
	
	static public String pathForTaskMarker(TaskElement.TaskMarkerGraphic m){
		switch(m){
		case RECEIVE:
			return BPMNElementsPath.TASK_MARKER_RECEIVE;
		case SEND:
			return BPMNElementsPath.TASK_MARKER_SEND;
		case BUSINESS_RULE:
			return BPMNElementsPath.TASK_MARKER_BUSINESS_RULE;
		case MANUAL : 
			return BPMNElementsPath.TASK_MARKER_MANUAL;
		case SCRIPT : 
			return BPMNElementsPath.TASK_MARKER_SCRIPT;
		case USER : 
			return BPMNElementsPath.TASK_MARKER_USER;
		case SERVICE :
			return BPMNElementsPath.TASK_MARKER_SERVICE;
		}
		return null;
	}
	
	static public String pathForActivityMarker(ActivityMarkerGraphic m){
		switch(m){
		case AD_HOC:
			return BPMNElementsPath.ACTIVITY_MARKER_AD_HOC;
		case COMPENSATION:
			return BPMNElementsPath.ACTIVITY_MARKER_COMPENSATION;
		case LOOP:
			return BPMNElementsPath.ACTIVITY_MARKER_LOOP;
		case PARALLEL:
			return BPMNElementsPath.ACTIVITY_MARKER_PARALLEL;
		case SEQUENCIAL:
			return BPMNElementsPath.ACTIVITY_MARKER_SEQUENCIAL;
		case SUBPROCESS_COLLAPSE:
			return BPMNElementsPath.ACTIVITY_MARKER_SUBPROCESS_COLLAPSED;
		case SUBPROCESS_EXPAND:
			return BPMNElementsPath.ACTIVITY_MARKER_SUBPROCESS_EXTENDED;
		}
		return null;
	}

}
