/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.business.domain.to;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;



/**
 * This class is used to get all public informations about an user <br />
 * This class shouldn't be persisted
 * 
 * @author mcarpentier
 * 
 */
public class Lane implements Serializable {

    private static final long serialVersionUID = -4217847504186801919L;

    private String id;

    /** entity details* */
    private String name;
    private Pool pool;
    private List<FlowNode> services = new ArrayList<FlowNode>();
    private String positionX;
    private String positionY;
    private String width;
    private String height;

    public String getName() {
        return name;
    }

    public String getId() {
        return id;
    }
    public Pool getPool() {
        return pool;
    }
    
    public List<FlowNode> getServices() {
        return services;
    }
    public String getPositionX() {
        return positionX;
    }
    
    public String getPositionY() {
        return positionY;
    }
    public String getWidth() {
        return width;
    }
    
    public String getHeight() {
        return height;
    }
    public void setName(final String name) {
        this.name = name;
    }

    public void addService(FlowNode activity){
    	this.services.add(activity);
    	activity.setLane(this);
    }
    
    public void setId(final String id) {
        this.id = id;
    }
    
    public void setPool(final Pool pool) {
        this.pool = pool;
    }
    
    public void setServices(final List<FlowNode> service) {
        this.services = service;
    }
    public void setPositionX(String positionX) {
        this.positionX = positionX;
    }
    public void setPositionY(String positionY) {
        this.positionY = positionY;
    }
    public void setWidth(String width) {
        this.width = width;
    }
    public void setHeight(String height) {
        this.height = height;
    }
}
