/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.activity;

import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.activity.Activity.ActivityMarkerGraphic;
import com.ebmwebsourcing.gwt.raphael.client.core.Path;
import com.ebmwebsourcing.gwt.raphael.client.diagram.element.DiagramElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;



class ActivityMarkerElement extends DiagramElement implements HasClickHandlers{
	
	private ActivityMarkerGraphic marker;
	
	public ActivityMarkerElement(ActivityMarkerGraphic marker, int x, int y) {
		super(new Path(DOM.createUniqueId(), PathHelper.pathForActivityMarker(marker), x, y));
		this.marker = marker;
	}

	public ActivityMarkerGraphic getMarker() {
		return marker;
	}
	
	@Override
	protected void onLoad(){
		super.onLoad();
		this.getSvgElement().attr("fill", "black");
		this.getSvgElement().attr("stroke-width","0.5");
		getElement().setAttribute("background-color", "red");
	}

	public HandlerRegistration addClickHandler(ClickHandler handler) {
		return addHandler(handler, ClickEvent.getType());
	}
}
