/**
 * BPMN Diagram - SVG/VML web based editor for BPMN Standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.foundation.eventlogic;

import com.ebmwebsourcing.bpmndiagram.presentation.gwt.client.bpmn1.activity.Activity.ActivityMarkerGraphic;
import com.google.gwt.event.shared.GwtEvent;

public class ActivityMarkerGraphicsEvent extends GwtEvent<ActivityMarkerHandler> {

	public enum OpType{
		ADD,
		REMOVE
	}
	
	
	static public Type<ActivityMarkerHandler> getType(){
		if (TYPE == null){
			TYPE = new Type<ActivityMarkerHandler>();
		}
		return TYPE;
	}
	
	public static void fireAddActivityMarkerGraphic(HasActivityMarkersHandlers source, ActivityMarkerGraphic marker){
		if (TYPE != null){
			ActivityMarkerGraphicsEvent ev = new ActivityMarkerGraphicsEvent(OpType.ADD, marker);
			source.fireEvent(ev);
		}
	}
	
	public static void fireRemoveActivityMarkerGraphic(HasActivityMarkersHandlers source, ActivityMarkerGraphic marker){
		if(TYPE != null){
			ActivityMarkerGraphicsEvent ev = new ActivityMarkerGraphicsEvent(OpType.REMOVE, marker);
			source.fireEvent(ev);
		}
	}
	
	private static Type<ActivityMarkerHandler> TYPE;
	
	private OpType operation;
	private ActivityMarkerGraphic marker;
	
	protected ActivityMarkerGraphicsEvent(OpType opType, ActivityMarkerGraphic target) {
		operation = opType;
		marker = target;
	}
	
	
	@Override
	protected void dispatch(ActivityMarkerHandler handler) {
		handler.onActivityMarkerGraphicsEvent(this);
	}

	@Override
	public Type<ActivityMarkerHandler> getAssociatedType() {
		return TYPE;
	}

	public OpType getOperation() {
		return operation;
	}

	public ActivityMarkerGraphic getMarker() {
		return marker;
	}

	
	
}
