/**
 * BPMN Editor Collaborative client - A collaboration platform client for the BPMN Editor - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.bpmneditor.collaboration.comet.client.editor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import com.ebmwebsourcing.bpmneditor.business.domain.bpmn2.to.standard.collaboration.CollaborationBean;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.bpmneditor.BPMNEditor;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.bpmneditor.bpmn2.renderer.DefinitionsSyntaxModel;
import com.ebmwebsourcing.bpmneditor.presentation.gwt.client.bpmneditor.bpmn2.syntax.BPMN2Syntax;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.component.MenuComponent;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.event.DrawingPanelTabListener;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.layout.DrawingPanel;
import com.ebmwebsourcing.webdesigner.presentation.gwt.client.log.AbstractLogEntry;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Container;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.event.ContainerListenerAdapter;
import com.gwtext.client.widgets.menu.BaseItem;
import com.gwtext.client.widgets.menu.Menu;
import com.gwtext.client.widgets.menu.MenuItem;
import com.gwtext.client.widgets.menu.event.BaseItemListenerAdapter;

public abstract class AbstractCollaborativeStandAloneBPMNEditor {
	
	/**
	 * Boolean indicating that the gadget has just been created and has not been synchronized yet.
	 */
	protected boolean isNewbie;
	/**
	 * The models of the initial contents of the editor's drawing panel mapped by their ids.
	 */
	protected Map<String,DefinitionsSyntaxModel> definitions;
	
	
	protected static final String VOExampleName = "VOExample.xml";
	
//	protected ModelTransferServiceAsync service;
//	protected String path;
	
	protected BPMNEditor bpmneditor;
	protected BPMN2Syntax syntax;
	
	
	public AbstractCollaborativeStandAloneBPMNEditor(){
		this.definitions = new HashMap<String, DefinitionsSyntaxModel>();
		this.isNewbie = true;
	}
	
	/**
	 * @return The name/id of the participant viewing the gadget
	 */
	public abstract String getParticipant();
	/**
	 * Pushes the definitions whose id are "id" to the other participants
	 * This method is to be called when a new DrawingPanel is opened. 
	 * @param id
	 */
	public abstract void pushDefs(String id);
	
	/**
	 * Pushes a modification operated by the user on the currently edited model.
	 * @param entry
	 */
	public abstract void pushModif(AbstractLogEntry entry);
	
	/**
	 * Pushes the id of the currently observed model.
	 * This method is to be called when a the user shifts from a drawing panel
	 * to another.
	 * @param defsId
	 */
	public abstract void pushCurrentDPId(String defsId);
	
	/**
	 * Pushes the id of the model whose drawing panel has just been closed.
	 * @param defsId
	 */
	public abstract void pushClosingDPId(String defsId);
	
	/**
	 * Pushes the request of the user to lock the other clients.
	 */
	public abstract void lock();
	
	/**
	 * Pushes the request of the user to unlock the other clients.
	 */
	public abstract void unlock();
	
	public abstract String createUniqueId();	
	
	
	
	public void displayModel(final DefinitionsSyntaxModel defs) {
		definitions.put(defs.getId(),defs);
		
		if(syntax==null){
			this.syntax = new BPMN2Syntax();
		}
		
		bpmneditor.loadDiagram(syntax, defs);
	}

	
	
	
	
	/**
	 * Adds a menu with a lock and unlock button that locks/unlocks the current drawingPanel
	 * @param bpmneditor
	 */
	protected void addWaveMenu(){
		MenuComponent menu = bpmneditor.getMenuComponent();

		ToolbarButton button = new ToolbarButton("Wave");
		Menu lockMenu = new Menu();
		lockMenu.setTitle("Wave Menu");
		
		button.setMenu(lockMenu);
		
		MenuItem lockItem = new MenuItem();
		lockItem.setText("Lock");
		lockItem.addListener(new BaseItemListenerAdapter() {
			public void onClick(BaseItem item, EventObject e) {
				AbstractCollaborativeStandAloneBPMNEditor.this.lock();
			}
		});
		
		lockMenu.addItem(lockItem);
		lockMenu.addSeparator();
		
		
		MenuItem unlockItem = new MenuItem();
		unlockItem.setText("Unlock");
		unlockItem.addListener(new BaseItemListenerAdapter() {
			public void onClick(BaseItem item, EventObject e) {
				AbstractCollaborativeStandAloneBPMNEditor.this.unlock();
			}
		});
		
		lockMenu.addItem(unlockItem);
		lockMenu.addSeparator();
		
		menu.addButton(button);
	}
	
	
	protected void addDrawingPanelTabListener(){
		bpmneditor.getRegistry().getLayout().getDrawingPanelTab().addListener(new DrawingPanelTabListener() {
			public void onTabChange(DrawingPanel currentDrawingPanel) {
				pushCurrentDPId(currentDrawingPanel.getSyntaxModel().getId()); 
			}
		});
		
		bpmneditor.getRegistry().getLayout().getDrawingPanelTab().addListener(new ContainerListenerAdapter() {
			public boolean doBeforeRemove(Container self, Component component) {
				String modelId = ((DrawingPanel)component).getSyntaxModel().getId();
				definitions.remove(modelId);
				pushClosingDPId(modelId);
				return true;
			}
		});
	}

	
	
	public void initDefs(String id) {
		if(definitions.get(id)==null){
			definitions.put(id, new DefinitionsSyntaxModel(id));
		}
		if(definitions.get(id).getCollaborations().isEmpty()){
			CollaborationBean collab = new CollaborationBean(createUniqueId()); 
			definitions.get(id).addCollaboration(collab);
		}
	}
	
	
	
	
	public DefinitionsSyntaxModel getDefinitions(String id){
		return definitions.get(id);
	}
	
	
	public Collection<DefinitionsSyntaxModel> getAllDefinitions(){
		return definitions.values();
	}
	
	
	public void addDefinitions(DefinitionsSyntaxModel defs){
		this.definitions.put(defs.getId(), defs);
	}
	
	
	public BPMNEditor getBPMNEditor(){
		return bpmneditor;
	}
	
	public boolean isNewbie(){
		return isNewbie;
	}
}
